/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.StatsOwner;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.SnoozeAlarm;
import org.rvpf.base.util.Version;
import org.rvpf.service.ServiceActivatorBase;
import org.rvpf.service.ServiceBase;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceStats;
import org.rvpf.service.ServiceThread;

public abstract class ServiceBaseImpl
implements ServiceBase,
Runnable {
    private String _logID;
    private volatile Logger _logger;
    private final Object _mutex = new Object();
    private volatile ServiceActivatorBase _serviceActivatorBase;
    private String _serviceName;
    private volatile SnoozeAlarm _snoozeAlarm;
    private final AtomicReference<List<ServiceStats>> _stats = new AtomicReference();
    private boolean _terminating;
    private final AtomicReference<Thread> _thread = new AtomicReference();
    private volatile Optional<Timer> _timer = Optional.empty();

    @Override
    public final void addStats(ServiceStats serviceStats) {
        serviceStats.setLogEnabled(this.getStats().isLogEnabled());
        List<ServiceStats> stats = this._stats.get();
        if (stats != null) {
            stats.add(serviceStats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail() {
        Object object = this._mutex;
        synchronized (object) {
            if (!this._terminating) {
                this._terminating = true;
                this.stopTimer();
                this._serviceActivatorBase.terminate();
            }
        }
    }

    @Override
    public final String getServiceName() {
        return Require.notNull(this._serviceName);
    }

    @Override
    public ServiceStats getStats() {
        List<ServiceStats> stats = this._stats.get();
        while (stats == null) {
            ServiceStats serviceStats = this.createStats(this.getServiceActivatorBase());
            stats = new LinkedList<ServiceStats>();
            stats.add(serviceStats);
            if (this._stats.compareAndSet(null, stats)) break;
            stats = this._stats.get();
        }
        return stats.get(0);
    }

    @Override
    public final Optional<Timer> getTimer() {
        return this._timer;
    }

    @Override
    public boolean isJMXRegistrationEnabled() {
        return false;
    }

    public final void setServiceName(@Nonnull String serviceName) {
        this._serviceName = Require.notNull(serviceName);
    }

    @Override
    public final void snooze(ElapsedTime snoozeTime) throws InterruptedException {
        SnoozeAlarm snoozeAlarm = this._snoozeAlarm;
        if (snoozeAlarm == null) {
            throw new InterruptedException();
        }
        Require.ignored(snoozeAlarm.snooze(snoozeTime));
    }

    @Override
    public final void starting(Optional<ElapsedTime> waitHint) {
        this._serviceActivatorBase.starting(waitHint);
    }

    @Override
    public final void stopping(Optional<ElapsedTime> waitHint) {
        this._serviceActivatorBase.stopping(waitHint);
    }

    public String toString() {
        return this.getServiceName();
    }

    @Override
    public final void uncaughtException(Thread thread, Throwable throwable) {
        if (!(throwable instanceof ServiceThread.SilentException)) {
            this.getThisLogger().uncaughtException(thread, throwable);
        }
        this.fail();
    }

    @Override
    public final void wakeUp() {
        SnoozeAlarm snoozeAlarm = this._snoozeAlarm;
        if (snoozeAlarm != null) {
            snoozeAlarm.wakeUp();
        }
    }

    protected final void closeSnoozeAlarm() {
        SnoozeAlarm snoozeAlarm = this._snoozeAlarm;
        if (snoozeAlarm != null) {
            snoozeAlarm.close();
        }
    }

    @Nonnull
    @CheckReturnValue
    protected abstract ServiceStats createStats(@Nonnull StatsOwner var1);

    @Nonnull
    @CheckReturnValue
    protected final Optional<String> getLogID() {
        return Optional.ofNullable(this._logID);
    }

    @Nonnull
    @CheckReturnValue
    protected final ServiceActivatorBase getServiceActivatorBase() {
        return Require.notNull(this._serviceActivatorBase);
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        Logger logger = this._logger;
        if (logger == null) {
            this._logger = logger = Logger.getInstance(this.getClass());
        }
        return logger;
    }

    @Nonnull
    @CheckReturnValue
    protected Thread getThread() {
        return this._thread.get();
    }

    @Nonnull
    @CheckReturnValue
    protected Version getVersion() {
        return this._serviceActivatorBase.getVersion();
    }

    protected final void interrupt() {
        Thread thread = this._thread.get();
        if (thread != null) {
            this.getThisLogger().debug(ServiceMessages.THREAD_INTERRUPT, thread.getName());
            thread.interrupt();
        }
    }

    @CheckReturnValue
    protected final boolean isCurrentThread() {
        return this._thread.get() == Thread.currentThread();
    }

    @CheckReturnValue
    protected final boolean isThreadStarted() {
        return this._thread.get() != null;
    }

    @CheckReturnValue
    protected final boolean join() {
        Thread thread = this._thread.get();
        if (thread != null) {
            this.getThisLogger().debug(ServiceMessages.THREAD_JOIN, thread.getName());
            try {
                thread.join();
                if (thread.isAlive()) {
                    this.getThisLogger().warn(ServiceMessages.THREAD_JOIN_TIMEOUT, thread.getName());
                } else {
                    this.getThisLogger().debug(ServiceMessages.THREAD_JOINED, thread.getName());
                }
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                this.getThisLogger().warn(ServiceMessages.THREAD_JOIN_INTERRUPTED, thread.getName());
            }
            return !thread.isAlive();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void logStats(boolean intermediate) {
        List<ServiceStats> stats = this._stats.get();
        if (stats != null) {
            Object object = this._mutex;
            synchronized (object) {
                for (ServiceStats serviceStats : stats) {
                    serviceStats.log(intermediate);
                }
            }
        }
    }

    protected final void scheduleMidnightLogger() {
        Optional<Timer> timer = this.getTimer();
        if (timer.isPresent()) {
            TimerTask timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ServiceBaseImpl.this._getMutex();
                    synchronized (object) {
                        if (ServiceBaseImpl.this.getTimer().isPresent()) {
                            Logger.getMidnightLogger().info(ServiceMessages.MIDNIGHT, new Object[0]);
                            ServiceBaseImpl.this.logStats(true);
                            ServiceBaseImpl.this.scheduleMidnightLogger();
                        }
                    }
                }
            };
            DateTime midnight = DateTime.now().nextDay();
            try {
                timer.get().schedule(timerTask, midnight.toTimestamp());
            }
            catch (IllegalStateException exception) {
                this.getThisLogger().debug(ServiceMessages.MIDNIGHT_LOG_CANCELED, new Object[0]);
                return;
            }
            this.getThisLogger().debug(ServiceMessages.MIDNIGHT_LOG_SCHEDULED, midnight);
        } else {
            this.getThisLogger().debug(ServiceMessages.MIDNIGHT_LOG_CANCELED, new Object[0]);
        }
    }

    protected final void setLogID(@Nonnull Optional<String> logID) {
        Logger.setLogID(logID);
        this._logID = Logger.currentLogID().orElse(null);
    }

    protected final void setServiceActivatorBase(@Nonnull ServiceActivatorBase serviceActivatorBase) {
        Require.equal(null, this._serviceActivatorBase);
        this._serviceActivatorBase = Require.notNull(serviceActivatorBase);
    }

    @CheckReturnValue
    @OverridingMethodsMustInvokeSuper
    protected boolean setUp() {
        this._snoozeAlarm = new SnoozeAlarm(this);
        Logger.setLogID(Optional.ofNullable(this._logID));
        return true;
    }

    protected final void startThread() {
        Thread thread = new Thread((Runnable)this, this._serviceName);
        if (this._thread.compareAndSet(null, thread)) {
            thread.setUncaughtExceptionHandler(this);
            this._logID = Logger.currentLogID().orElse(null);
            this.getThisLogger().debug(ServiceMessages.STARTING_THREAD, thread.getName());
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void startTimer() {
        Object object = this._mutex;
        synchronized (object) {
            if (!this._timer.isPresent()) {
                this._timer = Optional.of(new Timer("Service thread timer"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void stopTimer() {
        Object object = this._mutex;
        synchronized (object) {
            Optional<Timer> timer = this._timer;
            this._timer = Optional.empty();
            if (timer.isPresent()) {
                timer.get().cancel();
            }
        }
    }

    protected void tearDown() {
        this._snoozeAlarm = null;
        this.stopTimer();
        this._stats.set(null);
        System.gc();
    }

    protected void updateStats() {
    }

    @Nonnull
    @CheckReturnValue
    final Object _getMutex() {
        return this._mutex;
    }
}

