/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ClassDef;
import org.rvpf.base.UUID;
import org.rvpf.base.alert.Alert;
import org.rvpf.base.alert.Error;
import org.rvpf.base.alert.Fatal;
import org.rvpf.base.alert.Info;
import org.rvpf.base.alert.Warning;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.config.Config;
import org.rvpf.config.UndefinedEntityException;
import org.rvpf.config.entity.ClassLibEntity;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;

public final class ServiceClassLoader
extends ClassLoader
implements ClassDef.Loader,
Alert.Dispatcher {
    public static final String CACHE_SECTION_NAME = "jars";
    public static final String CLASSLIB_DIR_PROPERTY = "classlib.dir";
    public static final String CLASSLIB_SERVER_PROPERTY = "classlib.server";
    static final Logger _LOGGER = Logger.getInstance(ServiceClassLoader.class);
    private static final int _STREAM_BUFFER_SIZE = 8192;
    private static final Map<ClassLoader, Reference<_ParentClassLoader>> _CHILDREN = new IdentityHashMap<ClassLoader, Reference<_ParentClassLoader>>();
    private File _cache;
    private Config _config;
    private URI _masterURI;

    private ServiceClassLoader(_ParentClassLoader parent) {
        super(parent);
        _LOGGER.debug(ServiceMessages.CLASS_LOADER_INSTANTIATED, parent.getParent());
    }

    @Nonnull
    @CheckReturnValue
    public static ServiceClassLoader getInstance() {
        return ServiceClassLoader.getInstance(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    public static ServiceClassLoader getInstance(@Nonnull ClassLoader parent) {
        ServiceClassLoader instance;
        if (parent instanceof ServiceClassLoader) {
            instance = (ServiceClassLoader)parent;
        } else {
            _ParentClassLoader child;
            Map<ClassLoader, Reference<_ParentClassLoader>> map = _CHILDREN;
            synchronized (map) {
                Reference<_ParentClassLoader> reference = _CHILDREN.get(parent);
                _ParentClassLoader _ParentClassLoader2 = child = reference != null ? reference.get() : null;
                if (child == null) {
                    child = new _ParentClassLoader(parent);
                    _CHILDREN.put(parent, new WeakReference<_ParentClassLoader>(child));
                }
            }
            instance = new ServiceClassLoader(child);
        }
        return instance;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<ServiceClassLoader> hideInstance() {
        if (Thread.currentThread().getContextClassLoader() instanceof ServiceClassLoader) {
            ServiceClassLoader serviceClassLoader = (ServiceClassLoader)Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(serviceClassLoader.getParent().getParent());
            return Optional.of(serviceClassLoader);
        }
        return Optional.empty();
    }

    public static void restoreInstance(@Nonnull Optional<ServiceClassLoader> serviceClassLoader) {
        if (serviceClassLoader.isPresent()) {
            serviceClassLoader.get().activate();
        }
    }

    public void activate() {
        Thread.currentThread().setContextClassLoader(this);
    }

    public synchronized void addFromClassLib(@Nonnull ClassLibEntity classLib) throws UndefinedEntityException {
        if (!classLib.isDefined()) {
            throw new UndefinedEntityException(classLib);
        }
        if (classLib.isAdded()) {
            return;
        }
        LinkedList<URL> urls = new LinkedList<URL>();
        for (URI location : classLib.getLocations()) {
            this._addFromLocation(location, urls);
        }
        for (URL url : urls) {
            if (classLib.isCached(false)) {
                if ((url = this._cacheURL(url, classLib.getUUID().get())) == null) continue;
                this._addURL(url);
                break;
            }
            this._addURL(url);
        }
        classLib.setAdded(true);
        this.addFromClassLibs(classLib.getClassLibs());
    }

    public synchronized void addFromClassLibs(@Nonnull List<ClassLibEntity> classLibs) throws UndefinedEntityException {
        for (ClassLibEntity classLib : classLibs) {
            this.addFromClassLib(classLib);
        }
    }

    public synchronized void addFromLocation(@Nonnull String location) {
        try {
            this.addFromLocation(new URI(location));
        }
        catch (URISyntaxException exception) {
            _LOGGER.warn(ServiceMessages.BAD_LOCATION, location);
        }
    }

    public synchronized void addFromLocation(@Nonnull URI location) {
        LinkedList<URL> urls = new LinkedList<URL>();
        this._addFromLocation(location, urls);
        for (URL url : urls) {
            this._addURL(url);
        }
    }

    @Override
    public void dispatchAlert(Logger.LogLevel alertLevel, String alertName, String info) {
        Optional<Config> config = this.getConfig();
        if (config.isPresent() && config.get().hasService()) {
            Info alert;
            Service service = config.get().getService();
            String serviceName = service.getServiceName();
            Optional<String> entityName = service.getEntityName();
            UUID sourceUUID = service.getOptionalSourceUUID().orElse(null);
            switch (alertLevel) {
                case FATAL: {
                    alert = new Fatal(alertName, Optional.of(serviceName), entityName, Optional.ofNullable(sourceUUID), Optional.ofNullable(info));
                    break;
                }
                case ERROR: {
                    alert = new Error(alertName, Optional.of(serviceName), entityName, Optional.ofNullable(sourceUUID), Optional.ofNullable(info));
                    break;
                }
                case WARN: {
                    alert = new Warning(alertName, Optional.of(serviceName), entityName, Optional.ofNullable(sourceUUID), Optional.ofNullable(info));
                    break;
                }
                default: {
                    alert = new Info(alertName, Optional.of(serviceName), entityName, Optional.ofNullable(sourceUUID), Optional.ofNullable(info));
                }
            }
            service.sendAlert(alert);
        }
    }

    public synchronized void forgetConfig(@Nonnull Config config) {
        if (this._config == Require.notNull(config)) {
            this._config = null;
        }
    }

    @Nonnull
    @CheckReturnValue
    public synchronized Optional<Config> getConfig() {
        return Optional.ofNullable(this._config);
    }

    @Nonnull
    @CheckReturnValue
    public URL[] getURLs() {
        return ((URLClassLoader)this.getParent()).getURLs();
    }

    @Override
    public boolean isLoaded(String className) {
        return this.findLoadedClass(className) != null;
    }

    public synchronized void useConfig(@Nonnull Config config) {
        this._config = config;
    }

    @Nonnull
    @CheckReturnValue
    static Map<ClassLoader, Reference<_ParentClassLoader>> getChildren() {
        return _CHILDREN;
    }

    private void _addFromLocation(URI location, List<URL> urls) {
        URL wildURL;
        URI absoluteURI = location.isAbsolute() ? location : this._masterURI().resolve(location);
        try {
            wildURL = absoluteURI.toURL();
        }
        catch (MalformedURLException exception) {
            _LOGGER.warn(ServiceMessages.BAD_URL, location);
            return;
        }
        if ("file".equalsIgnoreCase(wildURL.getProtocol()) && wildURL.getFile().toLowerCase(Locale.ROOT).endsWith(".jar")) {
            File wildFile = new File(wildURL.getFile());
            String wildName = wildFile.getName();
            boolean isWild = wildName.indexOf(42) >= 0 || wildName.indexOf(63) >= 0;
            File wildDirectory = wildFile.getParentFile();
            if (isWild && wildDirectory != null) {
                final Pattern wildPattern = ValueConverter.wildToPattern(wildName);
                File[] files = Require.notNull(wildDirectory.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File directory, String name) {
                        return wildPattern.matcher(name).matches();
                    }
                }));
                if (files.length == 0) {
                    _LOGGER.warn(ServiceMessages.NO_MATCH_FOR_LIB_JAR, wildName, wildDirectory);
                }
                for (File file : files) {
                    try {
                        urls.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException exception) {
                        throw new RuntimeException(exception);
                    }
                }
            } else {
                urls.add(wildURL);
            }
        } else {
            urls.add(wildURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addURL(URL url) {
        _ParentClassLoader parent;
        if ("file".equalsIgnoreCase(url.getProtocol()) && !new File(URI.create(url.toString())).exists()) {
            _LOGGER.warn(ServiceMessages.FILE_NOT_FOUND, url);
            return;
        }
        _ParentClassLoader _ParentClassLoader2 = parent = (_ParentClassLoader)this.getParent();
        synchronized (_ParentClassLoader2) {
            for (URL parentURL : parent.getURLs()) {
                if (parentURL == null || !url.toExternalForm().equals(parentURL.toExternalForm())) continue;
                return;
            }
            parent.addURL(url);
            _LOGGER.debug(ServiceMessages.ADDED_TO_CLASSPATH, url);
        }
    }

    private URL _cacheURL(URL url, UUID uuid) {
        if ("file".equalsIgnoreCase(url.getProtocol()) && !url.getFile().toLowerCase(Locale.ROOT).endsWith(".jar")) {
            return url;
        }
        if (this._cache == null && this._config != null) {
            this._cache = this._config.getCacheDir(CACHE_SECTION_NAME, Optional.empty(), Optional.empty());
        }
        if (this._cache != null) {
            String fileName = uuid.toName() + ".jar";
            File cachedFile = new File(this._cache, fileName);
            try {
                URI uri = url.toURI();
                if (uri.getPath().endsWith("/")) {
                    url = new URI(uri.getScheme(), uri.getHost(), uri.getPath() + fileName, uri.getFragment()).toURL();
                }
                URLConnection connection = url.openConnection();
                long after = cachedFile.lastModified();
                if (after > 0L) {
                    connection.setIfModifiedSince(after);
                }
                connection.connect();
                long lastModified = connection.getLastModified();
                if (lastModified > after) {
                    int length;
                    File temporaryFile = new File(this._cache, uuid.toName() + ".tmp");
                    InputStream connectionStream = connection.getInputStream();
                    FileOutputStream fileStream = new FileOutputStream(temporaryFile);
                    byte[] buffer = new byte[8192];
                    while ((length = connectionStream.read(buffer)) >= 0) {
                        ((OutputStream)fileStream).write(buffer, 0, length);
                    }
                    ((OutputStream)fileStream).close();
                    connectionStream.close();
                    if (cachedFile.exists() && !cachedFile.delete()) {
                        _LOGGER.warn(BaseMessages.FILE_DELETE_FAILED, cachedFile);
                        return null;
                    }
                    if (!temporaryFile.renameTo(cachedFile)) {
                        _LOGGER.warn(BaseMessages.FILE_RENAME_FAILED, temporaryFile, cachedFile);
                        return null;
                    }
                    if (!cachedFile.setLastModified((lastModified + 999L) / 1000L * 1000L)) {
                        _LOGGER.warn(ServiceMessages.SET_FILE_MODIFIED_FAILED, cachedFile);
                    }
                }
            }
            catch (Exception exception) {
                _LOGGER.warn(ServiceMessages.JAR_LOAD_FAILED, url, exception.getMessage());
            }
            if (cachedFile.exists()) {
                try {
                    url = cachedFile.toURI().toURL();
                }
                catch (MalformedURLException exception) {
                    throw new RuntimeException(exception);
                }
            } else {
                url = null;
            }
        } else {
            url = null;
        }
        return url;
    }

    private URI _masterURI() {
        if (this._masterURI == null) {
            if (this._config != null) {
                Optional<String> serverProperty = this._config.getStringValue(CLASSLIB_SERVER_PROPERTY);
                if (serverProperty.isPresent()) {
                    try {
                        URI serverURI = new URI(serverProperty.get());
                        this._masterURI = serverURI.getPath().endsWith("/") ? serverURI : new URI(serverURI.getScheme(), serverURI.getHost(), serverURI.getPath() + "/", serverURI.getFragment());
                    }
                    catch (URISyntaxException exception) {
                        _LOGGER.warn(ServiceMessages.CLASS_LIB_ADDRESS_BAD, serverProperty.get(), exception.getMessage());
                    }
                }
                if (this._masterURI == null) {
                    Optional<String> dirProperty = this._config.getStringValue(CLASSLIB_DIR_PROPERTY);
                    if (dirProperty.isPresent()) {
                        File dir = new File(dirProperty.get());
                        if (dir.isDirectory()) {
                            this._masterURI = dir.toURI();
                        } else {
                            _LOGGER.warn(ServiceMessages.CLASS_LIB_DIR_NOT_FOUND, dirProperty.get(), dir.getAbsolutePath());
                            this._masterURI = Config.CWD_URI;
                        }
                    } else {
                        this._masterURI = Config.CWD_URI;
                    }
                }
            } else {
                this._masterURI = Config.CWD_URI;
            }
        }
        return this._masterURI;
    }

    private static final class _ParentClassLoader
    extends URLClassLoader {
        private static final URL[] _EMPTY_URL_ARRAY = new URL[0];

        _ParentClassLoader(ClassLoader parent) {
            super(_EMPTY_URL_ARRAY, parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return super.loadClass(name);
            }
            catch (NoClassDefFoundError exception) {
                _LOGGER.debug(ServiceMessages.CLASS_LOAD_FAILED, name);
                throw exception;
            }
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            Map<ClassLoader, Reference<_ParentClassLoader>> children;
            Map<ClassLoader, Reference<_ParentClassLoader>> map = children = ServiceClassLoader.getChildren();
            synchronized (map) {
                _ParentClassLoader child;
                ClassLoader parent = this.getParent();
                Reference<_ParentClassLoader> reference = children.get(parent);
                _ParentClassLoader _ParentClassLoader2 = child = reference != null ? reference.get() : null;
                if (child == null || child == this) {
                    children.remove(parent);
                }
            }
            super.finalize();
        }
    }
}

