/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.tool.Require;
import org.rvpf.config.ConfigProperties;
import org.rvpf.config.entity.ClassLibEntity;
import org.rvpf.service.ServiceMessages;

@NotThreadSafe
public final class ServiceContext
extends ConfigProperties {
    private static final long serialVersionUID = 1L;
    private final List<ClassLibEntity> _classLibs = new LinkedList<ClassLibEntity>();
    private Set<String> _serviceAliases;
    private String _serviceName;

    public ServiceContext() {
        super(ServiceMessages.SERVICE_TYPE);
    }

    @Override
    public void add(@Nonnull String key, @Nonnull Object value) {
        super.add(key, value);
    }

    public void addClassLib(@Nonnull ClassLibEntity classLib) {
        this.checkNotFrozen();
        this._classLibs.add(classLib);
    }

    public void addServiceAlias(@Nonnull String alias) {
        this.checkNotFrozen();
        if (this._serviceAliases == null) {
            this._serviceAliases = new HashSet<String>();
        }
        this._serviceAliases.add(alias);
    }

    @Override
    public ServiceContext copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceContext freeze() {
        super.freeze();
        return this;
    }

    @Nonnull
    @CheckReturnValue
    public List<ClassLibEntity> getClassLibs() {
        return this._classLibs;
    }

    @Nonnull
    @CheckReturnValue
    public Set<String> getServiceAliases() {
        return this._serviceAliases != null ? this._serviceAliases : Collections.emptySet();
    }

    @Nonnull
    @CheckReturnValue
    public String getServiceName() {
        return Require.notNull(this._serviceName);
    }

    @Override
    public void setOverriden(ConfigProperties overriden) {
        super.setOverriden(overriden);
    }

    @Override
    public void setOverrider(ConfigProperties overrider) {
        super.setOverrider(overrider);
    }

    public void setServiceName(@Nonnull String serviceName) {
        this._serviceName = Require.notNull(serviceName);
    }

    @Override
    @Nonnull
    public void setValue(@Nonnull String key, Object value) {
        super.setValue(key, value);
    }
}

