/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.StatsOwner;
import org.rvpf.base.UUID;
import org.rvpf.base.alert.Alert;
import org.rvpf.base.alert.Event;
import org.rvpf.base.alert.Signal;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.MemoryLogger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.store.StoreAccessException;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.SignalTarget;
import org.rvpf.config.Config;
import org.rvpf.config.ConfigProperties;
import org.rvpf.document.loader.ConfigDocumentLoader;
import org.rvpf.jmx.Agent;
import org.rvpf.service.Alerter;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceActivator;
import org.rvpf.service.ServiceActivatorBase;
import org.rvpf.service.ServiceBaseImpl;
import org.rvpf.service.ServiceClassLoader;
import org.rvpf.service.ServiceContext;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceStats;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.ServicesMonitor;
import org.rvpf.service.rmi.ServiceRegistry;
import org.rvpf.service.rmi.SessionFactory;

public abstract class ServiceImpl
extends ServiceBaseImpl
implements Service,
Alerter.Listener {
    public static final ElapsedTime DEFAULT_JOIN_TIMEOUT = ElapsedTime.fromMillis(60000L);
    public static final ElapsedTime DEFAULT_RESTART_DELAY = ElapsedTime.fromMillis(60000L);
    public static final ElapsedTime DEFAULT_STARTING_EXTEND = ElapsedTime.fromMillis(60000L);
    public static final ElapsedTime DEFAULT_STOPPING_EXTEND = ElapsedTime.fromMillis(60000L);
    public static final String DEPENDENCY_PROPERTY = "service.dependency";
    public static final String JOIN_TIMEOUT_PROPERTY = "service.interrupt.timeout";
    public static final String MEMORY_LOG_INTERVAL_PROPERTY = "service.memory.log.interval";
    public static final String MONITOR_DISABLED_PROPERTY = "service.monitor.disabled";
    public static final String RESTART_ALLOWED_PROPERTY = "service.restart.allowed";
    public static final String RESTART_DELAY_PROPERTY = "service.restart.delay";
    public static final String RESTART_IGNORED_PROPERTY = "service.restart.ignored";
    public static final String SERVICE_LOG_ID_PROPERTY = "service.log.id";
    public static final String SERVICE_UUID_PROPERTY = "service.uuid";
    public static final String STARTING_EXTEND_PROPERTY = "service.starting.extend";
    public static final String STARTUP_DELAY_PROPERTY = "service.startup.delay";
    public static final String STATS_LOG_ENABLED_PROPERTY = "service.stats.log.enabled";
    public static final String STOPPING_EXTEND_PROPERTY = "service.stopping.extend";
    public static final String ZOMBIE_ENABLED_PROPERTY = "service.zombie.enabled";
    private volatile Alerter _alerter;
    private volatile ServiceClassLoader _classLoader;
    private volatile Config _config;
    private volatile Object _configState;
    private volatile String _configURL;
    private volatile boolean _exported;
    private volatile boolean _jmxRegistrationEnabled;
    private volatile ElapsedTime _joinTimeout;
    private final ServicesMonitor _monitor = new ServicesMonitor();
    private volatile boolean _monitorEnabled;
    private volatile Collection<ServicesMonitor.Monitored> _monitoredServices;
    private final Object _mutex = new Object();
    private volatile boolean _pinged;
    private volatile ConfigProperties _properties;
    private volatile boolean _registered;
    private boolean _restartAllowed;
    private boolean _restartEnabled;
    private boolean _restartInitiated;
    private boolean _restartRequested;
    private volatile boolean _restartSignaled;
    private volatile UUID _serviceUUID;
    private AtomicReference<UUID> _sourceUUID = new AtomicReference();
    private volatile _State _state = _State.NONE;
    private boolean _stopRequested;
    private final ReadWriteLock _suspendLock = new ReentrantReadWriteLock(true);
    private volatile Thread _suspender;
    private boolean _wait;

    protected ServiceImpl() {
    }

    public static void cancelRestarters() {
        _Restarter.cancelAll();
    }

    @Override
    public boolean addAlertListener(Alerter.Listener listener) {
        Alerter alerter = this._alerter;
        if (alerter == null || !alerter.isRunning()) {
            return false;
        }
        return alerter.addListener(listener);
    }

    @Override
    public void disableSuspend() throws InterruptedException {
        this._suspendLock.readLock().lockInterruptibly();
    }

    @Override
    public void enableSuspend() {
        this._suspendLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exportAgent() {
        boolean result;
        Object object = this._mutex;
        synchronized (object) {
            if (this._exported) {
                throw new IllegalStateException("Already exported: " + this.getServiceName());
            }
            if (this.isJMXRegistrationEnabled()) {
                result = Agent.getInstance().exportService(this.getServiceActivator());
                this._exported = true;
            } else {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail() {
        Object object = this._mutex;
        synchronized (object) {
            this._stopRequested = true;
            this.restart(false);
        }
    }

    @Override
    public Alerter getAlerter() {
        return Require.notNull(this._alerter);
    }

    @Override
    public final Config getConfig() {
        return Require.notNull(this._config);
    }

    @Override
    public final File getDataDir() {
        return this.getConfig().getDataDir();
    }

    @Override
    public Optional<String> getEntityName() {
        return Optional.empty();
    }

    @Override
    public long getJoinTimeout() {
        return this._joinTimeout != null ? this._joinTimeout.toMillis() : 0L;
    }

    @Override
    public Optional<UUID> getOptionalSourceUUID() {
        Optional<UUID> sourceUUID = Optional.ofNullable(this._sourceUUID.get());
        if (!sourceUUID.isPresent()) {
            sourceUUID = this.getServiceUUID();
        }
        return sourceUUID;
    }

    @Override
    public final ServiceActivator getServiceActivator() {
        return (ServiceActivator)this.getServiceActivatorBase();
    }

    @Override
    public final Optional<UUID> getServiceUUID() {
        return Optional.ofNullable(this._serviceUUID);
    }

    @Override
    public UUID getSourceUUID() {
        UUID sourceUUID = this._sourceUUID.get();
        if (sourceUUID == null && (sourceUUID = (UUID)this.getServiceUUID().orElse(null)) == null && this._sourceUUID.compareAndSet(null, sourceUUID = UUID.generate())) {
            this._serviceUUID = sourceUUID;
        }
        return sourceUUID;
    }

    @Override
    public final boolean isJMXRegistrationEnabled() {
        return this._jmxRegistrationEnabled;
    }

    @Override
    public final boolean isRunning() {
        switch (this._state) {
            case RUNNING: 
            case SUSPENDED: 
            case RESUMED: 
            case STOPPING: 
            case ZOMBIE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isStarted() {
        switch (this._state) {
            case RUNNING: 
            case SUSPENDED: 
            case RESUMED: 
            case STARTED: {
                return true;
            }
            case ZOMBIE: {
                return this.isThreadStarted();
            }
        }
        return false;
    }

    @Override
    public final boolean isStopped() {
        return this._state == _State.STOPPED;
    }

    @Override
    public final boolean isStopping() {
        switch (this._state) {
            case STOPPING: 
            case STOPPED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isWait() {
        return this._wait;
    }

    @Override
    public final boolean isZombie() {
        return this._state == _State.ZOMBIE;
    }

    @Override
    public final void monitorService(Optional<String> name, Optional<UUID> uuid, Optional<String> reference) {
        if (this._isMonitorEnabled()) {
            this._monitor.add(name, uuid, reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onAlert(Optional<Alert> optionalAlert) {
        if (!optionalAlert.isPresent()) {
            this.getThisLogger().debug(ServiceMessages.RECEIVED_NULL_ALERT, new Object[0]);
            this.restart(false);
            return false;
        }
        Alert alert = optionalAlert.get();
        Object object = this._mutex;
        synchronized (object) {
            if (alert instanceof Event) {
                Event event = (Event)alert;
                if (this.isStarted() && "Midnight".equalsIgnoreCase(event.getName())) {
                    this.getThisLogger().info(ServiceMessages.RECEIVED_ALERT, event);
                    this.logStats(true);
                    MemoryLogger.getInstance().onMidnightEvent();
                } else if (!"Pong".equalsIgnoreCase(event.getName()) || this._isMonitorEnabled() && this._monitor.getMonitored(event).isPresent()) {
                    this.getThisLogger().debug(ServiceMessages.RECEIVED_ALERT, event);
                }
                if (this._isMonitorEnabled()) {
                    this._monitor.onEvent(event);
                }
                if (this.isRunning()) {
                    Require.ignored(this.onEvent(event));
                }
                this._mutex.notifyAll();
                return false;
            }
            if (alert instanceof Signal) {
                Optional<SignalTarget> signalTarget;
                Signal signal = (Signal)alert;
                if (("Ping".equalsIgnoreCase(signal.getName()) || "Suspend".equalsIgnoreCase(signal.getName()) || "Resume".equalsIgnoreCase(signal.getName()) || "Restart".equalsIgnoreCase(signal.getName()) || "RestartNow".equalsIgnoreCase(signal.getName()) || "Stop".equalsIgnoreCase(signal.getName()) || "StopNow".equalsIgnoreCase(signal.getName())) && (signalTarget = SignalTarget.fromString(signal.getInfo())).isPresent()) {
                    Optional<UUID> targetUUID = signalTarget.get().getUUID();
                    if (targetUUID.isPresent() && !this.getSourceUUID().equals(targetUUID.get())) {
                        return false;
                    }
                    Optional<String> targetName = signalTarget.get().getName();
                    if (targetName.isPresent() && !this.getServiceName().equalsIgnoreCase(targetName.get())) {
                        return false;
                    }
                }
                this.getThisLogger().debug(ServiceMessages.RECEIVED_ALERT, signal);
                if (this.isRunning()) {
                    if (this.onSignal(signal)) {
                        this._doServiceSignalActions(signal);
                    }
                } else {
                    this._doServiceSignalActions(signal);
                }
                this._mutex.notifyAll();
                return false;
            }
        }
        this.getThisLogger().debug(ServiceMessages.RECEIVED_ALERT, alert);
        return true;
    }

    @Override
    public final String registerServer(SessionFactory server, String serverPath) {
        URI serverURI;
        Require.notNull(server);
        if (serverPath == null || serverPath.trim().isEmpty()) {
            throw new IllegalArgumentException(Message.format(ServiceMessages.SERVER_IDENTIFICATION, new Object[0]));
        }
        try {
            serverURI = new URI(serverPath);
        }
        catch (URISyntaxException exception) {
            this.getThisLogger().error(ServiceMessages.BAD_SERVER_PATH, exception.getMessage());
            return null;
        }
        return ServiceRegistry.getInstance().registerServer(server, serverURI, this.getThisLogger());
    }

    @Override
    public boolean removeAlertListener(Alerter.Listener listener) {
        Alerter alerter = this._alerter;
        if (alerter == null || !alerter.isRunning()) {
            return false;
        }
        return alerter.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void restart(boolean delayed) {
        Object object = this._mutex;
        synchronized (object) {
            this._restartSignaled = false;
            this._restartRequested = true;
            if (this._restartEnabled && !this._restartInitiated) {
                Optional<ElapsedTime> delay = delayed ? this.getConfig().getElapsedValue(RESTART_DELAY_PROPERTY, Optional.of(DEFAULT_RESTART_DELAY), Optional.empty()) : Optional.empty();
                this._restartInitiated = true;
                new _Restarter(this.getServiceActivatorBase(), this._stopRequested || !this._restartAllowed, delay).start();
            }
            this._mutex.notifyAll();
        }
    }

    @Override
    public final void restoreConfigState() {
        this.getConfig().restoreState(Require.notNull(this._configState));
    }

    @Override
    public final void restoreMonitored() {
        if (this._isMonitorEnabled()) {
            this._monitor.restoreMonitored(this._monitoredServices);
        }
    }

    @Override
    public final void resume() {
        this._suspendLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final void run() {
        try {
            success = this.setUp();
        }
        catch (Throwable throwable) {
            this.getThisLogger().error(throwable, ServiceMessages.SET_UP_FAILED, new Object[0]);
            success = false;
        }
        if (!success) {
            throwable = this._mutex;
            synchronized (throwable) {
                if (this._isStarting()) {
                    this._setState(_State.NONE);
                }
            }
            return;
        }
        this.getStats().setLogEnabled(this.getConfig().getBooleanValue("service.stats.log.enabled"));
        this._addDependencies();
        delay = this.getConfig().getElapsedValue("service.startup.delay", Optional.empty(), Optional.empty());
        this.getConfig().registerClassLoader();
        if (!this.isZombie()) {
            this._setState(_State.STARTED);
        }
        MemoryLogger.getInstance().activate(this.getConfig().getElapsedValue("service.memory.log.interval", Optional.empty(), Optional.empty()));
        try {
            block51: {
                if (!this.isZombie()) break block51;
                if (this._alerter != null) {
                    this._alerter.start();
                }
                this.sendEvent("ServiceIsZombie", Optional.empty());
                ** GOTO lbl66
            }
            if (delay.isPresent()) {
                this.getThisLogger().debug(ServiceMessages.STARTUP_DELAY, new Object[]{delay});
                Thread.sleep(delay.get().toMillis());
            }
            if (this._alerter != null) {
                this._alerter.start();
            }
            var4_10 = this._mutex;
            synchronized (var4_10) {
                this._pinged = false;
                this._doPendingServiceActions();
                restartRequested = this._restartRequested;
                if (restartRequested) {
                    this._mutex.notifyAll();
                }
            }
            if (restartRequested) ** GOTO lbl66
            try {
                this.doStart();
            }
            catch (ServiceNotAvailableException exception) {
                this.getThisLogger().error((Throwable)exception, ServiceMessages.SERVICE_NOT_AVAILABLE, new Object[0]);
                this.fail();
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.isStopped()) {
                return;
            }
            try {
                if (this.isStopping()) {
                    this.doStop();
                    throw new InterruptedException();
                }
                this.sendEvent("ServiceStarted", Optional.empty());
                this.getThisLogger().info(ServiceMessages.SERVICE_RUNNING, new Object[]{this.getServiceName()});
                this._setState(_State.RUNNING);
lbl66:
                // 3 sources

                restartRequested = this._mutex;
                synchronized (restartRequested) {
                    try {
                        if (this.isZombie()) {
                            while (this._doPendingServiceActions()) {
                                this._mutex.wait();
                            }
                        } else if (this.isRunning()) {
                            this.doRun();
                        } else {
                            this.interrupt();
                        }
                    }
                    catch (ServiceNotAvailableException exception) {
                        if (exception.getCause() != null) {
                            cause = exception.getCause();
                            if (cause instanceof StoreAccessException) {
                                while ((cause = cause.getCause()).getCause() != null) {
                                }
                            }
                            this.getThisLogger().error(cause, ServiceMessages.RESTART_NEEDED, new Object[0]);
                        } else {
                            this.getThisLogger().warn(ServiceMessages.RESTART_NEEDED, new Object[0]);
                        }
                        this.restart(true);
                    }
                    while (!Thread.interrupted()) {
                        this._mutex.wait();
                    }
                    throw new InterruptedException();
                }
            }
            catch (InterruptedException interruptedException) {
                this.getThisLogger().debug(ServiceMessages.INTERRUPTED, new Object[0]);
                try {
                    block49: {
                        if (this.isRunning() && !this.isZombie()) {
                            this.doStop();
                            try {
                                this.sendEvent("ServiceStopped", Optional.empty());
                            }
                            catch (RuntimeException exception) {
                                if (exception.getCause() instanceof RemoteException) break block49;
                                this.getThisLogger().warn(ServiceMessages.ALERT_SEND_FAILED, new Object[]{"ServiceStopped", exception.getMessage()});
                            }
                        }
                    }
                    if (this._alerter != null) {
                        this._alerter.stop();
                    }
                }
                catch (Throwable throwable) {
                    this.getThisLogger().fatal(throwable, ServiceMessages.HALT_TERMINATED, new Object[0]);
                }
                Thread.currentThread().interrupt();
            }
            catch (Throwable throwable) {
                this.uncaughtException(Thread.currentThread(), throwable);
            }
        }
        finally {
            MemoryLogger.getInstance().deactivate();
        }
    }

    @Override
    public final void saveConfigState() {
        this._configState = this.getConfig().saveState();
    }

    @Override
    public final void saveMonitored() {
        if (this._isMonitorEnabled() && this._monitoredServices == null) {
            this._monitoredServices = this._monitor.saveMonitored();
        }
    }

    @Override
    public final void sendAlert(Alert alert) {
        Alerter alerter = this._alerter;
        if (alerter != null && alerter.isRunning()) {
            try {
                alerter.send(alert);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
            catch (ServiceNotAvailableException exception) {
                this.getThisLogger().error((Throwable)exception, ServiceMessages.SERVICE_NOT_AVAILABLE, new Object[0]);
                this.restart(false);
            }
        }
    }

    @Override
    public final void sendEvent(String name, Optional<Object> info) {
        this.sendAlert(new Event(Require.notNull(name), Optional.of(this.getServiceName()), this.getEntityName(), Optional.of(this.getSourceUUID()), info));
    }

    @Override
    public final void sendSignal(String name, Optional<?> info) {
        this.sendAlert(new Signal(Require.notNull(name), Optional.of(this.getServiceName()), this.getEntityName(), Optional.of(this.getSourceUUID()), info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setRestartEnabled(boolean restartEnabled) {
        boolean wasEnabled;
        Object object = this._mutex;
        synchronized (object) {
            if (!this._restartInitiated) {
                wasEnabled = this._restartEnabled;
                boolean bl = this._restartEnabled = restartEnabled && !this.isStopping();
                if (this._restartRequested) {
                    this.restart(false);
                }
            } else {
                wasEnabled = false;
            }
        }
        return wasEnabled;
    }

    @Override
    public final void setSourceUUID(UUID sourceUUID) {
        this._sourceUUID.compareAndSet(null, Require.notNull(sourceUUID));
    }

    @Override
    public final void starting() {
        this.starting(this.getConfig().getElapsedValue(STARTING_EXTEND_PROPERTY, Optional.of(DEFAULT_STARTING_EXTEND), Optional.empty()));
    }

    @Override
    public final void stopping() {
        this.stopping(this.getConfig().getElapsedValue(STOPPING_EXTEND_PROPERTY, Optional.of(DEFAULT_STOPPING_EXTEND), Optional.empty()));
    }

    @Override
    public final void suspend() throws InterruptedException {
        this._suspendLock.writeLock().lockInterruptibly();
    }

    @Override
    public final boolean trySuspend(long timeout) throws InterruptedException {
        return this._suspendLock.writeLock().tryLock(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public final void unregisterServer(String serverName) {
        ServiceRegistry.getInstance().unregister(serverName, this.getThisLogger());
    }

    @Override
    protected ServiceStats createStats(StatsOwner statsOwner) {
        return new ServiceStats(statsOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    protected boolean doPendingActions() throws InterruptedException, ServiceNotAvailableException {
        Object object = this._mutex;
        synchronized (object) {
            return this._doPendingServiceActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() throws Exception {
        Object object = this._mutex;
        synchronized (object) {
            while (this.doPendingActions()) {
                this._mutex.wait();
            }
        }
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    @Nonnull
    @CheckReturnValue
    protected final Object getMutex() {
        return this._mutex;
    }

    @CheckReturnValue
    protected boolean onEvent(@Nonnull Event event) {
        return true;
    }

    protected void onServiceStartFailure() throws InterruptedException {
        if (this._alerter == null) {
            return;
        }
        if (!this.getConfig().getBooleanValue(ZOMBIE_ENABLED_PROPERTY)) {
            return;
        }
        if (this._isMonitorEnabled()) {
            this._monitorEnabled = false;
            this._monitor.tearDown();
        }
        this._setState(_State.ZOMBIE);
    }

    protected void onServicesNotReady() {
    }

    @CheckReturnValue
    protected boolean onSignal(@Nonnull Signal signal) {
        return true;
    }

    protected void setRestartSignaled(boolean restartSignaled) {
        this._restartSignaled = restartSignaled;
    }

    @Override
    protected boolean setUp() {
        Optional<ServiceContext> serviceContext;
        if (!super.setUp()) {
            return false;
        }
        Config config = ConfigDocumentLoader.loadConfig(this.getServiceName(), Optional.ofNullable(this._configURL), Optional.ofNullable(this._classLoader));
        if (config == null) {
            return false;
        }
        for (ServiceContext serviceContext2 : config.getServiceContexts()) {
            serviceContext2.freeze();
        }
        this._config = config;
        config.setService(this);
        config.registerClassLoader();
        this.setLogID(config.getStringValue(SERVICE_LOG_ID_PROPERTY));
        ConfigProperties serviceProperties = config.getServiceProperties();
        serviceProperties.setOverrider(this._properties);
        Optional<String> uuidString = config.getStringValue(SERVICE_UUID_PROPERTY);
        if (uuidString.isPresent() && uuidString.get().length() > 0) {
            UUID serviceUUID = UUID.fromString(uuidString.get()).orElse(null);
            this.getThisLogger().info(ServiceMessages.SERVICE_UUID, this.getServiceName(), serviceUUID);
            this._serviceUUID = serviceUUID;
        }
        if ((serviceContext = config.getServiceContext(this.getServiceName())).isPresent()) {
            for (String serviceAlias : serviceContext.get().getServiceAliases()) {
                this.getThisLogger().info(ServiceMessages.SERVICE_ALIAS, serviceAlias);
            }
        }
        this._joinTimeout = config.getElapsedValue(JOIN_TIMEOUT_PROPERTY, Optional.of(DEFAULT_JOIN_TIMEOUT), Optional.empty()).orElse(null);
        if (this._joinTimeout != null && this._joinTimeout.toMillis() != DEFAULT_JOIN_TIMEOUT.toMillis()) {
            this.getThisLogger().debug(ServiceMessages.JOIN_TIMEOUT, this._joinTimeout);
        }
        this._jmxRegistrationEnabled = Agent.isRegistrationEnabled(config);
        if (this.isJMXRegistrationEnabled() && !Agent.getInstance().setUp(config)) {
            return false;
        }
        this.startTimer();
        if (!ServiceRegistry.setUp(config.getProperties())) {
            return false;
        }
        this._restartAllowed = config.getBooleanValue(RESTART_ALLOWED_PROPERTY);
        if (this._restartAllowed) {
            this.getThisLogger().debug(ServiceMessages.RESTART_ALLOWED, new Object[0]);
        }
        this._alerter = Alerter.Factory.getAnAlerter(this.getConfig(), this);
        if (this._alerter == null) {
            return false;
        }
        Require.ignored(this._alerter.addListener(this));
        if (this._alerter.isStealth()) {
            this.scheduleMidnightLogger();
        }
        boolean bl = this._monitorEnabled = this._alerter != null && !config.getBooleanValue(MONITOR_DISABLED_PROPERTY);
        if (this._isMonitorEnabled()) {
            if (!this._monitor.setUp(this)) {
                return false;
            }
        } else {
            this.getThisLogger().debug(ServiceMessages.MONITOR_DISABLED, new Object[0]);
        }
        return !this.isStopped();
    }

    @Override
    protected void tearDown() {
        this.stopTimer();
        Alerter alerter = this._alerter;
        if (alerter != null) {
            this._alerter = null;
            alerter.tearDown();
        }
        if (this._exported) {
            Agent.getInstance().unexportService(this.getServiceActivator());
            this._exported = false;
        }
        if (this._registered) {
            Agent.getInstance().unregisterService(this.getServiceActivator());
            this._registered = false;
        }
        if (this._config != null) {
            Agent.getInstance().tearDown(this._config);
        }
        if (this._isMonitorEnabled()) {
            this._monitor.tearDown();
        }
        this.logStats(false);
        this.tearDownConfig();
        super.tearDown();
    }

    protected void tearDownConfig() {
        if (this._config != null) {
            this._config.tearDown();
            this._config = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _suspendService() {
        if (this._suspender == null) {
            return;
        }
        try {
            try {
                this.suspend();
            }
            catch (InterruptedException exception) {
                this._suspender = null;
                return;
            }
            try {
                Object object = this._mutex;
                synchronized (object) {
                    if (this._isActive()) {
                        this._setState(_State.SUSPENDED);
                        this.getThisLogger().info(ServiceMessages.SERVICE_SUSPENDED, this.getServiceName());
                        this._pinged = true;
                    }
                    while (this._state == _State.SUSPENDED) {
                        try {
                            this._mutex.wait();
                        }
                        catch (InterruptedException exception) {
                            // empty catch block
                            break;
                        }
                    }
                    if (this._state == _State.SUSPENDED) {
                        this._setState(_State.RESUMED);
                        this.getThisLogger().info(ServiceMessages.SERVICE_RESUMED, this.getServiceName());
                        this._pinged = true;
                    }
                }
            }
            finally {
                this.resume();
            }
        }
        finally {
            this._suspender = null;
        }
    }

    final void putProperties(@Nonnull Properties properties) {
        ConfigProperties newProperties = new ConfigProperties(ServiceMessages.MBEAN_PROPERTY_TYPE);
        newProperties.add(Require.notNull(properties));
        this._properties = newProperties;
    }

    void setClassLoader(@Nonnull ServiceClassLoader classLoader) {
        this._classLoader = Require.notNull(classLoader);
    }

    final void setConfigURL(@Nonnull String configURL) {
        this._configURL = Require.notNull(configURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void startService(boolean wait) throws InterruptedException {
        if (this.isStarted()) {
            throw new IllegalStateException("Service already started");
        }
        this.getThisLogger().info(ServiceMessages.STARTING_SERVICE, this.getServiceName(), this.getVersion().getImplementationTitle());
        this._setState(_State.STARTING);
        this._wait = wait;
        this.startThread();
        Object object = this._mutex;
        synchronized (object) {
            while (this._isStarting()) {
                this._mutex.wait();
            }
        }
        if (this.isStarted()) {
            this.getThisLogger().info(ServiceMessages.SERVICE_STARTED, this.getServiceName());
            this.setRestartEnabled(true);
            if (this.isWait()) {
                object = this._mutex;
                synchronized (object) {
                    while (!(this.isRunning() || this.isStopping() || this._restartRequested)) {
                        this._mutex.wait();
                    }
                }
            }
        } else if (this.isStopped()) {
            this.getThisLogger().warn(ServiceMessages.SERVICE_CANCELLED, this.getServiceName());
            this.tearDown();
        } else {
            this.onServiceStartFailure();
            if (this.isZombie()) {
                object = this._mutex;
                synchronized (object) {
                    this.getThisLogger().warn(ServiceMessages.SERVICE_NOW_ZOMBIE, this.getServiceName());
                    this.setRestartEnabled(true);
                }
            } else {
                this.getThisLogger().warn(ServiceMessages.SERVICE_START_FAILED, this.getServiceName());
                this.tearDown();
                this.getServiceActivatorBase().terminate();
            }
        }
        if (this.isStarted() && this.isJMXRegistrationEnabled()) {
            this._registered = Agent.getInstance().registerService(this.getServiceActivator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopService() {
        Alerter alerter = this._alerter;
        if (alerter != null) {
            Require.ignored(alerter.removeListener(this));
        }
        if (this._isStarting()) {
            this._setState(_State.STOPPED);
            this.closeSnoozeAlarm();
        } else if (this.isStarted()) {
            ServiceImpl serviceImpl = this;
            synchronized (serviceImpl) {
                if (!this.isZombie()) {
                    this._setState(_State.STOPPING);
                }
                this.setRestartEnabled(false);
                if (this._suspender != null) {
                    this._suspender.interrupt();
                }
            }
            this.closeSnoozeAlarm();
            if (!this.isZombie()) {
                this.getThisLogger().info(ServiceMessages.STOPPING_SERVICE, this.getServiceName());
            }
            Optional<String> savedLogID = Logger.currentLogID();
            boolean interrupted = false;
            Logger.setLogID(this.getLogID());
            try {
                if (!this.isCurrentThread()) {
                    this.getThisLogger().debug(ServiceMessages.STOPPING_THREAD, this.getThread().getName());
                    this.interrupt();
                    interrupted = !this.join();
                    ServiceThread.yieldAll();
                }
                this.tearDown();
            }
            finally {
                Logger.restoreLogID(savedLogID);
                this._setState(_State.STOPPED);
            }
            if (!this.isZombie()) {
                this.getThisLogger().info(ServiceMessages.SERVICE_STOPPED, this.getServiceName());
            }
            ServiceThread.yieldAll();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void _addDependencies() {
        for (String dependency : this.getConfig().getStringValues(DEPENDENCY_PROPERTY)) {
            UUID uuid;
            String name;
            if (UUID.isUUID(dependency)) {
                name = null;
                uuid = UUID.fromString(dependency).get();
            } else {
                name = dependency;
                uuid = null;
            }
            this.monitorService(Optional.ofNullable(name), Optional.ofNullable(uuid), Optional.empty());
        }
    }

    private boolean _doPendingServiceActions() throws InterruptedException {
        boolean wasReady = this.isRunning();
        while (true) {
            if (this._restartSignaled) {
                this.restart(false);
                return false;
            }
            if (this._pinged) {
                String eventName;
                switch (this._state) {
                    case SUSPENDED: {
                        eventName = "ServiceSuspended";
                        break;
                    }
                    case RESUMED: {
                        eventName = "ServiceResumed";
                        this._setState(_State.RUNNING);
                        break;
                    }
                    case ZOMBIE: {
                        eventName = "ServiceIsZombie";
                        break;
                    }
                    default: {
                        eventName = "Pong";
                    }
                }
                this.sendEvent(eventName, Optional.empty());
                this._pinged = false;
            }
            if (this._suspender != null) {
                this._mutex.wait();
                continue;
            }
            if (!this._isMonitorEnabled()) break;
            if (wasReady && !this._monitor.areServicesReady()) {
                this.onServicesNotReady();
                wasReady = false;
            }
            try {
                if (!this._monitor.busy()) break;
                this._mutex.wait();
            }
            catch (ServiceNotAvailableException exception) {
                this.restart(false);
                return false;
            }
        }
        return true;
    }

    private void _doServiceSignalActions(Signal signal) {
        String name = signal.getName();
        if ("Ping".equalsIgnoreCase(name)) {
            this._pinged = true;
        } else if ("Suspend".equalsIgnoreCase(name)) {
            if (this._isActive() && this._suspender == null) {
                this._suspender = new Thread(() -> this._suspendService(), "Service [" + this.getServiceName() + "] suspender");
                this._suspender.start();
            }
        } else if ("Resume".equalsIgnoreCase(name)) {
            if (this._suspender != null) {
                this._suspender.interrupt();
            }
        } else if ("Restart".equalsIgnoreCase(name)) {
            if (!this.getConfig().getBooleanValue(RESTART_IGNORED_PROPERTY, this._alerter != null && this._alerter.isEmbedded())) {
                this.setRestartSignaled(true);
            }
        } else if ("RestartNow".equalsIgnoreCase(name)) {
            this.restart(false);
        } else if ("Stop".equalsIgnoreCase(name)) {
            this._stopRequested = true;
            this.setRestartSignaled(true);
        } else if ("StopNow".equalsIgnoreCase(name)) {
            this._stopRequested = true;
            this.restart(false);
        }
    }

    private boolean _isActive() {
        switch (this._state) {
            case RUNNING: 
            case RESUMED: {
                return true;
            }
        }
        return false;
    }

    private boolean _isMonitorEnabled() {
        return this._monitorEnabled;
    }

    private boolean _isStarting() {
        switch (this._state) {
            case STARTING: {
                return true;
            }
            case ZOMBIE: {
                return !this.isThreadStarted();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setState(_State state) {
        Object object = this._mutex;
        synchronized (object) {
            this._state = state;
            this._mutex.notifyAll();
        }
    }

    private static final class _Restarter
    implements Runnable {
        private static final Set<_Restarter> _RESTARTERS = new HashSet<_Restarter>();
        private static volatile boolean _cancelled;
        private final Optional<ElapsedTime> _delay;
        private final String _logID = Logger.currentLogID().orElse(null);
        private final ServiceActivatorBase _serviceActivator;
        private final boolean _stop;
        private final Thread _thread;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        _Restarter(ServiceActivatorBase serviceActivator, boolean stop, Optional<ElapsedTime> delay) {
            this._serviceActivator = serviceActivator;
            this._stop = stop;
            this._delay = delay;
            this._thread = new Thread((Runnable)this, "Service [" + this._serviceActivator.getObjectName() + "] restarter");
            Set<_Restarter> set = _RESTARTERS;
            synchronized (set) {
                _RESTARTERS.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                Logger.setLogID(Optional.ofNullable(this._logID));
                try {
                    Logger logger = Logger.getInstance(this.getClass());
                    if (this._stop) {
                        logger.info(ServiceMessages.STOPPING_SERVICE, this._serviceActivator.getObjectName());
                    } else {
                        logger.info(ServiceMessages.RESTARTING_SERVICE, this._serviceActivator.getObjectName());
                    }
                    if (this._stop) {
                        this._serviceActivator.terminate();
                        break block15;
                    }
                    try {
                        this._serviceActivator.restart(this._delay);
                    }
                    catch (Exception exception) {
                        if (!_cancelled) {
                            logger.fatal((Throwable)exception, ServiceMessages.RESTART_FAILED, this._serviceActivator.getObjectName());
                        }
                    }
                }
                finally {
                    Set<_Restarter> set = _RESTARTERS;
                    synchronized (set) {
                        _RESTARTERS.remove(this);
                        _RESTARTERS.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void cancelAll() {
            Set<_Restarter> set = _RESTARTERS;
            synchronized (set) {
                _cancelled = true;
                for (_Restarter restarter : _RESTARTERS) {
                    restarter.interrupt();
                }
                while (!_RESTARTERS.isEmpty()) {
                    try {
                        _RESTARTERS.wait();
                    }
                    catch (InterruptedException exception) {
                        Logger.getInstance(_Restarter.class).debug(ServiceMessages.INTERRUPTED, new Object[0]);
                    }
                }
            }
        }

        void interrupt() {
            this._thread.interrupt();
        }

        void start() {
            this._thread.start();
        }
    }

    private static enum _State {
        NONE,
        STARTING,
        STARTED,
        RUNNING,
        SUSPENDED,
        RESUMED,
        STOPPING,
        STOPPED,
        ZOMBIE;

    }
}

