/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.Stats;
import org.rvpf.base.StatsOwner;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Profiler;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.service.ServiceMessages;

@ThreadSafe
public class ServiceStats
extends Stats {
    private static final int _FINAL_MODE = 2;
    private static final int _INTERMEDIATE_MODE = 1;
    private static final int _SERVICE_MODE = 0;
    private static final long serialVersionUID = 1L;
    private volatile transient boolean _logEnabled;
    private final transient StatsOwner _statsOwner;

    public ServiceStats(@Nonnull StatsOwner statsOwner) {
        this._statsOwner = statsOwner;
    }

    @CheckReturnValue
    public final boolean isLogEnabled() {
        return this._logEnabled;
    }

    public final synchronized void log(boolean intermediate) {
        if (!this.isLogEnabled()) {
            return;
        }
        this._statsOwner.updateStats();
        if (intermediate) {
            ServiceStats stats = (ServiceStats)this.getIntermediate();
            stats._openLog(1);
            stats.buildText();
            stats._closeLog(Logger.getMidnightLogger());
            this.setSnapshot(this.clone());
        } else {
            if (this.getSnapshot().isPresent()) {
                this.log(true);
                this.clearSnapshot();
                this._openLog(2);
            } else {
                this._openLog(0);
            }
            this.buildText();
            this._closeLog(Logger.getInstance(this._statsOwner.getClass().getName()));
        }
    }

    public final void setLogEnabled(boolean logEnabled) {
        this._logEnabled = logEnabled;
    }

    public final void updated() {
        if (this._statsOwner != null) {
            this._statsOwner.onStatsUpdated();
        }
    }

    protected void freeze() {
    }

    @Nonnull
    @CheckReturnValue
    protected final StatsOwner getStatsOwner() {
        return this._statsOwner;
    }

    private void _closeLog(Logger logger) {
        logger.info(BaseMessages.VERBATIM, this.getText());
        this.clearText();
        this.clearMargin();
    }

    private void _openLog(int mode) {
        this.setLogTime(DateTime.now());
        this.setMargin(Profiler.margin());
        String name = this._statsOwner.getObjectName().toString();
        Optional<String> version = this._statsOwner.getObjectVersion();
        this.addText(Message.format(ServiceMessages.SERVICE_STATS, mode, name, ValueConverter.toInteger(version.isPresent()), version.orElse(null), this.getLogTime().orElse(null)));
    }
}

