/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.io.InterruptedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.service.ServiceClassLoader;
import org.rvpf.service.ServiceMessages;

public class ServiceThread
extends Thread {
    private volatile boolean _failed;
    private String _logID;
    private volatile Logger _logger;
    private boolean _quiet;
    private final CountDownLatch _startLatch = new CountDownLatch(1);
    private final Target _target;
    private final BlockingQueue<Target> _targets;
    private Throwable _throwable;

    public ServiceThread(@Nonnull String name) {
        super(name);
        this._targets = new LinkedBlockingQueue<Target>();
        this._target = this::_executeTargets;
    }

    public ServiceThread(@Nonnull Target target, @Nonnull String name) {
        super(name);
        this._targets = null;
        this._target = target;
    }

    public static void failed() {
        ((ServiceThread)Thread.currentThread())._failed();
    }

    public static void ready() {
        ((ServiceThread)Thread.currentThread())._ready(true);
    }

    public static void yieldAll() {
        Thread currentThread = Thread.currentThread();
        int priority = currentThread.getPriority();
        currentThread.setPriority(2);
        Thread.yield();
        currentThread.setPriority(priority);
    }

    public void execute(@Nonnull Target target) {
        if (this._targets == null) {
            throw new UnsupportedOperationException();
        }
        this._targets.add(target);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this._throwable);
    }

    @CheckReturnValue
    public boolean hasFailed() {
        return this._failed;
    }

    @CheckReturnValue
    public boolean interruptAndJoin(@Nonnull Logger logger, long joinTimeout) {
        logger.debug(ServiceMessages.THREAD_INTERRUPT, this.getName());
        this.interrupt();
        return this.join(logger, joinTimeout);
    }

    @CheckReturnValue
    public boolean join(@Nonnull Logger logger, long timeout) {
        logger.debug(ServiceMessages.THREAD_JOIN, this.getName());
        try {
            this.join(timeout >= 0L ? timeout : 0L);
            if (this.isAlive()) {
                logger.warn(ServiceMessages.THREAD_JOIN_TIMEOUT, this.getName());
            } else {
                logger.debug(ServiceMessages.THREAD_JOINED, this.getName());
            }
        }
        catch (InterruptedException exception) {
            this.interrupt();
            logger.warn(ServiceMessages.THREAD_JOIN_INTERRUPTED, this.getName());
        }
        return !this.isAlive();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setLogger(@Nonnull Logger logger) {
        Require.equal((Object)Thread.State.NEW, (Object)this.getState());
        this._logger = Require.notNull(logger);
    }

    public void setQuiet(boolean quiet) {
        this._quiet = quiet;
    }

    @Override
    public void start() {
        Require.ignored(this.start(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public boolean start(boolean wait) {
        ServiceThread serviceThread = this;
        synchronized (serviceThread) {
            this._logID = Logger.currentLogID().orElse(null);
            this.setUncaughtExceptionHandler(Thread.currentThread().getUncaughtExceptionHandler());
            if (!(Thread.currentThread().getContextClassLoader() instanceof ServiceClassLoader)) {
                this._getLogger().debug(ServiceMessages.NO_SERVICE_CLASS_LOADER, this.getName());
            }
            super.start();
        }
        if (wait) {
            Require.ignored(this.waitForReady());
        }
        return !this.hasFailed();
    }

    @CheckReturnValue
    public boolean waitForReady() {
        try {
            this._startLatch.await();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            return false;
        }
        return !this.hasFailed();
    }

    private static boolean _terminated(Exception exception) {
        Throwable cause = exception.getCause();
        while (true) {
            if (cause == null) {
                return true;
            }
            if (cause instanceof InterruptedException || cause instanceof InterruptedIOException || cause instanceof ClosedByInterruptException) break;
            cause = cause.getCause();
        }
        return false;
    }

    private void _executeTargets() throws Exception {
        while (true) {
            this._targets.take().run();
        }
    }

    private void _failed() {
        this._failed = true;
    }

    private Logger _getLogger() {
        Logger logger = this._logger;
        if (logger == null) {
            this._logger = logger = Logger.getInstance(this._target.getClass());
        }
        return logger;
    }

    private void _ready(boolean log) {
        if (this._startLatch.getCount() > 0L) {
            if (log && !this.hasFailed()) {
                this._getLogger().debug(ServiceMessages.THREAD_READY, Thread.currentThread().getName());
            }
            this._startLatch.countDown();
        }
    }

    public static class SilentException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static interface Target {
        public void run() throws Exception;
    }
}

