/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.UUID;
import org.rvpf.base.alert.Event;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.util.SignalTarget;
import org.rvpf.base.util.SnoozeAlarm;
import org.rvpf.config.Config;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;

final class ServicesMonitor {
    public static final ElapsedTime DEFAULT_PING_INTERVAL = ElapsedTime.fromMillis(60000L);
    public static final int DEFAULT_PING_LIMIT = 60;
    public static final String PING_INTERVAL_PROPERTY = "service.monitor.ping.interval";
    public static final String PING_LIMIT_PROPERTY = "service.monitor.ping.limit";
    private TimerTask _awakener;
    private long _lastPingTime;
    private final Set<Monitored> _monitored = new HashSet<Monitored>();
    private final Map<String, Monitored> _monitoredByName = new HashMap<String, Monitored>();
    private final Map<UUID, Monitored> _monitoredByUUID = new HashMap<UUID, Monitored>();
    private long _pingInterval;
    private int _pingLimit;
    private int _pings;
    private boolean _ready = true;
    private volatile Service _service;

    ServicesMonitor() {
    }

    synchronized void add(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Optional<String> reference) {
        Monitored monitored;
        Monitored monitored2 = monitored = uuid.isPresent() ? this._monitoredByUUID.get(uuid.get()) : null;
        if (monitored == null && name.isPresent()) {
            monitored = this._monitoredByName.get(name.get());
        }
        if (monitored != null) {
            if (name.isPresent() && uuid.isPresent()) {
                monitored.updateTarget(name, uuid);
                this._monitoredByUUID.put(uuid.get(), monitored);
                this._monitoredByName.put(name.get(), monitored);
            }
        } else if (name.isPresent() || uuid.isPresent()) {
            monitored = new Monitored(name, uuid, reference);
            this._monitored.add(monitored);
            if (uuid.isPresent()) {
                this._monitoredByUUID.put(uuid.get(), monitored);
            }
            if (name.isPresent()) {
                this._monitoredByName.put(name.get(), monitored);
            }
            this._getOwnerLogger().debug(ServiceMessages.MONITORING_STARTED, monitored);
            this._ready = false;
        }
    }

    @CheckReturnValue
    synchronized boolean areServicesReady() {
        return this._ready;
    }

    @CheckReturnValue
    synchronized boolean busy() throws InterruptedException, ServiceNotAvailableException {
        Optional<Boolean> state;
        if (this._ready) {
            return false;
        }
        this._ready = true;
        for (Monitored monitored : this._monitored) {
            state = monitored.getState();
            if (state.isPresent() && state.get().booleanValue()) continue;
            this._ready = false;
        }
        if (this._ready) {
            this._cancelAwakener();
        } else if (System.currentTimeMillis() >= this._lastPingTime + this._pingInterval) {
            if (this._pingLimit > 0 && this._pings >= this._pingLimit) {
                this._getOwnerLogger().warn(ServiceMessages.PING_LIMIT_RESTART, new Object[0]);
                throw new ServiceNotAvailableException();
            }
            for (Monitored monitored : this._monitored) {
                state = monitored.getState();
                if (state.isPresent() && state.get().booleanValue()) continue;
                this._service.sendSignal("Ping", Optional.of(monitored.getTarget()));
            }
            ++this._pings;
            this._scheduleAwakener();
        }
        return !this._ready;
    }

    @Nonnull
    @CheckReturnValue
    synchronized Optional<Monitored> getMonitored(@Nonnull Event event) {
        Monitored monitored;
        Optional<UUID> sourceUUID = event.getSourceUUID();
        Optional<String> sourceServiceName = event.getSourceServiceName();
        Monitored monitored2 = monitored = sourceUUID.isPresent() ? this._monitoredByUUID.get(sourceUUID.get()) : null;
        if (monitored == null && sourceServiceName.isPresent()) {
            monitored = this._monitoredByName.get(sourceServiceName.get());
        }
        return Optional.ofNullable(monitored);
    }

    synchronized void onEvent(@Nonnull Event event) {
        Optional<Monitored> monitored = this.getMonitored(event);
        if (!monitored.isPresent()) {
            return;
        }
        String eventName = event.getName();
        monitored.get().updateTarget(event.getSourceServiceName(), event.getSourceUUID());
        if ("Pong".equalsIgnoreCase(eventName) || "ServiceStarted".equals(eventName)) {
            if (monitored.get().getState().orElse(null) != Boolean.TRUE) {
                monitored.get().setState(Optional.of(Boolean.TRUE));
                this._getOwnerLogger().debug(ServiceMessages.MONITORED_STARTED, monitored);
            }
        } else if (("ServiceStopped".equalsIgnoreCase(eventName) || "ServiceIsZombie".equals(eventName)) && monitored.get().getState().orElse(null) != Boolean.FALSE) {
            monitored.get().setState(Optional.of(Boolean.FALSE));
            this._getOwnerLogger().debug(ServiceMessages.MONITORED_STOPPED, monitored);
            this._ready = false;
        }
    }

    synchronized void restoreMonitored(@Nonnull Collection<Monitored> saved) {
        this._cancelAwakener();
        this._monitored.clear();
        this._monitoredByName.clear();
        this._monitoredByUUID.clear();
        for (Monitored monitored : saved) {
            monitored.setState(Optional.empty());
            this._monitored.add(monitored);
            if (monitored.getName().isPresent()) {
                this._monitoredByName.put(monitored.getName().get(), monitored);
            }
            if (!monitored.getUUID().isPresent()) continue;
            this._monitoredByUUID.put(monitored.getUUID().get(), monitored);
        }
        this._ready = false;
    }

    @Nonnull
    @CheckReturnValue
    synchronized Collection<Monitored> saveMonitored() {
        return new ArrayList<Monitored>(this._monitored);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    synchronized boolean setUp(@Nonnull Service service) {
        Logger logger = Logger.getInstance(this.getClass());
        Config config = service.getConfig();
        ElapsedTime pingInterval = config.getElapsedValue(PING_INTERVAL_PROPERTY, Optional.of(DEFAULT_PING_INTERVAL), Optional.of(DEFAULT_PING_INTERVAL)).get();
        int pingLimit = config.getIntValue(PING_LIMIT_PROPERTY, 60);
        this._service = service;
        if (!SnoozeAlarm.validate(pingInterval, this, ServiceMessages.SERVICES_PING_TEXT)) {
            return false;
        }
        Service service2 = this._service;
        synchronized (service2) {
            this._pingInterval = pingInterval.toMillis();
            this._pingLimit = pingLimit;
        }
        logger.debug(ServiceMessages.SERVICES_PING, pingInterval, String.valueOf(pingLimit));
        return true;
    }

    synchronized void tearDown() {
        boolean wasMonitoring = !this._monitored.isEmpty();
        this._cancelAwakener();
        this._monitoredByName.clear();
        this._monitoredByUUID.clear();
        this._monitored.clear();
        this._ready = true;
        if (wasMonitoring) {
            this._getOwnerLogger().debug(ServiceMessages.MONITORING_STOPPED, new Object[0]);
        }
    }

    private void _cancelAwakener() {
        if (this._awakener != null) {
            this._awakener.cancel();
            this._awakener = null;
            this._getOwnerLogger().info(this._ready ? ServiceMessages.REQUIRED_WAIT_DONE : ServiceMessages.REQUIRED_WAIT_CANCELLED, new Object[0]);
        }
        this._lastPingTime = 0L;
        this._pings = 0;
    }

    private Logger _getOwnerLogger() {
        return Logger.getInstance(this._service.getClass());
    }

    private void _scheduleAwakener() {
        Optional<Timer> timer = this._service.getTimer();
        if (timer.isPresent()) {
            if (this._awakener == null) {
                final Service owner = this._service;
                this._awakener = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = owner;
                        synchronized (object) {
                            owner.notifyAll();
                        }
                    }
                };
                timer.get().schedule(this._awakener, this._pingInterval, this._pingInterval);
                this._getOwnerLogger().info(ServiceMessages.REQUIRED_WAIT_STARTED, new Object[0]);
            }
            this._lastPingTime = System.currentTimeMillis();
        }
    }

    static final class Monitored {
        private Optional<Boolean> _state = Optional.empty();
        private SignalTarget _target;

        Monitored(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull Optional<String> reference) {
            this._target = new SignalTarget(name, uuid, reference);
        }

        public String toString() {
            return this._target.toString();
        }

        @Nonnull
        @CheckReturnValue
        Optional<String> getName() {
            return this._target.getName();
        }

        @Nonnull
        @CheckReturnValue
        Optional<Boolean> getState() {
            return this._state;
        }

        @Nonnull
        @CheckReturnValue
        SignalTarget getTarget() {
            return this._target;
        }

        @Nonnull
        @CheckReturnValue
        Optional<UUID> getUUID() {
            return this._target.getUUID();
        }

        void setState(@Nonnull Optional<Boolean> state) {
            this._state = state;
        }

        void updateTarget(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid) {
            this._target = new SignalTarget(name, uuid, this._target.getReference());
        }
    }
}

