/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.rvpf.base.Stats;
import org.rvpf.base.StatsOwner;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.StatsHolderMBean;

@ThreadSafe
public abstract class StatsHolder
extends NotificationBroadcasterSupport
implements StatsHolderMBean,
StatsOwner {
    public static final String ACTIVATOR_CLASS_NAME_SUFFIX = "Activator";
    public static final String DEFAULT_DOMAIN = "org.rvpf";
    public static final String DOMAIN_PROPERTY = "rvpf.jmx.domain";
    public static final String STATS_UPDATE_TYPE = "rvpf.stats.update";
    protected static final String NAME_KEY = "name";
    protected static final String TYPE_KEY = "type";
    private static final String _DEFAULT_DOMAIN = System.getProperty("rvpf.jmx.domain", "org.rvpf");
    private volatile Logger _logger;
    private final AtomicReference<ObjectName> _objectName = new AtomicReference();
    @GuardedBy(value="this")
    private final AtomicLong _sequenceNumber = new AtomicLong();

    @Nonnull
    @CheckReturnValue
    public static String getDefaultDomain() {
        return _DEFAULT_DOMAIN;
    }

    @Nonnull
    @CheckReturnValue
    public static ObjectName makeObjectName(@Nonnull String domain, @Nonnull String typeValue, @Nonnull Optional<String> nameValue) {
        try {
            return ObjectName.getInstance(domain + ":type=" + typeValue + (nameValue.isPresent() ? ",name=" + nameValue.get() : ""));
        }
        catch (MalformedObjectNameException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public ObjectName getObjectName() {
        return Require.notNull(this._objectName.get());
    }

    @Override
    public Optional<String> getObjectVersion() {
        return Optional.empty();
    }

    @Override
    public final String[] getStatsStrings() {
        Optional<? extends Stats> stats = this.getStats();
        String string = stats.isPresent() ? stats.get().toString() : "";
        return string.split("\\n");
    }

    @Nonnull
    @CheckReturnValue
    public ObjectName makeObjectName(@Nonnull Optional<String> nameValue) {
        if (nameValue.isPresent() && nameValue.get().contains(":type=")) {
            try {
                return ObjectName.getInstance(nameValue.get());
            }
            catch (MalformedObjectNameException exception) {
                throw new RuntimeException(exception);
            }
        }
        String typeValue = this.getClass().getSimpleName();
        if (typeValue.endsWith(ACTIVATOR_CLASS_NAME_SUFFIX)) {
            typeValue = typeValue.substring(0, typeValue.length() - ACTIVATOR_CLASS_NAME_SUFFIX.length());
        }
        return StatsHolder.makeObjectName(StatsHolder.getDefaultDomain(), typeValue, nameValue);
    }

    @Override
    public final void onStatsUpdated() {
        this.sendNotification(new UpdateNotification(this.getObjectName(), this._sequenceNumber.incrementAndGet(), this.getStats().get()));
    }

    public final void setObjectName(@Nonnull ObjectName objectName) {
        if (!this._objectName.compareAndSet(null, objectName) && !Objects.equals(this._objectName.get(), objectName)) {
            this.getThisLogger().warn(ServiceMessages.OBJECT_NAME_CHANGE_IGNORED, this._objectName.get(), objectName);
        }
    }

    @Override
    public abstract void updateStats();

    @Nonnull
    @CheckReturnValue
    protected abstract Optional<? extends Stats> getStats();

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        if (this._logger == null) {
            this._logger = Logger.getInstance(this.getClass());
        }
        return this._logger;
    }

    @Nonnull
    @CheckReturnValue
    protected final Optional<ObjectName> objectName() {
        return Optional.ofNullable(this._objectName.get());
    }

    public static final class UpdateNotification
    extends Notification {
        private static final long serialVersionUID = 1L;
        private final Stats _stats;

        UpdateNotification(@Nonnull ObjectName notificationSource, long sequenceNumber, @Nonnull Stats stats) {
            super(StatsHolder.STATS_UPDATE_TYPE, notificationSource, sequenceNumber);
            this._stats = stats;
        }

        @Nonnull
        @CheckReturnValue
        public Stats getStats() {
            return this._stats;
        }
    }
}

