/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.RegistryEntry;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.LoginInfo;
import org.rvpf.config.Config;
import org.rvpf.document.loader.ConfigDocumentLoader;
import org.rvpf.jmx.Agent;
import org.rvpf.jmx.AgentSessionProxy;
import org.rvpf.service.ServiceActivatorMBean;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.ServiceRegistry;

public final class Stopper {
    private static final Logger _LOGGER = Logger.getInstance(Stopper.class);
    private LoginInfo _loginInfo;

    public static void main(@Nonnull String[] args) {
        Logger.startUp(false);
        Logger.setLogID();
        if (args.length == 0) {
            _LOGGER.error(ServiceMessages.SERVICES_NAME, new Object[0]);
            return;
        }
        Require.ignored(new Stopper().stop(args));
    }

    @CheckReturnValue
    public boolean stop(@Nonnull String[] args) {
        Config config = ConfigDocumentLoader.loadConfig("", Optional.empty(), Optional.empty());
        if (config == null) {
            _LOGGER.error(ServiceMessages.CONFIG_LOAD_FAILED, new Object[0]);
            return false;
        }
        if (!ServiceRegistry.setUp(config.getProperties())) {
            return false;
        }
        HashSet<String> serviceNames = new HashSet<String>();
        for (String arg : args) {
            Optional<String> serviceName = config.getServiceName(arg);
            if (!serviceName.isPresent()) {
                _LOGGER.error(ServiceMessages.SERVICE_UNKNOWN, arg);
                return false;
            }
            serviceNames.add(serviceName.get());
        }
        this._loginInfo = Agent.getLoginInfo(config);
        for (String serviceName : serviceNames) {
            if (this._stop(Require.notNull(serviceName))) continue;
            return false;
        }
        return true;
    }

    private boolean _stop(String serviceName) {
        ServiceActivatorMBean service;
        _LOGGER.info(ServiceMessages.STOPPING_SERVICE, serviceName);
        RegistryEntry registryEntry = RegistryEntry.newBuilder().setName(Optional.of(serviceName)).setDefaultPrefix("service/").setDefaultRegistryAddress(ServiceRegistry.getRegistryAddress()).setDefaultRegistryPort(ServiceRegistry.getRegistryPort()).build();
        if (registryEntry == null) {
            return false;
        }
        AgentSessionProxy proxy = (AgentSessionProxy)AgentSessionProxy.newBuilder().setRegistryEntry(registryEntry).setLoginInfo(this._loginInfo).setAutoconnect(true).setClientName(this.getClass().getName()).setClientLogger(_LOGGER).build();
        if (proxy == null) {
            return false;
        }
        try {
            service = proxy.getMBeanProxy(ServiceActivatorMBean.class);
        }
        catch (SessionException exception) {
            Throwable cause = exception;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            _LOGGER.error(ServiceMessages.SERVICE_CONNECT_FAILED, serviceName, cause.getMessage());
            return false;
        }
        try {
            service.stop();
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            // empty catch block
        }
        _LOGGER.info(ServiceMessages.SERVICE_STOPPED, serviceName);
        proxy.tearDown();
        return true;
    }
}

