/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.service.ServiceMessages;

@ThreadSafe
public class ThreadExecutor
implements ExecutorService,
Runnable {
    private static final int _INITIAL_STATE = 0;
    private static final int _READY_STATE = 1;
    private static final int _RUNNING_STATE = 2;
    private static final int _SHUTDOWN_STATE = 3;
    private static final int _STOPPING_STATE = 4;
    private static final int _TERMINATED_STATE = 5;
    private String _logID;
    private final Logger _logger;
    private final Lock _mainLock = new ReentrantLock();
    private Lock _runLock = new ReentrantLock();
    private volatile int _runState = 0;
    private Thread _runThread;
    private final Condition _termination = this._mainLock.newCondition();
    private final BlockingQueue<Runnable> _workQueue = new LinkedBlockingQueue<Runnable>();

    public ThreadExecutor(@Nonnull Optional<Logger> logger) {
        this._logger = logger.orElse(Logger.getInstance(this.getClass()));
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this._mainLock.lock();
        try {
            if (this._runState < 2) {
                throw new IllegalStateException();
            }
            while (true) {
                if (this._runState == 5) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this._termination.awaitNanos(nanos);
            }
        }
        finally {
            this._mainLock.unlock();
        }
    }

    @Override
    public void execute(Runnable runnable) {
        Require.notNull(runnable);
        this._mainLock.lock();
        try {
            if (this._runThread == null || this._runState != 2) {
                throw new RejectedExecutionException();
            }
            if (!this._runThread.isAlive()) {
                this._logID = Logger.currentLogID().orElse(null);
                this._runThread.start();
            }
            try {
                this._workQueue.put(runnable);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException();
            }
        }
        finally {
            this._mainLock.unlock();
        }
    }

    @CheckReturnValue
    public <T> T invoke(@Nonnull Callable<T> callable) throws InterruptedException, ExecutionException {
        Future<T> future = this.submit(callable);
        return future.get();
    }

    @CheckReturnValue
    public <T> T invoke(Callable<T> callable, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Future<T> future = this.submit(callable);
        return future.get(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) throws InterruptedException {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(callables.size());
        for (Callable<T> callable : callables) {
            futures.add(this.submit(callable));
        }
        boolean done = false;
        try {
            for (Future future : futures) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException | ExecutionException exception) {}
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(callables.size());
        for (Callable<T> callable : callables) {
            futures.add(this.submit(callable));
        }
        boolean done = false;
        long nanos = unit.toNanos(timeout);
        long lastTime = System.nanoTime();
        try {
            for (Future future : futures) {
                if (future.isDone()) continue;
                try {
                    future.get(nanos, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException | ExecutionException exception) {
                }
                catch (TimeoutException exception) {
                    ArrayList<Future<T>> arrayList = futures;
                    if (!done) {
                        for (Future future2 : futures) {
                            future2.cancel(true);
                        }
                    }
                    return arrayList;
                }
                long now = System.nanoTime();
                nanos -= now - lastTime;
                lastTime = now;
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
        return futures;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables) throws InterruptedException, ExecutionException {
        ExecutionException lastException = null;
        for (Callable<T> callable : callables) {
            try {
                return this.invoke(callable);
            }
            catch (ExecutionException exception) {
                lastException = exception;
            }
            catch (RuntimeException exception) {
                lastException = new ExecutionException(exception);
            }
        }
        throw lastException != null ? lastException : new ExecutionException(null);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException lastException = null;
        long nanos = unit.toNanos(timeout);
        long lastTime = System.nanoTime();
        for (Callable<T> callable : callables) {
            try {
                return this.invoke(callable, nanos, TimeUnit.NANOSECONDS);
            }
            catch (ExecutionException exception) {
                lastException = exception;
                long now = System.nanoTime();
                nanos -= now - lastTime;
                lastTime = now;
            }
        }
        throw lastException != null ? lastException : new ExecutionException(null);
    }

    @CheckReturnValue
    public boolean isBusy() {
        this._mainLock.lock();
        try {
            if (this._runState > 1 && this._runState < 4) {
                if (this._runLock.tryLock()) {
                    this._runLock.unlock();
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this._mainLock.unlock();
        }
        return false;
    }

    @CheckReturnValue
    public boolean isRunning() {
        this._mainLock.lock();
        try {
            boolean bl = this._runThread != null && this._runState == 2;
            return bl;
        }
        finally {
            this._mainLock.unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        return this._runState > 2;
    }

    @Override
    public boolean isTerminated() {
        return this._runState == 5;
    }

    public void reset(@Nonnull Optional<String> threadName, boolean daemonThread) {
        this._mainLock.lock();
        try {
            if (this._runThread != null) {
                this.shutdownNow();
            }
            this._runThread = threadName.isPresent() ? new Thread((Runnable)this, threadName.get()) : new Thread(this);
            this._runThread.setDaemon(daemonThread);
            this._runThread.setUncaughtExceptionHandler(Thread.currentThread().getUncaughtExceptionHandler());
            this._runLock = new ReentrantLock();
            this._runState = 1;
        }
        finally {
            this._mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block41: {
            int state;
            Lock runLock;
            block38: {
                block36: {
                    Logger.setLogID(Optional.ofNullable(this._logID));
                    this._logger.debug(ServiceMessages.THREAD_STARTED, Thread.currentThread().getName());
                    this._mainLock.lock();
                    if (this._runThread != null) break block36;
                    this._mainLock.unlock();
                    this._mainLock.lock();
                    try {
                        if (Thread.currentThread() == this._runThread) {
                            this._terminated();
                        }
                    }
                    finally {
                        this._mainLock.unlock();
                    }
                    this._logger.debug(ServiceMessages.THREAD_STOPPED, Thread.currentThread().getName());
                    return;
                }
                runLock = this._runLock;
                break block38;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    this._mainLock.unlock();
                }
            }
            while ((state = this._runState) <= 3) {
                Runnable runnable;
                try {
                    runnable = state < 3 ? this._workQueue.take() : (Runnable)this._workQueue.poll();
                }
                catch (InterruptedException exception) {
                    continue;
                }
                if (runnable != null) {
                    runLock.lock();
                    try {
                        if (this._runState < 4 && Thread.interrupted()) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        runnable.run();
                        continue;
                    }
                    finally {
                        runLock.unlock();
                        continue;
                    }
                }
                if (this._runState <= 2) continue;
                break;
            }
            this._mainLock.lock();
            try {
                if (Thread.currentThread() == this._runThread) {
                    this._terminated();
                }
            }
            finally {
                this._mainLock.unlock();
            }
            this._logger.debug(ServiceMessages.THREAD_STOPPED, Thread.currentThread().getName());
            break block41;
            catch (Throwable throwable) {
                try {
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.currentThread().getUncaughtExceptionHandler();
                    if (uncaughtExceptionHandler == Thread.currentThread().getThreadGroup()) {
                        this._logger.error(throwable, ServiceMessages.UNEXPECTED_THREAD_EXCEPTION, Thread.currentThread().getName());
                    } else {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                    }
                    this._mainLock.lock();
                }
                catch (Throwable throwable2) {
                    this._mainLock.lock();
                    try {
                        if (Thread.currentThread() == this._runThread) {
                            this._terminated();
                        }
                    }
                    finally {
                        this._mainLock.unlock();
                    }
                    this._logger.debug(ServiceMessages.THREAD_STOPPED, Thread.currentThread().getName());
                    throw throwable2;
                }
                try {
                    if (Thread.currentThread() == this._runThread) {
                        this._terminated();
                    }
                }
                finally {
                    this._mainLock.unlock();
                }
                this._logger.debug(ServiceMessages.THREAD_STOPPED, Thread.currentThread().getName());
            }
        }
    }

    @Override
    public void shutdown() {
        block6: {
            this._mainLock.lock();
            try {
                if (this._runState >= 3) break block6;
                this._runState = 3;
                if (!this._runLock.tryLock()) break block6;
                try {
                    this._interrupt();
                }
                finally {
                    this._runLock.unlock();
                }
            }
            finally {
                this._mainLock.unlock();
            }
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        LinkedList<Runnable> runnables = new LinkedList<Runnable>();
        this._mainLock.lock();
        try {
            if (this._runState < 4) {
                this._runState = 4;
                this._interrupt();
                this._workQueue.drainTo(runnables);
            }
        }
        finally {
            this._mainLock.unlock();
        }
        return runnables;
    }

    public void startThread() {
        this._logID = Logger.currentLogID().orElse(null);
        this._mainLock.lock();
        try {
            if (this._runState == 0) {
                this.reset(Optional.empty(), true);
            }
            this._runThread.start();
            this._runState = 2;
        }
        finally {
            this._mainLock.unlock();
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        FutureTask<T> runnableFuture = new FutureTask<T>(callable);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        FutureTask<Object> runnableFuture = new FutureTask<Object>(runnable, null);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result) {
        FutureTask<T> runnableFuture = new FutureTask<T>(runnable, result);
        this.execute(runnableFuture);
        return runnableFuture;
    }

    @GuardedBy(value="_mainLock")
    private void _interrupt() {
        if (this._runThread != null) {
            if (this._runThread.isAlive()) {
                this._runThread.interrupt();
            } else {
                this._terminated();
            }
            this._runThread = null;
        }
    }

    @GuardedBy(value="_mainLock")
    private void _terminated() {
        this._runState = 5;
        this._termination.signalAll();
    }
}

