/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.app;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.ClassDef;
import org.rvpf.base.StatsOwner;
import org.rvpf.base.alert.Alert;
import org.rvpf.base.alert.Event;
import org.rvpf.base.alert.Signal;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.tool.Require;
import org.rvpf.service.ServiceImpl;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceStats;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.app.ServiceApp;
import org.rvpf.service.app.ServiceAppImpl;

public class ServiceAppHolderImpl
extends ServiceImpl {
    public static final String SERVICE_APP_CLASS_PROPERTY = "service.app.class";
    private volatile ServiceApp _serviceApp;
    private boolean _servicesReady;
    private boolean _started;

    @Nonnull
    @CheckReturnValue
    public ServiceApp getServiceApp() {
        return Require.notNull(this._serviceApp);
    }

    @Override
    public boolean onAlert(Optional<Alert> alert) {
        if (!super.onAlert(alert)) {
            return false;
        }
        ServiceApp serviceApp = this._serviceApp;
        return serviceApp == null || serviceApp.onAlert(alert.get());
    }

    @Override
    protected ServiceStats createStats(StatsOwner statsOwner) {
        return this._serviceApp != null ? this._serviceApp.createStats(statsOwner) : super.createStats(statsOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doPendingActions() throws InterruptedException, ServiceNotAvailableException {
        Object object = this.getMutex();
        synchronized (object) {
            if (super.doPendingActions()) {
                if (!this._servicesReady) {
                    this._servicesReady = true;
                    this.getServiceApp().onServicesReady();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        Require.failure(this._started);
        this.getServiceApp().start();
        this._started = true;
    }

    @Override
    protected void doStop() throws Exception {
        if (this._started) {
            this._started = false;
            this.getServiceApp().stop();
            ServiceThread.yieldAll();
        }
    }

    @Nullable
    @CheckReturnValue
    protected ClassDef getServiceAppClassDef() {
        Optional<? extends ClassDef> classDef = this.getConfig().getClassDef(SERVICE_APP_CLASS_PROPERTY, Optional.empty());
        if (!classDef.isPresent()) {
            this.getThisLogger().error(ServiceMessages.MISSING_SERVICE_PROPERTY, SERVICE_APP_CLASS_PROPERTY);
        }
        return classDef.orElse(null);
    }

    @Nullable
    @CheckReturnValue
    protected ServiceApp newServiceApp() {
        ClassDef classDef = this.getServiceAppClassDef();
        return classDef != null ? classDef.createInstance(ServiceApp.class) : null;
    }

    @Override
    protected boolean onEvent(Event event) {
        return this.getServiceApp().onEvent(event);
    }

    @Override
    protected void onServicesNotReady() {
        if (this._servicesReady) {
            this._servicesReady = false;
            this.getServiceApp().onServicesNotReady();
            super.onServicesNotReady();
        }
    }

    @Override
    protected boolean onSignal(Signal signal) {
        return this.getServiceApp().onSignal(signal);
    }

    @Override
    protected boolean setUp() {
        if (!super.setUp()) {
            return false;
        }
        this._serviceApp = this.newServiceApp();
        if (this._serviceApp == null) {
            return false;
        }
        return this._serviceApp.setUp(this);
    }

    @Override
    protected void tearDown() {
        if (this._serviceApp != null) {
            this._serviceApp.tearDown();
            this._serviceApp = new ServiceAppImpl(){};
        }
        super.tearDown();
    }
}

