/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.app;

import java.io.File;
import java.util.Optional;
import java.util.Timer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.StatsOwner;
import org.rvpf.base.UUID;
import org.rvpf.base.alert.Alert;
import org.rvpf.base.alert.Event;
import org.rvpf.base.alert.Signal;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.store.StoreAccessException;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceStats;
import org.rvpf.service.app.ServiceApp;

public abstract class ServiceAppImpl
implements ServiceApp {
    public static final String SERVICE_APP_PROPERTIES = "service.app.properties";
    private final Logger _logger = Logger.getInstance(this.getClass());
    private Service _service;

    @Override
    public ServiceStats createStats(StatsOwner statsOwner) {
        return new ServiceStats(statsOwner);
    }

    public final void fail() {
        this._service.fail();
    }

    @Nonnull
    @CheckReturnValue
    public final Config getConfig() {
        return this._service.getConfig();
    }

    @Nonnull
    @CheckReturnValue
    public KeyedGroups getConfigProperties() {
        return this.getConfig().getProperties();
    }

    @Nonnull
    @CheckReturnValue
    public final File getDataDir() {
        return this._service.getDataDir();
    }

    @CheckReturnValue
    public long getJoinTimeout() {
        return this._service.getJoinTimeout();
    }

    @Nonnull
    @CheckReturnValue
    public KeyedGroups getProperties() {
        return this._service.getConfig().getPropertiesGroup(SERVICE_APP_PROPERTIES);
    }

    @Nonnull
    @CheckReturnValue
    public Service getService() {
        return Require.notNull(this._service);
    }

    @Nonnull
    @CheckReturnValue
    public UUID getSourceUUID() {
        return this._service.getSourceUUID();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Timer> getTimer() {
        return this._service.getTimer();
    }

    @Override
    public boolean onAlert(Alert alert) {
        return true;
    }

    @Override
    public boolean onEvent(Event event) {
        return true;
    }

    @Override
    public void onServicesNotReady() {
    }

    @Override
    public void onServicesReady() {
    }

    @Override
    public boolean onSignal(Signal signal) {
        return true;
    }

    @Override
    public boolean setUp(Service service) {
        this._service = service;
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void tearDown() {
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return this._logger;
    }

    protected void onServiceNotAvailableException(@Nonnull ServiceNotAvailableException exception) {
        if (exception.getCause() != null) {
            Throwable cause = exception.getCause();
            if (cause instanceof StoreAccessException) {
                while ((cause = cause.getCause()).getCause() != null) {
                }
            }
            this.getThisLogger().error(cause, ServiceMessages.RESTART_NEEDED, new Object[0]);
        } else {
            this.getThisLogger().warn(ServiceMessages.RESTART_NEEDED, new Object[0]);
        }
        this._service.restart(true);
    }
}

