/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.log4j;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Optional;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import org.apache.logging.log4j.core.net.server.LogEventBridge;
import org.apache.logging.log4j.core.net.server.ObjectInputStreamLogEventBridge;
import org.apache.logging.log4j.core.net.server.TcpSocketServer;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.security.ServerSecurityContext;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.app.ServiceAppImpl;

public final class LoggerServiceAppImpl
extends ServiceAppImpl {
    public static final String ADDRESS_PROPERTY = "address";
    public static final String LOGGER_SERVER_PROPERTIES = "logger.server";
    private ServerSocket _serverSocket;
    private TcpSocketServer<ObjectInputStream> _socketServer;
    private Thread _thread;

    @Override
    public boolean setUp(Service service) {
        ServerSocketFactory factory;
        boolean secure;
        if (!super.setUp(service)) {
            return false;
        }
        KeyedGroups loggerServerProperties = this.getConfigProperties().getGroup(LOGGER_SERVER_PROPERTIES);
        Optional<String> addressString = loggerServerProperties.getString(ADDRESS_PROPERTY);
        if (!addressString.isPresent()) {
            this.getThisLogger().error(BaseMessages.MISSING_PROPERTY, ADDRESS_PROPERTY);
            return false;
        }
        Optional<InetSocketAddress> socketAddress = Inet.socketAddress(addressString.get());
        if (!socketAddress.isPresent()) {
            this.getThisLogger().error(BaseMessages.BAD_ADDRESS, addressString.get());
            return false;
        }
        ServerSecurityContext securityContext = new ServerSecurityContext(this.getThisLogger());
        KeyedGroups securityProperties = loggerServerProperties.getGroup("security");
        if (!securityContext.setUp(service.getConfig().getProperties(), securityProperties)) {
            return false;
        }
        boolean bl = secure = securityContext.isCertified() || securityContext.isSecure() || !securityProperties.isEmpty() || !socketAddress.get().getAddress().isLoopbackAddress();
        if (secure) {
            try {
                securityContext.checkForSecureOperation();
            }
            catch (SSLException exception) {
                this.getThisLogger().error(BaseMessages.VERBATIM, exception.getMessage());
                return false;
            }
            try {
                factory = securityContext.createSSLContext().getServerSocketFactory();
            }
            catch (SSLException exception) {
                this.getThisLogger().error(ServiceMessages.SSL_CREATE_FAILED, exception.getMessage());
                return false;
            }
        }
        factory = ServerSocketFactory.getDefault();
        try {
            this._serverSocket = factory.createServerSocket(socketAddress.get().getPort(), 0, socketAddress.get().getAddress());
        }
        catch (IOException exception) {
            this.getThisLogger().error(ServiceMessages.BIND_FAILED_, socketAddress, exception);
            return false;
        }
        if (!this._serverSocket.isBound()) {
            this.getThisLogger().error(ServiceMessages.BIND_FAILED, socketAddress);
            return false;
        }
        if (secure) {
            ((SSLServerSocket)this._serverSocket).setNeedClientAuth(securityContext.isCertified());
        }
        try {
            this._socketServer = new TcpSocketServer(this._serverSocket.getLocalPort(), (LogEventBridge)new ObjectInputStreamLogEventBridge(), this._serverSocket);
        }
        catch (IOException exception) {
            this.getThisLogger().error(ServiceMessages.LOGGER_SERVER_FAILED, exception);
            return false;
        }
        this._thread = new Thread((Runnable)this._socketServer, "Logger server (listener on " + this._serverSocket.getLocalSocketAddress() + ")");
        return true;
    }

    @Override
    public void start() {
        this._thread.start();
    }

    @Override
    public void stop() {
        try {
            this._socketServer.shutdown();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        try {
            this._thread.join();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void tearDown() {
        if (this._serverSocket != null) {
            try {
                this._serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._serverSocket = null;
        }
        super.tearDown();
    }
}

