/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.metadata;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.Point;
import org.rvpf.base.alert.Signal;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.tool.Require;
import org.rvpf.document.loader.MetadataDocumentLoader;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.metadata.entity.StoreEntity;
import org.rvpf.service.ServiceImpl;
import org.rvpf.service.metadata.MetadataService;

@ThreadSafe
public abstract class MetadataServiceImpl
extends ServiceImpl
implements MetadataService {
    private volatile Metadata _metadata;

    @Override
    public final Metadata getMetadata() {
        return Require.notNull(this._metadata);
    }

    @CheckReturnValue
    public final boolean hasMetadata() {
        return this._metadata != null;
    }

    @Override
    public final boolean loadMetadata(MetadataFilter filter) {
        Metadata metadata = MetadataDocumentLoader.fetchMetadata(Require.notNull(filter), Optional.of(this.getConfig()), this.getServiceUUID(), Optional.empty());
        if (metadata == null) {
            return false;
        }
        if (!this.onNewMetadata(metadata)) {
            return false;
        }
        metadata.setService(this);
        this._metadata = metadata;
        return true;
    }

    @Override
    public final void monitorStores() {
        for (StoreEntity storeEntity : this._metadata.getStoreEntities()) {
            this.monitorService(Optional.empty(), storeEntity.getUUID(), storeEntity.getName());
        }
    }

    @Override
    public final boolean reloadMetadata() {
        this.restoreConfigState();
        return this.loadMetadata(this.getMetadata().getFilter().clone());
    }

    @Override
    public final void resetPointsStore() throws ServiceNotAvailableException {
        for (Point point : this.getMetadata().getPointsCollection()) {
            ((PointEntity)point).tearDownStore();
        }
        for (Point point : this.getMetadata().getPointsCollection()) {
            if (((PointEntity)point).setUpStore(this.getMetadata())) continue;
            throw new ServiceNotAvailableException();
        }
    }

    @CheckReturnValue
    protected boolean onNewMetadata(@Nonnull Metadata metadata) {
        return metadata != null;
    }

    @Override
    protected boolean onSignal(Signal signal) {
        if ("RefreshMetadata".equalsIgnoreCase(signal.getName())) {
            this.setRestartSignaled(true);
            return false;
        }
        return true;
    }

    @Override
    protected void tearDown() {
        if (this._metadata != null) {
            this._metadata.tearDownPoints();
        }
        super.tearDown();
    }

    @Override
    protected void tearDownConfig() {
        if (this._metadata != null) {
            this._metadata.tearDown();
            this._metadata = null;
        }
        super.tearDownConfig();
    }
}

