/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.metadata.app;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.ClassDef;
import org.rvpf.base.StatsOwner;
import org.rvpf.base.alert.Alert;
import org.rvpf.base.alert.Event;
import org.rvpf.base.alert.Signal;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.tool.Require;
import org.rvpf.metadata.Metadata;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceStats;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.metadata.MetadataServiceImpl;
import org.rvpf.service.metadata.app.MetadataServiceApp;

public class MetadataServiceAppHolderImpl
extends MetadataServiceImpl {
    public static final String SERVICE_APP_CLASS_PROPERTY = "service.app.class";
    private volatile MetadataServiceApp _metadataServiceApp;
    private boolean _servicesReady;
    private volatile boolean _started;

    @Override
    public Optional<String> getEntityName() {
        return this.getMetadataServiceApp().getEntityName();
    }

    @Override
    public boolean onAlert(Optional<Alert> alert) {
        if (!super.onAlert(alert)) {
            return false;
        }
        MetadataServiceApp metadataServiceApp = this._metadataServiceApp;
        return metadataServiceApp != null ? metadataServiceApp.onAlert(alert.get()) : false;
    }

    @Override
    protected ServiceStats createStats(StatsOwner statsOwner) {
        return this._metadataServiceApp != null ? this._metadataServiceApp.createStats(statsOwner) : super.createStats(statsOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doPendingActions() throws InterruptedException, ServiceNotAvailableException {
        Object object = this.getMutex();
        synchronized (object) {
            if (super.doPendingActions()) {
                if (!this._servicesReady) {
                    this._servicesReady = true;
                    this.getMetadataServiceApp().onServicesReady();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        Require.failure(this._started);
        this.getMetadataServiceApp().start();
        this._started = true;
    }

    @Override
    protected void doStop() throws Exception {
        if (this._started) {
            this._started = false;
            this.getMetadataServiceApp().stop();
            ServiceThread.yieldAll();
        }
    }

    @Nonnull
    @CheckReturnValue
    protected MetadataServiceApp getMetadataServiceApp() {
        return Require.notNull(this._metadataServiceApp);
    }

    @Nullable
    @CheckReturnValue
    protected ClassDef getServiceAppClassDef() {
        Optional<? extends ClassDef> classDef = this.getConfig().getClassDef(SERVICE_APP_CLASS_PROPERTY, Optional.empty());
        if (!classDef.isPresent()) {
            this.getThisLogger().error(ServiceMessages.MISSING_SERVICE_PROPERTY, SERVICE_APP_CLASS_PROPERTY);
        }
        return classDef.orElse(null);
    }

    @Nullable
    @CheckReturnValue
    protected MetadataServiceApp newMetadataServiceApp() {
        ClassDef classDef = this.getServiceAppClassDef();
        return classDef != null ? classDef.createInstance(MetadataServiceApp.class) : null;
    }

    @Override
    protected boolean onEvent(Event event) {
        MetadataServiceApp serviceApp = this._metadataServiceApp;
        return serviceApp != null ? serviceApp.onEvent(event) : false;
    }

    @Override
    protected boolean onNewMetadata(Metadata metadata) {
        if (!this.getMetadataServiceApp().onNewMetadata(metadata)) {
            return false;
        }
        return super.onNewMetadata(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onServicesNotReady() {
        Object object = this.getMutex();
        synchronized (object) {
            if (this._servicesReady) {
                MetadataServiceApp serviceApp = this._metadataServiceApp;
                this._servicesReady = false;
                if (serviceApp != null) {
                    serviceApp.onServicesNotReady();
                }
                super.onServicesNotReady();
            }
        }
    }

    @Override
    protected boolean onSignal(Signal signal) {
        MetadataServiceApp serviceApp = this._metadataServiceApp;
        if (serviceApp != null && !serviceApp.onSignal(signal)) {
            return false;
        }
        return super.onSignal(signal);
    }

    @Override
    protected boolean setUp() {
        if (!super.setUp()) {
            return false;
        }
        this._metadataServiceApp = this.newMetadataServiceApp();
        return this._metadataServiceApp != null && this._metadataServiceApp.setUp(this);
    }

    @Override
    protected void tearDown() {
        MetadataServiceApp serviceApp = this._metadataServiceApp;
        if (serviceApp != null) {
            serviceApp.tearDown();
            this._metadataServiceApp = null;
        }
        super.tearDown();
    }
}

