/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.rlp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.rlp.Protocol;
import org.rvpf.base.util.rlp.RLPMessages;
import org.rvpf.base.util.rlp.RLPServer;
import org.rvpf.base.util.rlp.ResourceSpecifier;
import org.rvpf.service.Service;
import org.rvpf.service.app.ServiceAppImpl;

public final class RLPServiceAppImpl
extends ServiceAppImpl {
    public static final String ADDRESS_PROPERTY = "address";
    public static final String IDENTIFIER_PROPERTY = "identifier";
    public static final String PORT_PROPERTY = "port";
    public static final String PROTOCOL_PROPERTY = "protocol";
    public static final String RESOURCE_PROPERTIES = "resource";
    public static final String RLP_SERVER_PROPERTIES = "rlp.server";
    private RLPServer _server;

    @Override
    public boolean setUp(Service service) {
        int port;
        InetAddress address;
        if (!super.setUp(service)) {
            return false;
        }
        KeyedGroups rlpServerProperties = this.getConfigProperties().getGroup(RLP_SERVER_PROPERTIES);
        Optional<String> addressString = rlpServerProperties.getString(ADDRESS_PROPERTY);
        if (addressString.isPresent()) {
            Optional<InetSocketAddress> socketAddress = Inet.socketAddress(addressString.get());
            if (!socketAddress.isPresent()) {
                this.getThisLogger().error(BaseMessages.BAD_ADDRESS, addressString.get());
                return false;
            }
            address = socketAddress.get().getAddress();
            port = socketAddress.get().getPort();
        } else {
            address = null;
            port = 0;
        }
        if (port == 0) {
            port = rlpServerProperties.getInt(PORT_PROPERTY, 0);
        }
        RLPServer.Builder serverBuilder = RLPServer.newBuilder().setLocalAddress(Optional.ofNullable(address)).setLocalPort(port);
        for (KeyedGroups resourceProperties : rlpServerProperties.getGroups(RESOURCE_PROPERTIES)) {
            int protocol;
            String protocolString = resourceProperties.getString(PROTOCOL_PROPERTY, Optional.of("")).get().toUpperCase(Locale.ENGLISH);
            String identifierString = resourceProperties.getString(IDENTIFIER_PROPERTY, Optional.of("")).get();
            try {
                protocol = Integer.parseInt(protocolString);
            }
            catch (NumberFormatException exception1) {
                try {
                    protocol = Protocol.valueOf(protocolString).code();
                }
                catch (IllegalArgumentException exception2) {
                    this.getThisLogger().error(RLPMessages.UNKNOWN_PROTOCOL, protocolString);
                    return false;
                }
            }
            serverBuilder.addResourceSpecifier(ResourceSpecifier.newBuilder().setProtocol(protocol).setIdentifier(identifierString.getBytes(StandardCharsets.UTF_8)).build());
        }
        this._server = serverBuilder.build();
        return true;
    }

    @Override
    public void start() {
        try {
            this._server.start();
        }
        catch (SocketException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void stop() {
        this._server.stop(this.getJoinTimeout());
    }

    @Override
    public void tearDown() {
        if (this._server != null) {
            this.stop();
        }
        super.tearDown();
    }
}

