/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class BaseRMIServerSocketFactory
implements RMIServerSocketFactory {
    private final Optional<InetAddress> _address;

    public BaseRMIServerSocketFactory(@Nonnull Optional<InetAddress> address) {
        this._address = address;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port, 0, this.getAddress().orElse(null));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return Objects.equals(((BaseRMIServerSocketFactory)other).getAddress(), this.getAddress());
    }

    @Nonnegative
    @CheckReturnValue
    public final Optional<InetAddress> getAddress() {
        return this._address;
    }

    public int hashCode() {
        Optional<InetAddress> address = this.getAddress();
        return address.isPresent() ? address.get().hashCode() : 0;
    }
}

