/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.tool.Require;
import org.rvpf.service.ServiceClassLoader;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.ServiceRegistry;
import org.rvpf.service.rmi.SessionFactory;
import org.rvpf.service.rmi.SessionImpl;

@ThreadSafe
public abstract class ExportedSessionImpl
extends SessionImpl {
    private volatile Remote _stub;

    protected ExportedSessionImpl(@Nonnull String clientName, @Nonnull SessionFactory sessionFactory, @Nonnull Session.ConnectionMode connectionMode) {
        super(clientName, sessionFactory, connectionMode);
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed()) {
            super.close();
            if (this._stub != null) {
                if (!ServiceRegistry.isPrivate()) {
                    Optional<ServiceClassLoader> savedClassLoader = ServiceClassLoader.hideInstance();
                    try {
                        UnicastRemoteObject.unexportObject(this, true);
                    }
                    catch (NoSuchObjectException exception) {
                        throw new RuntimeException(exception);
                    }
                    finally {
                        ServiceClassLoader.restoreInstance(savedClassLoader);
                    }
                    this.getThisLogger().trace(ServiceMessages.UNEXPORTED_RMI, this, this._stub);
                }
                this._stub = null;
            }
        }
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object == this || this != this._stub && object.equals(this._stub);
    }

    public final int hashCode() {
        Remote stub = this._stub;
        return stub != null ? stub.hashCode() : super.hashCode();
    }

    public synchronized void open(@Nullable RMIClientSocketFactory clientSocketFactory, @Nullable RMIServerSocketFactory serverSocketFactory) {
        Require.equal(null, this._stub);
        this.open();
        if (ServiceRegistry.isPrivate()) {
            this._stub = this;
        } else {
            Optional<String> savedLogID = Logger.currentLogID();
            Optional<ServiceClassLoader> savedClassLoader = ServiceClassLoader.hideInstance();
            try {
                Logger.restoreLogID(Optional.empty());
                this._stub = UnicastRemoteObject.exportObject(this, 0, clientSocketFactory, serverSocketFactory);
            }
            catch (RemoteException exception) {
                throw new RuntimeException(exception);
            }
            finally {
                ServiceClassLoader.restoreInstance(savedClassLoader);
                Logger.restoreLogID(savedLogID);
            }
            Require.notNull(this._stub);
            this.getThisLogger().trace(ServiceMessages.EXPORTED_RMI, this, this._stub);
        }
    }
}

