/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.service.rmi.BaseRMIServerSocketFactory;
import org.rvpf.service.rmi.SessionSecurityContext;

public class SecureRMIServerSocketFactory
extends BaseRMIServerSocketFactory {
    private final SessionSecurityContext _securityContext;

    SecureRMIServerSocketFactory(@Nonnull Optional<InetAddress> address, @Nonnull SessionSecurityContext securityContext) {
        super(address);
        this._securityContext = Require.notNull(securityContext);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this._securityContext.getSSLServerSocketFactory().createServerSocket(port, 0, this.getAddress().orElse(null));
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        return this._securityContext == ((SecureRMIServerSocketFactory)other)._securityContext;
    }

    @Override
    public final int hashCode() {
        return this._securityContext.hashCode();
    }
}

