/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.rmi.RegistryConfig;
import org.rvpf.base.rmi.RegistryEntry;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.SnoozeAlarm;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.service.ServiceClassLoader;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.BaseRMIServerSocketFactory;
import org.rvpf.service.rmi.SessionFactory;

public final class ServiceRegistry {
    private static final Logger _LOGGER = Logger.getInstance(ServiceRegistry.class);
    private static final ElapsedTime _REGISTRY_WAIT = ElapsedTime.fromMillis(1000L);
    private static final String _SERVER_HOSTNAME_PROPERTY = "java.rmi.server.hostname";
    private static ServiceRegistry _instance;
    private final Optional<InetAddress> _address;
    private boolean _created;
    private final Map<String, SessionFactory> _exports = new ConcurrentHashMap<String, SessionFactory>();
    private final int _port;
    private final boolean _private;
    private final boolean _protected;
    private Registry _registry;
    private final boolean _shared;
    private final boolean _stealth;

    private ServiceRegistry(boolean isPrivate, InetAddress address, int port, boolean isProtected, boolean isShared) {
        this._private = isPrivate;
        this._address = this._private ? Optional.empty() : Optional.ofNullable(address);
        boolean bl = this._stealth = port == 0;
        this._port = this._private ? -1 : (this._stealth ? Inet.allocateTCPPort() : port);
        this._protected = isProtected || this._private || this._stealth;
        this._shared = isShared;
    }

    @Nonnull
    @CheckReturnValue
    public static synchronized ServiceRegistry getInstance() {
        return Require.notNull(_instance);
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<InetAddress> getRegistryAddress() {
        ServiceRegistry instance = _instance;
        return instance != null ? instance._address : Optional.empty();
    }

    @CheckReturnValue
    public static int getRegistryPort() {
        ServiceRegistry instance = _instance;
        return instance != null ? instance._port : -1;
    }

    @CheckReturnValue
    public static boolean isLocal() {
        return ServiceRegistry.getInstance()._created;
    }

    @CheckReturnValue
    public static boolean isPrivate() {
        return ServiceRegistry.getInstance()._private;
    }

    @CheckReturnValue
    public static boolean isProtected() {
        return ServiceRegistry.getInstance()._protected;
    }

    @CheckReturnValue
    public static boolean isShared() {
        return ServiceRegistry.getInstance()._shared;
    }

    @CheckReturnValue
    public static boolean isStealth() {
        return ServiceRegistry.getInstance()._stealth;
    }

    public static void purge() {
        ServiceRegistry instance = _instance;
        if (instance != null) {
            instance._purge();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CheckReturnValue
    public static synchronized boolean setUp(@Nonnull KeyedGroups configProperties) {
        RegistryConfig registryConfig = new RegistryConfig(configProperties);
        InetSocketAddress registrySocketAddress = registryConfig.getRegistrySocketAddress();
        if (registrySocketAddress == null) {
            return false;
        }
        int registryPort = registrySocketAddress.getPort();
        InetAddress registryAddress = registrySocketAddress.getAddress();
        if (_instance == null) {
            ServiceRegistry serviceRegistry = new ServiceRegistry(registryConfig.isRegistryPrivate(), registryAddress, registryPort, registryConfig.isRegistryReadOnly(), registryConfig.isRegistryShared());
            if (!serviceRegistry._setUp()) return false;
            _instance = serviceRegistry;
            return true;
        } else {
            if (ServiceRegistry._instance._private || registryPort <= 0 || registryPort == ServiceRegistry._instance._port) return true;
            _LOGGER.error(BaseMessages.RMI_REGISTRY_CONFLICT, String.valueOf(registryPort), String.valueOf(ServiceRegistry._instance._port));
            return false;
        }
    }

    @Nonnull
    @CheckReturnValue
    public Registry getRMIRegistry() {
        return Require.notNull(this._registry);
    }

    @CheckReturnValue
    public boolean isRegistered(String name) throws RemoteException {
        try {
            this._registry.lookup(name);
        }
        catch (NotBoundException exception) {
            return false;
        }
        return true;
    }

    @CheckReturnValue
    public boolean register(@Nonnull SessionFactory sessionFactory, @Nonnull String name, @Nonnull Logger logger) {
        Remote serverStub;
        if (this._exports.containsKey(name)) {
            logger.error(ServiceMessages.RMI_ALREADY_EXPORTED, name);
            return false;
        }
        try {
            serverStub = sessionFactory.export();
        }
        catch (RemoteException exception) {
            logger.error((Throwable)exception, ServiceMessages.RMI_EXPORT_FAILED, name);
            return false;
        }
        this._exports.put(name, sessionFactory);
        try {
            try {
                this._registry.bind(name, serverStub);
            }
            catch (AlreadyBoundException exception) {
                logger.warn(ServiceMessages.REBINDING_RMI, name);
                this._registry.rebind(name, serverStub);
            }
            catch (ServerException exception) {
                if (exception.getCause() instanceof AccessException) {
                    logger.error(ServiceMessages.RMI_REGISTRY_PROTECTED, new Object[0]);
                    return false;
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception, ServiceMessages.RMI_BIND_FAILED, name);
            return false;
        }
        return true;
    }

    @Nullable
    @CheckReturnValue
    public String registerServer(@Nonnull SessionFactory server, @Nonnull URI serverURI, @Nonnull Logger logger) {
        int serverPort;
        if (serverURI.isAbsolute() && !"rmi".equals(serverURI.getScheme())) {
            logger.error(BaseMessages.SCHEME_NOT_SUPPORTED, serverURI.getScheme());
            return null;
        }
        if (!Inet.isOnLocalHost(serverURI)) {
            logger.warn(BaseMessages.HOST_NOT_LOCAL, serverURI.getHost());
        }
        if ((serverPort = serverURI.getPort()) >= 0 && serverPort != ServiceRegistry.getRegistryPort()) {
            logger.error(BaseMessages.RMI_REGISTRY_CONFLICT, String.valueOf(serverURI.getPort()), String.valueOf(ServiceRegistry.getRegistryPort()));
            return null;
        }
        String serverName = serverURI.getPath();
        if (serverName == null) {
            throw new IllegalArgumentException(Message.format(ServiceMessages.SERVER_IDENTIFICATION, new Object[0]));
        }
        if (serverName.startsWith("/")) {
            serverName = serverName.substring(1);
        }
        if (serverName.isEmpty()) {
            throw new IllegalArgumentException(Message.format(ServiceMessages.SERVER_IDENTIFICATION, new Object[0]));
        }
        if (!this.register(server, serverName, logger)) {
            return null;
        }
        logger.info(ServiceMessages.REGISTERED_RMI, serverName);
        return serverName;
    }

    public void unregister(@Nonnull String name, @Nonnull Logger logger) {
        if (name != null) {
            try {
                this._registry.unbind(name);
                logger.info(ServiceMessages.UNREGISTERED_RMI, name);
            }
            catch (RemoteException exception) {
                logger.debug(ServiceMessages.RMI_UNBIND_FAILED, name, exception);
            }
            catch (NotBoundException exception) {
                logger.warn(ServiceMessages.RMI_NOT_BOUND, name);
            }
            SessionFactory sessionFactory = this._exports.get(name);
            if (sessionFactory != null) {
                try {
                    sessionFactory.unexport();
                }
                catch (NoSuchObjectException exception) {
                    logger.warn(ServiceMessages.RMI_NOT_EXPORTED, name);
                }
                this._exports.remove(name);
            } else {
                logger.warn(ServiceMessages.RMI_NOT_REGISTERED, name);
            }
        }
    }

    private void _purge() {
        for (String exportedName : this._exports.keySet()) {
            _LOGGER.warn(ServiceMessages.REGISTRY_EXPORT_PURGED, exportedName);
            this.unregister(exportedName, _LOGGER);
        }
        if (this._created) {
            try {
                for (String registeredName : this._registry.list()) {
                    _LOGGER.warn(ServiceMessages.REGISTRY_ENTRY_PURGED, registeredName);
                    this._registry.unbind(registeredName);
                }
            }
            catch (Exception exception) {
                _LOGGER.error((Throwable)exception, BaseMessages.VERBATIM, exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean _setUp() {
        if (this._private) {
            this._registry = new _Private();
            _LOGGER.info(ServiceMessages.CREATED_RMI_REGISTRY_PRIVATE, new Object[0]);
            RegistryEntry.setRegistry(this._registry, true);
            return true;
        }
        Class<RMISocketFactory> clazz = RMISocketFactory.class;
        synchronized (RMISocketFactory.class) {
            if (RMISocketFactory.getSocketFactory() == null) {
                try {
                    RMISocketFactory.setSocketFactory(new SocketFactory());
                }
                catch (IOException exception) {
                    throw new InternalError(exception);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            boolean loggedWaiting = false;
            SnoozeAlarm snoozeAlarm = null;
            while (true) {
                try {
                    Optional<String> savedLogID = Logger.currentLogID();
                    Optional<ServiceClassLoader> savedClassLoader = ServiceClassLoader.hideInstance();
                    try {
                        Logger.restoreLogID(Optional.empty());
                        this._registry = LocateRegistry.createRegistry(this._port, null, this._protected ? new ReadOnlyRegistrySocketFactory(this._address) : new BaseRMIServerSocketFactory(this._address));
                    }
                    finally {
                        ServiceClassLoader.restoreInstance(savedClassLoader);
                        Logger.restoreLogID(savedLogID);
                    }
                    if (!this._address.get().isAnyLocalAddress()) {
                        System.setProperty(_SERVER_HOSTNAME_PROPERTY, this._address.get().getHostAddress());
                    }
                    this._created = true;
                }
                catch (RemoteException remoteException) {
                    if (!this._shared) {
                        _LOGGER.error(ServiceMessages.RMI_REGISTRY_CREATE_FAILED, String.valueOf(this._port), remoteException.getCause());
                        return false;
                    }
                    try {
                        Registry registry = LocateRegistry.getRegistry(this._address.get().getHostAddress(), this._port);
                        registry.list();
                        this._registry = registry;
                        break;
                    }
                    catch (ConnectException exception) {
                        if (!loggedWaiting) {
                            _LOGGER.info(ServiceMessages.RMI_REGISTRY_WAIT, new Object[0]);
                            loggedWaiting = true;
                        }
                        if (snoozeAlarm == null) {
                            snoozeAlarm = new SnoozeAlarm(ServiceRegistry.class);
                        }
                        try {
                            snoozeAlarm.snooze(_REGISTRY_WAIT);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new RuntimeException(interruptedException);
                        }
                    }
                    continue;
                    catch (RemoteException exception) {
                        _LOGGER.error((Throwable)exception, ServiceMessages.RMI_REGISTRY_FAILED, String.valueOf(this._port));
                        return false;
                    }
                }
                break;
            }
            InetSocketAddress registrySocketAddress = new InetSocketAddress(this._address.orElse(null), this._port);
            if (this._created) {
                _LOGGER.info(this._stealth ? ServiceMessages.CREATED_RMI_REGISTRY_STEALTH : (this._protected ? ServiceMessages.CREATED_RMI_REGISTRY_PROTECTED : ServiceMessages.CREATED_RMI_REGISTRY), registrySocketAddress);
            } else {
                _LOGGER.info(ServiceMessages.GOT_RMI_REGISTRY, registrySocketAddress);
            }
            RegistryEntry.setRegistry(this._registry, false);
            return true;
        }
    }

    private static final class _Private
    implements Registry {
        private final Map<String, Remote> _bindings = new HashMap<String, Remote>();

        _Private() {
        }

        @Override
        public void bind(String name, Remote remote) throws AlreadyBoundException {
            String key = _Private._key(name);
            Require.notNull(remote);
            if (this._bindings.containsKey(key)) {
                throw new AlreadyBoundException();
            }
            this._bindings.put(key, remote);
        }

        @Override
        public String[] list() throws RemoteException, AccessException {
            Set<String> keys = this._bindings.keySet();
            return keys.toArray(new String[keys.size()]);
        }

        @Override
        public Remote lookup(String name) throws NotBoundException {
            String key = _Private._key(name);
            Remote remote = this._bindings.get(key);
            if (remote == null) {
                throw new NotBoundException(key);
            }
            return remote;
        }

        @Override
        public void rebind(String name, Remote remote) throws RemoteException, AccessException {
            Require.notNull(remote);
            this._bindings.put(_Private._key(name), remote);
        }

        @Override
        public void unbind(String name) throws NotBoundException {
            if (this._bindings.remove(_Private._key(name)) == null) {
                throw new NotBoundException();
            }
        }

        private static String _key(String name) {
            String key = URI.create(name).getPath();
            if (key.startsWith("/")) {
                key = key.substring(1);
            }
            return key;
        }
    }

    private static final class SocketFactory
    extends RMISocketFactory {
        SocketFactory() {
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port, 0, ServiceRegistry.getRegistryAddress().orElse(null));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            Socket socket = new Socket(host, port);
            socket.setSoLinger(false, 0);
            return socket;
        }
    }

    private static final class ReadOnlyRegistrySocketFactory
    extends BaseRMIServerSocketFactory {
        ReadOnlyRegistrySocketFactory(@Nonnull Optional<InetAddress> address) {
            super(address);
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return new NotLocalServerSocket(port, this.getAddress());
        }
    }

    private static final class NotLocalSocket
    extends Socket {
        NotLocalSocket() {
        }

        @Override
        public InetAddress getInetAddress() {
            return null;
        }
    }

    private static final class NotLocalServerSocket
    extends ServerSocket {
        public NotLocalServerSocket(int port, @Nonnull Optional<InetAddress> bindAddr) throws IOException {
            super(port, 0, bindAddr.orElse(null));
        }

        @Override
        public Socket accept() throws IOException {
            NotLocalSocket socket = new NotLocalSocket();
            this.implAccept(socket);
            return socket;
        }
    }
}

