/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.rmi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.CertifiedClientSocketFactory;
import org.rvpf.base.rmi.ClientSocketFactory;
import org.rvpf.base.rmi.SecureClientSocketFactory;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.security.Realm;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.ConcurrentIdentityHashSet;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.ListHashMap;
import org.rvpf.base.util.container.ListMap;
import org.rvpf.config.Config;
import org.rvpf.service.ServiceClassLoader;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.rmi.BaseRMIServerSocketFactory;
import org.rvpf.service.rmi.CertifiedRMIServerSocketFactory;
import org.rvpf.service.rmi.SecureRMIServerSocketFactory;
import org.rvpf.service.rmi.ServiceRegistry;
import org.rvpf.service.rmi.SessionFactory;
import org.rvpf.service.rmi.SessionImpl;
import org.rvpf.service.rmi.SessionSecurityContext;

@ThreadSafe
public abstract class SessionFactoryImpl
implements SessionFactory {
    private final AtomicBoolean _closed = new AtomicBoolean();
    private volatile Config _config;
    private String _logID;
    private final Logger _logger = Logger.getInstance(this.getClass());
    private final Realm _realm = new Realm();
    private final ListMap<String, String> _rolesMap = new ListHashMap<String, String>();
    private volatile SessionSecurityContext _securityContext;
    private final Set<SessionImpl> _sessions = new ConcurrentIdentityHashSet<SessionImpl>();
    private volatile Remote _stub;

    protected SessionFactoryImpl() {
        this(Optional.empty());
    }

    protected SessionFactoryImpl(@Nonnull Optional<SessionSecurityContext> securityContext) {
        this._securityContext = securityContext.orElse(null);
    }

    @Nullable
    @CheckReturnValue
    public static SessionSecurityContext createSecurityContext(@Nonnull KeyedGroups configProperties, @Nonnull KeyedGroups securityProperties, @Nonnull Logger logger) {
        SessionSecurityContext securityContext = new SessionSecurityContext(logger);
        if (!securityContext.setUp(configProperties, securityProperties)) {
            return null;
        }
        return securityContext;
    }

    @Override
    public final boolean addSession(SessionImpl session) {
        return this._sessions.add(session);
    }

    public void close() {
        if (this._closed.compareAndSet(false, true)) {
            for (SessionImpl session : new ArrayList<SessionImpl>(this._sessions)) {
                session.close();
            }
        }
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object == this || object.equals(this._stub);
    }

    @Override
    public final synchronized Remote export() throws RemoteException {
        Require.equal(null, this._stub);
        if (ServiceRegistry.isPrivate()) {
            this._stub = (Remote)((Object)this);
        } else {
            Optional<String> savedLogID = Logger.currentLogID();
            Optional<ServiceClassLoader> savedClassLoader = ServiceClassLoader.hideInstance();
            try {
                Logger.restoreLogID(Optional.empty());
                this._stub = UnicastRemoteObject.exportObject((Remote)((Object)this), 0);
            }
            finally {
                ServiceClassLoader.restoreInstance(savedClassLoader);
                Logger.restoreLogID(savedLogID);
            }
            Require.notNull(this._stub);
            this.getThisLogger().trace(ServiceMessages.EXPORTED_RMI, this, this._stub);
        }
        return this._stub;
    }

    @Override
    public final Config getConfig() {
        return Require.notNull(this._config);
    }

    @Override
    public final String[] getMappedRoles(String requiredRole) {
        List<String> roles = this._rolesMap.getAll(requiredRole);
        return roles.toArray(new String[roles.size()]);
    }

    @Override
    public final Optional<Realm> getRealm() {
        return Optional.of(this._realm);
    }

    @Override
    public final boolean hasRolesMap() {
        return this._rolesMap != null;
    }

    public final int hashCode() {
        Remote stub = this._stub;
        return stub != null && stub != this ? stub.hashCode() : super.hashCode();
    }

    @CheckReturnValue
    public final boolean isClosed() {
        return this._closed.get();
    }

    @Override
    public boolean removeSession(SessionImpl session) {
        return this._sessions.remove(session);
    }

    @CheckReturnValue
    public synchronized boolean setUp(@Nonnull Config config) {
        KeyedGroups realmProperties;
        this._config = config;
        if (this._securityContext == null) {
            this._securityContext = SessionFactoryImpl.createSecurityContext(config.getProperties(), KeyedGroups.MISSING_KEYED_GROUP, this.getThisLogger());
            if (this._securityContext == null) {
                return false;
            }
        }
        if (!(realmProperties = this._securityContext.getRealmProperties()).isMissing() && !this._realm.setUp(this._securityContext.getRealmProperties(), this._securityContext)) {
            return false;
        }
        this.fillRolesMap();
        for (List roles : this._rolesMap.values()) {
            if (roles.size() <= 0) continue;
            if (!realmProperties.isMissing()) break;
            this.getThisLogger().error(ServiceMessages.ROLES_REQUIRE_REALM, new Object[0]);
            return false;
        }
        this._logID = Logger.currentLogID().orElse(null);
        return true;
    }

    public void tearDown() {
        this.close();
    }

    @Override
    public final synchronized void unexport() throws NoSuchObjectException {
        Require.notNull(this._stub);
        if (!ServiceRegistry.isPrivate()) {
            Optional<ServiceClassLoader> savedClassLoader = ServiceClassLoader.hideInstance();
            try {
                UnicastRemoteObject.unexportObject((Remote)((Object)this), true);
            }
            finally {
                ServiceClassLoader.restoreInstance(savedClassLoader);
            }
            this.getThisLogger().trace(ServiceMessages.UNEXPORTED_RMI, this, this._stub);
        }
        this._stub = null;
    }

    @Nonnull
    @CheckReturnValue
    protected final Session createSession(@Nonnull UUID uuid, @Nonnull Object reference) throws SessionException {
        Session session;
        Logger.setLogID(Optional.ofNullable(this._logID));
        if (ServiceRegistry.isPrivate()) {
            session = this.createSession(Session.ConnectionMode.PRIVATE, Optional.empty(), Optional.empty(), reference);
        } else {
            boolean local;
            SessionSecurityContext securityContext = this._securityContext;
            if (securityContext.isSecure()) {
                local = false;
            } else {
                InetAddress address;
                String name;
                try {
                    name = RemoteServer.getClientHost();
                }
                catch (ServerNotActiveException exception) {
                    throw new RuntimeException(exception);
                }
                try {
                    address = InetAddress.getByName(name);
                }
                catch (UnknownHostException exception) {
                    throw new RuntimeException(exception);
                }
                local = Inet.isOnLocalHost(address);
            }
            Optional<InetAddress> registerAddress = ServiceRegistry.getRegistryAddress();
            session = local ? this.createSession(Session.ConnectionMode.LOCAL, Optional.of(new ClientSocketFactory(uuid)), Optional.of(new BaseRMIServerSocketFactory(registerAddress)), reference) : (securityContext.isCertified() ? this.createSession(Session.ConnectionMode.CERTIFIED, Optional.of(new CertifiedClientSocketFactory(uuid)), Optional.of(new CertifiedRMIServerSocketFactory(registerAddress, securityContext)), reference) : this.createSession(Session.ConnectionMode.SECURE, Optional.of(new SecureClientSocketFactory(uuid)), Optional.of(new SecureRMIServerSocketFactory(registerAddress, securityContext)), reference));
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    protected final Session createSession(@Nonnull Session.ConnectionMode connectionMode, @Nonnull Optional<RMIClientSocketFactory> clientSocketFactory, @Nonnull Optional<RMIServerSocketFactory> serverSocketFactory, @Nonnull Object reference) throws SessionException {
        Session session;
        SessionFactoryImpl sessionFactoryImpl = this;
        synchronized (sessionFactoryImpl) {
            if (this.isClosed()) {
                throw new ServiceClosedException();
            }
            session = this.newSession(connectionMode, clientSocketFactory, serverSocketFactory, reference);
        }
        ServiceThread.yieldAll();
        return session;
    }

    protected abstract void fillRolesMap();

    @CheckReturnValue
    protected final int getSessionCount() {
        return this._sessions.size();
    }

    @Nonnull
    @CheckReturnValue
    protected final Collection<SessionImpl> getSessions() {
        return this._sessions;
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return this._logger;
    }

    @CheckReturnValue
    protected boolean hasSecurityContext() {
        return this._securityContext != null;
    }

    protected final void mapRoles(@Nonnull String requiredRole, @Nonnull String[] roles) {
        for (String role : roles) {
            this._rolesMap.add(requiredRole, role);
            this.getThisLogger().debug(ServiceMessages.ROLE, requiredRole, role);
        }
    }

    @Nonnull
    @CheckReturnValue
    protected abstract Session newSession(@Nonnull Session.ConnectionMode var1, @Nonnull Optional<RMIClientSocketFactory> var2, @Nonnull Optional<RMIServerSocketFactory> var3, Object var4) throws SessionException;
}

