/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.rmi;

import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.Unreferenced;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.rmi.LoginFailedException;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.UnauthorizedAccessException;
import org.rvpf.base.security.Identity;
import org.rvpf.base.security.Realm;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.ServiceRegistry;
import org.rvpf.service.rmi.SessionFactory;

@ThreadSafe
public abstract class SessionImpl
implements Session,
Unreferenced {
    private volatile String _clientHost;
    private final String _clientName;
    private volatile boolean _closed;
    private final Session.ConnectionMode _connectionMode;
    private volatile Identity _identity;
    private final String _logID;
    private final Logger _logger = Logger.getInstance(this.getClass());
    private final Object _mutex = new Object();
    private final SessionFactory _sessionFactory;

    protected SessionImpl(@Nonnull String clientName, @Nonnull SessionFactory sessionFactory, @Nonnull Session.ConnectionMode connectionMode) {
        this._sessionFactory = sessionFactory;
        this._connectionMode = connectionMode;
        this._clientName = clientName;
        this._logID = Logger.currentLogID().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Logger.setLogID(Optional.ofNullable(this._logID));
        Object object = this._mutex;
        synchronized (object) {
            if (!this._closed) {
                if (this._sessionFactory != null && this._sessionFactory.removeSession(this)) {
                    this.getThisLogger().debug(ServiceMessages.SESSION_CLOSED, this);
                    this._clientHost = null;
                }
                this._closed = true;
            }
        }
    }

    @Override
    public final Session.ConnectionMode getConnectionMode() {
        return this._connectionMode;
    }

    @Nonnull
    @CheckReturnValue
    public final SessionFactory getSessionFactory() {
        return this._sessionFactory;
    }

    @CheckReturnValue
    public boolean isClosed() {
        return this._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void login(String identifier, char[] password) throws LoginFailedException, ServiceClosedException {
        Logger.setLogID(Optional.ofNullable(this._logID));
        try {
            Object object = this._mutex;
            synchronized (object) {
                if (this.isClosed()) {
                    throw new ServiceClosedException();
                }
                Optional<Realm> realm = this._sessionFactory.getRealm();
                if (!realm.isPresent()) {
                    throw new LoginFailedException(ServiceMessages.LOGIN_NOT_CONFIGURED, new Object[0]);
                }
                if (identifier == null || password == null) {
                    throw new LoginFailedException(ServiceMessages.ILLEGAL_ARGUMENTS, new Object[0]);
                }
                this._identity = realm.get().authenticate(identifier, password).orElse(null);
                if (this._identity == null) {
                    this.getThisLogger().warn(ServiceMessages.LOGIN_FAILED, identifier, this);
                    this.close();
                    throw new LoginFailedException(ServiceMessages.AUTHENTICATION_FAILED, new Object[0]);
                }
                this.getThisLogger().debug(ServiceMessages.LOGIN_COMPLETED, identifier, this);
            }
        }
        catch (Error | RuntimeException throwable) {
            this.getThisLogger().warn(throwable, ServiceMessages.UNEXPECTED_SESSION_EXCEPTION, throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void logout() {
        Logger.setLogID(Optional.ofNullable(this._logID));
        try {
            Object object = this._mutex;
            synchronized (object) {
                Optional<String> user = this.getUser();
                if (user.isPresent()) {
                    this._identity = null;
                    this.getThisLogger().debug(ServiceMessages.LOGOUT_COMPLETED, user.get());
                }
            }
            this.close();
        }
        catch (Error | RuntimeException throwable) {
            this.getThisLogger().warn(throwable, ServiceMessages.UNEXPECTED_SESSION_EXCEPTION, throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Object object = this._mutex;
        synchronized (object) {
            if (this._sessionFactory != null && this._sessionFactory.addSession(this)) {
                if (ServiceRegistry.isPrivate()) {
                    this._clientHost = "";
                } else {
                    try {
                        this._clientHost = RemoteServer.getClientHost();
                    }
                    catch (ServerNotActiveException exception) {
                        this._clientHost = "";
                    }
                }
                this.getThisLogger().debug(ServiceMessages.SESSION_OPENED, this);
            }
            this._closed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void securityCheck(@Nonnull String requiredRole) throws UnauthorizedAccessException, ServiceClosedException {
        if (this.isClosed()) {
            throw new ServiceClosedException();
        }
        if (this._sessionFactory != null && this._sessionFactory.hasRolesMap()) {
            boolean ok;
            String[] roles = this._sessionFactory.getMappedRoles(requiredRole);
            boolean bl = ok = roles.length == 0;
            if (!ok) {
                Object object = this._mutex;
                synchronized (object) {
                    Identity identity = this._identity;
                    if (identity != null) {
                        ok = identity.isInRoles(roles);
                    }
                }
            }
            if (!ok) {
                throw new UnauthorizedAccessException(ServiceMessages.ROLE_REQUIRED, requiredRole);
            }
        }
        Logger.setLogID(Optional.ofNullable(this._logID));
    }

    public String toString() {
        return Message.format(ServiceMessages.SESSION_IMPL, this._connectionMode != null ? (Object)((Object)this._connectionMode) + " " : "", this.getClientName(), this._clientHost);
    }

    @Override
    public final void unreferenced() {
        this.close();
    }

    @Nonnull
    @CheckReturnValue
    protected final String getClientName() {
        return this._clientName != null ? this._clientName : "";
    }

    @Nonnull
    @CheckReturnValue
    protected final Identity getIdentity(@Nonnull Optional<String> identifier) {
        Optional<Realm> realm = this._sessionFactory.getRealm();
        return realm.isPresent() ? realm.get().getIdentity(identifier) : Realm.UNKNOWN_IDENTITY;
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return this._logger;
    }

    @Nonnull
    @CheckReturnValue
    protected Optional<String> getUser() {
        return Optional.ofNullable(this._identity != null ? this._identity.getName() : null);
    }

    protected void setLogID() {
        Logger.setLogID(Optional.ofNullable(this._logID));
    }

    protected void setUser(@Nonnull Optional<String> identifier) {
        this._identity = identifier.isPresent() ? this.getIdentity(identifier) : null;
    }
}

