/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.rmi;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.security.ServerSecurityContext;
import org.rvpf.base.tool.Require;

@ThreadSafe
public final class SessionSecurityContext
extends ServerSecurityContext {
    private ServerSocketFactory _socketFactory;

    SessionSecurityContext(@Nonnull Logger logger) {
        super(logger);
    }

    @Override
    @GuardedBy(value="this")
    protected void useDefaults() throws SSLException {
        super.useDefaults();
        if (this.getKeyStoreConfig().getPath() == null) {
            throw new SSLException("Not configured for secure operation");
        }
    }

    @Nonnull
    @CheckReturnValue
    synchronized ServerSocketFactory getSSLServerSocketFactory() throws SSLException {
        if (this._socketFactory == null) {
            this._socketFactory = Require.notNull(this.createSSLContext().getServerSocketFactory());
        }
        return this._socketFactory;
    }
}

