/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.som;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.alert.Alert;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.RegistryEntry;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.rmi.SessionNotConnectedException;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.SnoozeAlarm;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.service.Alerter;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.rmi.ServiceRegistry;
import org.rvpf.service.som.SOMFactory;
import org.rvpf.service.som.SOMPublisher;
import org.rvpf.service.som.SOMSubscriber;
import org.rvpf.som.SOMServerImpl;

public final class SOMAlerter
extends Alerter.Abstract
implements ServiceThread.Target {
    public static final String DEFAULT_TOPIC = "Alerts";
    public static final String TOPIC_PROPERTIES = "som.topic";
    private static final Alerter.SharedContext _SHARED_CONTEXT = new Alerter.SharedContext();
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();
    private final _AlerterTopic _topic = new _AlerterTopic();

    @Override
    public boolean isEmbedded() {
        return this._topic.isServer();
    }

    @Override
    public boolean isRunning() {
        return this._topic.isOpen();
    }

    @Override
    public void run() {
        boolean reconnecting = false;
        block0: while (!this.isStopped() && this._topic.open(reconnecting) && !this.isStopped()) {
            ServiceThread.ready();
            while (true) {
                Serializable message;
                if ((message = this._topic.receive(0L)) == null && (message = this._topic.receive(-1L)) == null) {
                    this.notifyListeners(Optional.empty());
                    this._topic.close();
                    reconnecting = true;
                    continue block0;
                }
                if (this.isStopped()) continue block0;
                if (!(message instanceof Alert)) continue;
                this.notifyListeners(Optional.of((Alert)message));
            }
        }
    }

    @Override
    protected void doSend(Alert alert) throws InterruptedException, ServiceNotAvailableException {
        try {
            this._topic.send(alert);
        }
        catch (ServiceClosedException | SessionNotConnectedException exception) {
            InterruptedException interruptedException = new InterruptedException();
            interruptedException.initCause(exception);
            throw interruptedException;
        }
        catch (SessionException exception) {
            throw new ServiceNotAvailableException(exception);
        }
    }

    @Override
    protected boolean doSetUp() {
        KeyedGroups alerterProperties = this.getAlerterProperties();
        KeyedGroups topicProperties = alerterProperties.getGroup(TOPIC_PROPERTIES);
        RegistryEntry registryEntry = RegistryEntry.newBuilder().setBinding(topicProperties.getString("binding")).setName(topicProperties.getString("name")).setDefaultPrefix("topic/").setDefaultName(DEFAULT_TOPIC).setDefaultRegistryAddress(ServiceRegistry.getRegistryAddress()).setDefaultRegistryPort(ServiceRegistry.getRegistryPort()).build();
        if (registryEntry == null) {
            return false;
        }
        boolean embeddedTopic = false;
        if ((alerterProperties.getBoolean("embedded") || SOMFactory.isServer(topicProperties)) && this.getService() != null) {
            String path = registryEntry.getPath();
            try {
                if (!ServiceRegistry.getInstance().isRegistered(path)) {
                    embeddedTopic = true;
                    Logger.getInstance(this.getOwner().getClass()).info(ServiceMessages.EMBEDDING_ALERTER_TOPIC, new Object[0]);
                }
            }
            catch (RemoteException exception) {
                this.getThisLogger().error((Throwable)exception, ServiceMessages.RMI_REGISTRY_FAILED, String.valueOf(ServiceRegistry.getRegistryPort()));
                return false;
            }
        }
        KeyedGroups keyedGroups = topicProperties = topicProperties.isMissing() ? new SOMFactory.Properties() : topicProperties.copy();
        if (!registryEntry.isPrivate()) {
            topicProperties.setValue("binding", registryEntry.toString());
        }
        if (embeddedTopic) {
            topicProperties.setValue("server", Boolean.TRUE);
        }
        topicProperties.freeze();
        return this._topic.setUp(topicProperties);
    }

    @Override
    protected void doStart() throws InterruptedException {
        Optional<Service> service = this.getService();
        String serviceName = service.isPresent() ? service.get().getServiceName() : null;
        ServiceThread thread = new ServiceThread(this, "Alerter listener" + (serviceName != null ? " for [" + serviceName + "]" : ""));
        if (this._thread.compareAndSet(null, thread)) {
            this.getThisLogger().debug(ServiceMessages.STARTING_THREAD, thread.getName());
            Require.ignored(thread.start(true));
        }
    }

    @Override
    protected void doStop() {
        ServiceThread thread = this._thread.getAndSet(null);
        if (thread != null) {
            this.getThisLogger().debug(ServiceMessages.STOPPING_THREAD, thread.getName());
            thread.interrupt();
            this._topic.close();
            Require.ignored(thread.join(Logger.getInstance(this.getOwner().getClass()), 0L));
        }
    }

    @Override
    protected void doTearDown() {
        this._topic.tearDown();
    }

    @Override
    protected Alerter.SharedContext sharedContext() {
        return _SHARED_CONTEXT;
    }

    @CheckReturnValue
    boolean isStopped() {
        return this._thread.get() == null;
    }

    private final class _AlerterTopic {
        private ElapsedTime _connectionRetryDelay;
        private volatile SOMPublisher _publisher;
        private volatile SOMSubscriber _subscriber;

        _AlerterTopic() {
        }

        void close() {
            SOMPublisher publisher;
            SOMSubscriber subscriber = this._subscriber;
            if (subscriber != null) {
                subscriber.close();
            }
            if ((publisher = this._publisher) != null) {
                Optional<? extends SOMServerImpl> server = publisher.getServer();
                publisher.close();
                if (server.isPresent()) {
                    server.get().close();
                }
            }
        }

        @CheckReturnValue
        boolean isOpen() {
            SOMSubscriber subscriber = this._subscriber;
            return subscriber != null && subscriber.isOpen();
        }

        @CheckReturnValue
        boolean isServer() {
            SOMPublisher publisher = this._publisher;
            return publisher != null ? publisher.isServer() : false;
        }

        @CheckReturnValue
        boolean open(boolean reconnecting) {
            SOMSubscriber subscriber = this._subscriber;
            SOMPublisher publisher = this._publisher;
            if (subscriber == null || publisher == null) {
                return false;
            }
            boolean retryNotified = reconnecting;
            while (!SOMAlerter.this.isStopped()) {
                if (!reconnecting && subscriber.open()) {
                    if (publisher.open()) {
                        if (!retryNotified) break;
                        SOMAlerter.this.getThisLogger().info(ServiceMessages.ALERTER_AVAILABLE, new Object[0]);
                        break;
                    }
                    subscriber.close();
                }
                Optional<Service> service = SOMAlerter.this.getService();
                if (this._connectionRetryDelay == null || !service.isPresent()) {
                    return false;
                }
                if (SOMAlerter.this.isStopped()) break;
                if (reconnecting || !retryNotified) {
                    SOMAlerter.this.getThisLogger().info(ServiceMessages.ALERTER_WAIT, new Object[0]);
                    retryNotified = true;
                    reconnecting = false;
                }
                try {
                    service.get().snooze(this._connectionRetryDelay);
                    if (!service.get().isStopping()) continue;
                    SOMAlerter.this.getThisLogger().warn(ServiceMessages.CANCELLED, new Object[0]);
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    SOMAlerter.this.getThisLogger().warn(ServiceMessages.INTERRUPTED, new Object[0]);
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            return !SOMAlerter.this.isStopped();
        }

        @Nullable
        @CheckReturnValue
        Serializable receive(long timeout) {
            SOMSubscriber subscriber = this._subscriber;
            if (subscriber == null) {
                return null;
            }
            Serializable[] messages = subscriber.receive(1, timeout);
            return messages != null && messages.length > 0 ? messages[0] : null;
        }

        void send(@Nonnull Alert alert) throws SessionException {
            if (SOMAlerter.this.isStopped()) {
                throw new ServiceClosedException();
            }
            SOMPublisher publisher = this._publisher;
            if (publisher != null && !publisher.send(new Serializable[]{alert})) {
                throw publisher.getException().get();
            }
        }

        @CheckReturnValue
        boolean setUp(@Nonnull KeyedGroups topicProperties) {
            SOMFactory factory = new SOMFactory(SOMAlerter.this.getConfig());
            SOMFactory.Topic factoryTopic = factory.createTopic(topicProperties);
            SOMPublisher publisher = factoryTopic.createPublisher(false);
            SOMSubscriber subscriber = factoryTopic.createSubscriber(false);
            if (publisher == null || subscriber == null) {
                return false;
            }
            if (publisher.isRemote()) {
                SOMAlerter.this.getThisLogger().info(ServiceMessages.ALERTER_IS_REMOTE, publisher.getServerURI());
            }
            this._publisher = publisher;
            this._subscriber = subscriber;
            if (this.isServer()) {
                this._connectionRetryDelay = null;
            } else {
                this._connectionRetryDelay = SOMAlerter.this.getAlerterProperties().getElapsed("connection.retry.delay", Optional.of(Alerter.Abstract.DEFAULT_CONNECTION_RETRY_DELAY), Optional.of(Alerter.Abstract.DEFAULT_CONNECTION_RETRY_DELAY)).get();
                if (!SnoozeAlarm.validate(this._connectionRetryDelay, this, ServiceMessages.CONNECTION_RETRY_DELAY_TEXT)) {
                    return false;
                }
                SOMAlerter.this.getThisLogger().debug(ServiceMessages.CONNECTION_RETRY_DELAY, this._connectionRetryDelay);
            }
            return true;
        }

        void tearDown() {
            SOMPublisher publisher;
            this.close();
            SOMSubscriber subscriber = this._subscriber;
            if (subscriber != null) {
                this._subscriber = null;
                subscriber.tearDown();
            }
            if ((publisher = this._publisher) != null) {
                this._publisher = null;
                publisher.tearDown();
            }
        }
    }
}

