/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.som;

import java.net.URI;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.tool.Require;
import org.rvpf.som.SOMServerImpl;

public interface SOMEndPoint {
    public void close();

    @Nonnull
    @CheckReturnValue
    public Optional<SessionException> getException();

    @Nonnull
    @CheckReturnValue
    public String getSOMName();

    @Nonnull
    @CheckReturnValue
    public Optional<? extends SOMServerImpl> getServer();

    @Nonnull
    @CheckReturnValue
    public Optional<URI> getServerURI();

    @CheckReturnValue
    public boolean isClosed();

    @CheckReturnValue
    public boolean isOpen();

    @CheckReturnValue
    public boolean isRemote();

    @CheckReturnValue
    public boolean isServer();

    @CheckReturnValue
    public boolean open();

    public void tearDown();

    public static abstract class Abstract
    implements SOMEndPoint {
        private SessionException _exception;

        @Override
        public Optional<SessionException> getException() {
            return Optional.ofNullable(this._exception);
        }

        protected void clearException() {
            this._exception = null;
        }

        protected void setException(@Nonnull SessionException exception) {
            this._exception = Require.notNull(exception);
        }
    }
}

