/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.som;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.som.QueueProxy;
import org.rvpf.base.som.ReceiverActiveException;
import org.rvpf.base.som.TopicProxy;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.SessionFactoryImpl;
import org.rvpf.service.rmi.SessionSecurityContext;
import org.rvpf.service.som.SOMEndPoint;
import org.rvpf.service.som.SOMPublisher;
import org.rvpf.service.som.SOMReceiver;
import org.rvpf.service.som.SOMSender;
import org.rvpf.service.som.SOMSubscriber;
import org.rvpf.som.queue.QueueServerImpl;
import org.rvpf.som.topic.TopicServerImpl;

public final class SOMFactory {
    public static final String PRIVATE_PROPERTY = "private";
    public static final String SERVER_PROPERTY = "server";
    static final Logger _LOGGER = Logger.getInstance(SOMFactory.class);
    private final Config _config;

    public SOMFactory(@Nonnull Config config) {
        this._config = config;
    }

    @CheckReturnValue
    public static boolean isPrivate(@Nonnull KeyedGroups somProperties) {
        return somProperties.getBoolean(PRIVATE_PROPERTY);
    }

    @CheckReturnValue
    public static boolean isServer(@Nonnull KeyedGroups somProperties) {
        return somProperties.getBoolean(SERVER_PROPERTY) || SOMFactory.isPrivate(somProperties);
    }

    @Nonnull
    @CheckReturnValue
    public Queue createQueue(@Nonnull KeyedGroups queueProperties) {
        return new Queue(queueProperties);
    }

    @Nonnull
    @CheckReturnValue
    public Topic createTopic(@Nonnull KeyedGroups topicProperties) {
        return new Topic(topicProperties);
    }

    String _clientName() {
        return this._config.getServiceName();
    }

    KeyedGroups _configProperties() {
        return this._config.getProperties();
    }

    @Nullable
    @CheckReturnValue
    QueueServerImpl _createQueueServer(@Nonnull KeyedGroups queueProperties) {
        SessionSecurityContext securityContext;
        if (SOMFactory.isPrivate(queueProperties)) {
            securityContext = null;
        } else {
            securityContext = SessionFactoryImpl.createSecurityContext(this._config.getProperties(), queueProperties.getGroup("security"), _LOGGER);
            if (securityContext == null) {
                return null;
            }
        }
        QueueServerImpl queueServer = new QueueServerImpl(Optional.ofNullable(securityContext));
        if (!queueServer.setUp(this._config, queueProperties)) {
            queueServer.tearDown();
            return null;
        }
        return queueServer;
    }

    @Nullable
    @CheckReturnValue
    TopicServerImpl _createTopicServer(@Nonnull KeyedGroups topicProperties) {
        SessionSecurityContext securityContext;
        if (SOMFactory.isPrivate(topicProperties)) {
            securityContext = null;
        } else {
            securityContext = SessionFactoryImpl.createSecurityContext(this._config.getProperties(), topicProperties.getGroup("security"), _LOGGER);
            if (securityContext == null) {
                return null;
            }
        }
        TopicServerImpl topicServer = new TopicServerImpl(Optional.ofNullable(securityContext));
        if (!topicServer.setUp(this._config, topicProperties)) {
            topicServer.tearDown();
            return null;
        }
        return topicServer;
    }

    public final class Topic {
        private final KeyedGroups _topicProperties;
        private final TopicServerImpl _topicServer;

        Topic(KeyedGroups topicProperties) {
            if (SOMFactory.isServer(topicProperties)) {
                this._topicServer = SOMFactory.this._createTopicServer(topicProperties);
                this._topicProperties = this._topicServer != null ? topicProperties : null;
            } else {
                this._topicServer = null;
                this._topicProperties = topicProperties;
            }
        }

        @Nullable
        @CheckReturnValue
        public SOMPublisher createPublisher(boolean autoconnect) {
            TopicProxy.Publisher clientPublisher;
            if (!this.isUsable()) {
                return null;
            }
            SOMEndPoint.Abstract publisher = this._topicServer != null ? new SOMPublisher.Server(this._topicServer.createPublisherWrapper()) : ((clientPublisher = TopicProxy.Publisher.newBuilder().prepare(SOMFactory.this._configProperties(), this._topicProperties, SOMFactory.this._clientName(), _LOGGER).setAutoconnect(autoconnect).build()) != null ? new SOMPublisher.Client(clientPublisher) : null);
            return publisher;
        }

        @Nullable
        @CheckReturnValue
        public SOMSubscriber createSubscriber(boolean autoconnect) {
            TopicProxy.Subscriber clientSubscriber;
            if (!this.isUsable()) {
                return null;
            }
            SOMEndPoint.Abstract subscriber = this._topicServer != null ? new SOMSubscriber.Server(this._topicServer.createSubscriberWrapper()) : ((clientSubscriber = TopicProxy.Subscriber.newBuilder().prepare(SOMFactory.this._configProperties(), this._topicProperties, SOMFactory.this._clientName(), _LOGGER).setAutoconnect(autoconnect).build()) != null ? new SOMSubscriber.Client(clientSubscriber) : null);
            return subscriber;
        }

        @CheckReturnValue
        public boolean isUsable() {
            return this._topicProperties != null;
        }
    }

    public final class Queue {
        private final KeyedGroups _queueProperties;
        private final QueueServerImpl _queueServer;

        Queue(KeyedGroups queueProperties) {
            if (SOMFactory.isServer(queueProperties)) {
                this._queueServer = SOMFactory.this._createQueueServer(queueProperties);
                this._queueProperties = this._queueServer != null ? queueProperties : null;
            } else {
                this._queueServer = null;
                this._queueProperties = queueProperties;
            }
        }

        @Nullable
        @CheckReturnValue
        public SOMReceiver createReceiver(boolean autoconnect) {
            SOMEndPoint.Abstract receiver;
            if (!this.isUsable()) {
                return null;
            }
            if (this._queueServer != null) {
                try {
                    receiver = new SOMReceiver.Server(this._queueServer.createReceiverWrapper());
                }
                catch (ReceiverActiveException exception) {
                    _LOGGER.error(ServiceMessages.RECEIVER_ACTIVE, this._queueServer.getName());
                    return null;
                }
            } else {
                QueueProxy.Receiver clientReceiver = QueueProxy.Receiver.newBuilder().prepare(SOMFactory.this._configProperties(), this._queueProperties, SOMFactory.this._clientName(), _LOGGER).setAutoconnect(autoconnect).build();
                receiver = clientReceiver != null ? new SOMReceiver.Client(clientReceiver) : null;
            }
            return receiver;
        }

        @Nullable
        @CheckReturnValue
        public SOMSender createSender(boolean autoconnect) {
            QueueProxy.Sender clientSender;
            if (!this.isUsable()) {
                return null;
            }
            SOMEndPoint.Abstract sender = this._queueServer != null ? new SOMSender.Server(this._queueServer.createSenderWrapper()) : ((clientSender = QueueProxy.Sender.newBuilder().prepare(SOMFactory.this._configProperties(), this._queueProperties, SOMFactory.this._clientName(), _LOGGER).setAutoconnect(autoconnect).build()) != null ? new SOMSender.Client(clientSender) : null);
            return sender;
        }

        @CheckReturnValue
        public boolean isUsable() {
            return this._queueProperties != null;
        }
    }

    public static final class Properties
    extends KeyedGroups {
        private static final long serialVersionUID = 1L;

        public Properties() {
            super(ServiceMessages.PROPERTIES_TYPE.toString(), Optional.empty());
        }

        private Properties(Properties other) {
            super(other);
        }

        @Override
        public Properties copy() {
            return new Properties(this);
        }

        @Override
        public Properties freeze() {
            super.freeze();
            return this;
        }
    }
}

