/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.som;

import java.io.Serializable;
import java.net.URI;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.SessionConnectFailedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.som.TopicInfo;
import org.rvpf.base.som.TopicProxy;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.som.SOMEndPoint;
import org.rvpf.som.SOMServerImpl;
import org.rvpf.som.topic.PublisherWrapper;
import org.rvpf.som.topic.TopicServerImpl;

public interface SOMPublisher
extends SOMEndPoint {
    @Nonnull
    @CheckReturnValue
    public Optional<TopicInfo> getInfo();

    @CheckReturnValue
    public boolean send(@Nonnull Serializable[] var1);

    public static final class Server
    extends SOMEndPoint.Abstract
    implements SOMPublisher {
        private final PublisherWrapper _publisher;

        Server(@Nonnull PublisherWrapper publisher) {
            this._publisher = publisher;
        }

        @Override
        public void close() {
            this._publisher.close();
            this._publisher.closeServer();
        }

        @Override
        public Optional<TopicInfo> getInfo() {
            return Optional.of(this._publisher.getInfo());
        }

        @Override
        public String getSOMName() {
            return this._publisher.getServerName();
        }

        public Optional<TopicServerImpl> getServer() {
            return Optional.of(this._publisher.getTopicServer());
        }

        @Override
        public Optional<URI> getServerURI() {
            return Optional.empty();
        }

        @Override
        public boolean isClosed() {
            return this._publisher.isServerClosed();
        }

        @Override
        public boolean isOpen() {
            return !this._publisher.isServerClosed();
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public boolean isServer() {
            return true;
        }

        @Override
        public boolean open() {
            return true;
        }

        @Override
        public boolean send(Serializable[] messages) {
            this.clearException();
            try {
                this._publisher.send(messages);
            }
            catch (ServiceClosedException exception) {
                this.setException(exception);
                return false;
            }
            return true;
        }

        @Override
        public void tearDown() {
            this.close();
            this._publisher.tearDownServer();
        }

        public String toString() {
            return this._publisher.toString();
        }
    }

    public static final class Client
    extends SOMEndPoint.Abstract
    implements SOMPublisher {
        private final TopicProxy.Publisher _publisher;

        Client(@Nonnull TopicProxy.Publisher publisher) {
            this._publisher = publisher;
        }

        @Override
        public void close() {
            this._publisher.disconnect();
        }

        @Override
        public Optional<TopicInfo> getInfo() {
            this.clearException();
            try {
                return Optional.of(this._publisher.getInfo());
            }
            catch (SessionConnectFailedException exception) {
                this.setException(exception);
                Logger.getInstance(this.getClass()).trace(ServiceMessages.CONNECTION_FAILED, this._publisher.getServerName(), exception.getMessage());
                return Optional.empty();
            }
        }

        @Override
        public String getSOMName() {
            return this._publisher.getSOMName();
        }

        public Optional<SOMServerImpl> getServer() {
            return Optional.empty();
        }

        @Override
        public Optional<URI> getServerURI() {
            return Optional.of(this._publisher.getContext().getServerURI());
        }

        @Override
        public boolean isClosed() {
            return this._publisher.isClosed();
        }

        @Override
        public boolean isOpen() {
            return this._publisher.isConnected();
        }

        @Override
        public boolean isRemote() {
            return this._publisher.isRemote();
        }

        @Override
        public boolean isServer() {
            return false;
        }

        @Override
        public boolean open() {
            this.clearException();
            try {
                this._publisher.connect();
            }
            catch (SessionConnectFailedException exception) {
                this.setException(exception);
                Logger.getInstance(this.getClass()).trace(ServiceMessages.CONNECTION_FAILED, this._publisher.getServerName(), exception.getMessage());
                return false;
            }
            return true;
        }

        @Override
        public boolean send(Serializable[] messages) {
            this.clearException();
            try {
                this._publisher.send(messages);
            }
            catch (SessionConnectFailedException exception) {
                this.setException(exception);
                return false;
            }
            catch (SessionException exception) {
                this.setException(exception);
                Exception exceptionCause = (Exception)exception.getCause();
                if (!(exceptionCause instanceof InterruptedException)) {
                    Logger.getInstance(this.getClass()).warn(ServiceMessages.PUBLISH_FAILED, exceptionCause != null ? exceptionCause : exception);
                }
                return false;
            }
            return true;
        }

        @Override
        public void tearDown() {
            this._publisher.tearDown();
        }

        public String toString() {
            return this._publisher.getServerName();
        }
    }
}

