/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.som;

import java.io.Serializable;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.SessionConnectFailedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.som.QueueInfo;
import org.rvpf.base.som.QueueProxy;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.som.SOMEndPoint;
import org.rvpf.som.SOMServerImpl;
import org.rvpf.som.queue.QueueServerImpl;
import org.rvpf.som.queue.ReceiverWrapper;

public interface SOMReceiver
extends SOMEndPoint {
    @CheckReturnValue
    public boolean commit();

    @Nonnull
    @CheckReturnValue
    public Optional<QueueInfo> getInfo();

    @CheckReturnValue
    public long purge();

    @Nullable
    @CheckReturnValue
    public Serializable[] receive(int var1, long var2);

    @CheckReturnValue
    public boolean rollback();

    public static final class Server
    extends SOMEndPoint.Abstract
    implements SOMReceiver {
        private final ReceiverWrapper _receiver;

        Server(@Nonnull ReceiverWrapper receiver) {
            this._receiver = receiver;
        }

        @Override
        public void close() {
            this._receiver.close();
            this._receiver.closeServer();
        }

        @Override
        public boolean commit() {
            this.clearException();
            try {
                this._receiver.commit();
            }
            catch (ServiceClosedException exception) {
                this.setException(exception);
                Logger.getInstance(this.getClass()).info(ServiceMessages.SERVICE_CLOSED, new Object[0]);
                return false;
            }
            return true;
        }

        @Override
        public Optional<QueueInfo> getInfo() {
            return Optional.of(this._receiver.getInfo());
        }

        @Override
        public String getSOMName() {
            return this._receiver.getServerName();
        }

        public Optional<QueueServerImpl> getServer() {
            return Optional.of(this._receiver.getQueueServer());
        }

        @Override
        public Optional<URI> getServerURI() {
            return Optional.empty();
        }

        @Override
        public boolean isClosed() {
            return this._receiver.isServerClosed();
        }

        @Override
        public boolean isOpen() {
            return !this._receiver.isServerClosed();
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public boolean isServer() {
            return true;
        }

        @Override
        public boolean open() {
            return true;
        }

        @Override
        public long purge() {
            this.clearException();
            try {
                return this._receiver.purge();
            }
            catch (ServiceClosedException exception) {
                this.setException(exception);
                Logger.getInstance(this.getClass()).info(ServiceMessages.SERVICE_CLOSED, new Object[0]);
                return 0L;
            }
        }

        @Override
        public Serializable[] receive(int limit, long timeout) {
            this.clearException();
            try {
                return this._receiver.receive(limit, timeout);
            }
            catch (ServiceClosedException exception) {
                this.setException(exception);
                return null;
            }
        }

        @Override
        public boolean rollback() {
            this.clearException();
            try {
                this._receiver.rollback();
            }
            catch (ServiceClosedException exception) {
                this.setException(exception);
                Logger.getInstance(this.getClass()).info(ServiceMessages.SERVICE_CLOSED, new Object[0]);
                return false;
            }
            return true;
        }

        @Override
        public void tearDown() {
            this.close();
            this._receiver.tearDownServer();
        }

        public String toString() {
            return this._receiver.toString();
        }
    }

    public static final class Client
    extends SOMEndPoint.Abstract
    implements SOMReceiver {
        private static final Logger _LOGGER = Logger.getInstance(Client.class);
        private final QueueProxy.Receiver _receiver;

        Client(@Nonnull QueueProxy.Receiver receiver) {
            this._receiver = receiver;
        }

        @Override
        public void close() {
            this._receiver.disconnect();
        }

        @Override
        public boolean commit() {
            this.clearException();
            try {
                this._receiver.commit();
            }
            catch (SessionException exception) {
                this.setException(exception);
                _LOGGER.warn(ServiceMessages.COMMIT_FAILED, exception.getMessage());
                return false;
            }
            return true;
        }

        @Override
        public Optional<QueueInfo> getInfo() {
            this.clearException();
            try {
                return Optional.of(this._receiver.getInfo());
            }
            catch (SessionConnectFailedException exception) {
                this.setException(exception);
                _LOGGER.trace(ServiceMessages.CONNECTION_FAILED, this._receiver.getServerName(), exception.getMessage());
                return Optional.empty();
            }
        }

        @Override
        public String getSOMName() {
            return this._receiver.getSOMName();
        }

        public Optional<SOMServerImpl> getServer() {
            return Optional.empty();
        }

        @Override
        public Optional<URI> getServerURI() {
            return Optional.of(this._receiver.getContext().getServerURI());
        }

        @Override
        public boolean isClosed() {
            return this._receiver.isClosed();
        }

        @Override
        public boolean isOpen() {
            return this._receiver.isConnected();
        }

        @Override
        public boolean isRemote() {
            return this._receiver.isRemote();
        }

        @Override
        public boolean isServer() {
            return false;
        }

        @Override
        public boolean open() {
            this.clearException();
            try {
                this._receiver.connect();
            }
            catch (SessionConnectFailedException exception) {
                this.setException(exception);
                _LOGGER.trace(ServiceMessages.CONNECTION_FAILED, this._receiver.getServerName(), exception.getMessage());
                return false;
            }
            return true;
        }

        @Override
        public long purge() {
            this.clearException();
            try {
                return this._receiver.purge();
            }
            catch (SessionException exception) {
                this.setException(exception);
                throw new RuntimeException(exception);
            }
        }

        @Override
        public Serializable[] receive(int limit, long timeout) {
            this.clearException();
            try {
                return this._receiver.receive(limit, timeout);
            }
            catch (ServiceClosedException | SessionConnectFailedException exception) {
                this.setException(exception);
                return null;
            }
            catch (SessionException exception) {
                this.setException(exception);
                Exception exceptionCause = (Exception)exception.getCause();
                _LOGGER.warn(ServiceMessages.RECEIVE_FAILED, exceptionCause != null ? exceptionCause : exception);
                return null;
            }
        }

        @Override
        public boolean rollback() {
            this.clearException();
            try {
                this._receiver.rollback();
            }
            catch (SessionException exception) {
                this.setException(exception);
                Exception exceptionCause = (Exception)exception.getCause();
                if (exceptionCause instanceof RemoteException) {
                    _LOGGER.warn(ServiceMessages.ROLLBACK_FAILED, exceptionCause.getMessage());
                }
                return false;
            }
            return true;
        }

        @Override
        public void tearDown() {
            this._receiver.tearDown();
        }

        public String toString() {
            return this._receiver.getServerName();
        }
    }
}

