/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.som;

import java.io.Serializable;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.SessionConnectFailedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.som.QueueInfo;
import org.rvpf.base.som.QueueProxy;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.som.SOMEndPoint;
import org.rvpf.som.SOMServerImpl;
import org.rvpf.som.queue.QueueServerImpl;
import org.rvpf.som.queue.SenderWrapper;

public interface SOMSender
extends SOMEndPoint {
    @CheckReturnValue
    public boolean commit();

    @Nonnull
    @CheckReturnValue
    public Optional<QueueInfo> getInfo();

    @CheckReturnValue
    public boolean rollback();

    @CheckReturnValue
    public boolean send(@Nonnull Serializable[] var1, boolean var2);

    public static final class Server
    extends SOMEndPoint.Abstract
    implements SOMSender {
        private final SenderWrapper _sender;

        Server(@Nonnull SenderWrapper sender) {
            this._sender = sender;
        }

        @Override
        public void close() {
            this._sender.close();
            this._sender.closeServer();
        }

        @Override
        public boolean commit() {
            this.clearException();
            try {
                this._sender.commit();
            }
            catch (ServiceClosedException exception) {
                this.setException(exception);
                return false;
            }
            return true;
        }

        @Override
        public Optional<QueueInfo> getInfo() {
            return Optional.of(this._sender.getInfo());
        }

        @Override
        public String getSOMName() {
            return this._sender.getServerName();
        }

        public Optional<QueueServerImpl> getServer() {
            return Optional.of(this._sender.getQueueServer());
        }

        @Override
        public Optional<URI> getServerURI() {
            return Optional.empty();
        }

        @Override
        public boolean isClosed() {
            return this._sender.isServerClosed();
        }

        @Override
        public boolean isOpen() {
            return !this._sender.isServerClosed();
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public boolean isServer() {
            return true;
        }

        @Override
        public boolean open() {
            return true;
        }

        @Override
        public boolean rollback() {
            this.clearException();
            try {
                this._sender.rollback();
            }
            catch (ServiceClosedException exception) {
                this.setException(exception);
                return false;
            }
            return true;
        }

        @Override
        public boolean send(Serializable[] messages, boolean commit) {
            this.clearException();
            try {
                this._sender.send(messages, commit);
            }
            catch (ServiceClosedException exception) {
                this.setException(exception);
                return false;
            }
            return true;
        }

        @Override
        public void tearDown() {
            this.close();
            this._sender.tearDownServer();
        }

        public String toString() {
            return this._sender.toString();
        }
    }

    public static final class Client
    extends SOMEndPoint.Abstract
    implements SOMSender {
        private static final Logger _LOGGER = Logger.getInstance(Client.class);
        private final QueueProxy.Sender _sender;

        Client(@Nonnull QueueProxy.Sender sender) {
            this._sender = sender;
        }

        @Override
        public void close() {
            this._sender.disconnect();
        }

        @Override
        public boolean commit() {
            this.clearException();
            try {
                this._sender.commit();
            }
            catch (SessionException exception) {
                this.setException(exception);
                _LOGGER.warn(ServiceMessages.COMMIT_FAILED, exception.toString());
                return false;
            }
            return true;
        }

        @Override
        public Optional<QueueInfo> getInfo() {
            this.clearException();
            try {
                return Optional.of(this._sender.getInfo());
            }
            catch (SessionConnectFailedException exception) {
                this.setException(exception);
                _LOGGER.trace(ServiceMessages.CONNECTION_FAILED, this._sender.getServerName(), exception.getMessage());
                return Optional.empty();
            }
        }

        @Override
        public String getSOMName() {
            return this._sender.getSOMName();
        }

        public Optional<SOMServerImpl> getServer() {
            return Optional.empty();
        }

        @Override
        public Optional<URI> getServerURI() {
            return Optional.of(this._sender.getContext().getServerURI());
        }

        @Override
        public boolean isClosed() {
            return this._sender.isClosed();
        }

        @Override
        public boolean isOpen() {
            return this._sender.isConnected();
        }

        @Override
        public boolean isRemote() {
            return this._sender.isRemote();
        }

        @Override
        public boolean isServer() {
            return false;
        }

        @Override
        public boolean open() {
            this.clearException();
            try {
                this._sender.connect();
            }
            catch (SessionConnectFailedException exception) {
                this.setException(exception);
                _LOGGER.trace(ServiceMessages.CONNECTION_FAILED, this._sender.getServerName(), exception.getMessage());
                return false;
            }
            return true;
        }

        @Override
        public boolean rollback() {
            this.clearException();
            try {
                this._sender.rollback();
            }
            catch (SessionException exception) {
                this.setException(exception);
                Exception exceptionCause = (Exception)exception.getCause();
                if (exceptionCause instanceof RemoteException) {
                    _LOGGER.warn(ServiceMessages.ROLLBACK_FAILED, exceptionCause.getMessage());
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean send(Serializable[] messages, boolean commit) {
            this.clearException();
            try {
                this._sender.send(messages, commit);
            }
            catch (SessionConnectFailedException exception) {
                this.setException(exception);
                return false;
            }
            catch (SessionException exception) {
                this.setException(exception);
                Exception exceptionCause = (Exception)exception.getCause();
                if (exceptionCause instanceof InterruptedException) {
                    this.setException(new ServiceClosedException(exceptionCause));
                } else {
                    _LOGGER.warn(ServiceMessages.SEND_FAILED, exceptionCause != null ? exceptionCause : exception);
                }
                return false;
            }
            return true;
        }

        @Override
        public void tearDown() {
            this._sender.tearDown();
        }

        public String toString() {
            return this._sender.getServerName();
        }
    }
}

