/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.som;

import java.io.Serializable;
import java.net.URI;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.SessionConnectFailedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.som.TopicInfo;
import org.rvpf.base.som.TopicProxy;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.som.SOMEndPoint;
import org.rvpf.som.SOMServerImpl;
import org.rvpf.som.topic.SubscriberWrapper;
import org.rvpf.som.topic.TopicServerImpl;

public interface SOMSubscriber
extends SOMEndPoint {
    @Nonnull
    @CheckReturnValue
    public Optional<TopicInfo> getInfo();

    @Nullable
    @CheckReturnValue
    public Serializable[] receive(int var1, long var2);

    public static final class Server
    extends SOMEndPoint.Abstract
    implements SOMSubscriber {
        private final SubscriberWrapper _subscriber;

        Server(@Nonnull SubscriberWrapper subscriber) {
            this._subscriber = subscriber;
        }

        @Override
        public void close() {
            this._subscriber.close();
            this._subscriber.closeServer();
        }

        @Override
        public Optional<TopicInfo> getInfo() {
            return Optional.of(this._subscriber.getInfo());
        }

        @Override
        public String getSOMName() {
            return this._subscriber.getServerName();
        }

        public Optional<TopicServerImpl> getServer() {
            return Optional.of(this._subscriber.getTopicServer());
        }

        @Override
        public Optional<URI> getServerURI() {
            return Optional.empty();
        }

        @Override
        public boolean isClosed() {
            return this._subscriber.isServerClosed();
        }

        @Override
        public boolean isOpen() {
            return !this._subscriber.isServerClosed();
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public boolean isServer() {
            return true;
        }

        @Override
        public boolean open() {
            return true;
        }

        @Override
        public Serializable[] receive(int limit, long timeout) {
            this.clearException();
            try {
                return this._subscriber.receive(limit, timeout);
            }
            catch (ServiceClosedException exception) {
                this.setException(exception);
                return null;
            }
        }

        @Override
        public void tearDown() {
            this.close();
            this._subscriber.tearDownServer();
        }

        public String toString() {
            return this._subscriber.toString();
        }
    }

    public static final class Client
    extends SOMEndPoint.Abstract
    implements SOMSubscriber {
        private final TopicProxy.Subscriber _subscriber;

        Client(@Nonnull TopicProxy.Subscriber subscriber) {
            this._subscriber = subscriber;
        }

        @Override
        public void close() {
            this._subscriber.disconnect();
        }

        @Override
        public Optional<TopicInfo> getInfo() {
            this.clearException();
            try {
                return Optional.of(this._subscriber.getInfo());
            }
            catch (SessionConnectFailedException exception) {
                this.setException(exception);
                Logger.getInstance(this.getClass()).trace(ServiceMessages.CONNECTION_FAILED, this._subscriber.getServerName(), exception.getMessage());
                return Optional.empty();
            }
        }

        @Override
        public String getSOMName() {
            return this._subscriber.getSOMName();
        }

        public Optional<SOMServerImpl> getServer() {
            return Optional.empty();
        }

        @Override
        public Optional<URI> getServerURI() {
            return Optional.of(this._subscriber.getContext().getServerURI());
        }

        @Override
        public boolean isClosed() {
            return this._subscriber.isClosed();
        }

        @Override
        public boolean isOpen() {
            return this._subscriber.isConnected();
        }

        @Override
        public boolean isRemote() {
            return this._subscriber.isRemote();
        }

        @Override
        public boolean isServer() {
            return false;
        }

        @Override
        public boolean open() {
            this.clearException();
            try {
                this._subscriber.connect();
            }
            catch (SessionConnectFailedException exception) {
                this.setException(exception);
                Logger.getInstance(this.getClass()).trace(ServiceMessages.CONNECTION_FAILED, this._subscriber.getServerName(), exception.getMessage());
                return false;
            }
            return true;
        }

        @Override
        public Serializable[] receive(int limit, long timeout) {
            this.clearException();
            try {
                return this._subscriber.receive(limit, timeout);
            }
            catch (ServiceClosedException | SessionConnectFailedException exception) {
                this.setException(exception);
                return null;
            }
            catch (SessionException exception) {
                this.setException(exception);
                Exception exceptionCause = (Exception)exception.getCause();
                Logger.getInstance(this.getClass()).warn(ServiceMessages.RECEIVE_FAILED, exceptionCause != null ? exceptionCause : exception);
                return null;
            }
        }

        @Override
        public void tearDown() {
            this._subscriber.tearDown();
        }

        public String toString() {
            return this._subscriber.getServerName();
        }
    }
}

