/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.app.ServiceAppImpl;
import org.rvpf.service.rmi.SessionSecurityContext;
import org.rvpf.som.SOMServerImpl;
import org.rvpf.som.queue.QueueServerImpl;
import org.rvpf.som.topic.TopicServerImpl;

public final class SOMContainerServiceAppImpl
extends ServiceAppImpl {
    public static final String SOM_QUEUE_PROPERTIES = "som.queue";
    public static final String SOM_TOPIC_PROPERTIES = "som.topic";
    private final Map<URI, SOMServerImpl> _somServers = new HashMap<URI, SOMServerImpl>();

    @Override
    public boolean setUp(Service service) {
        if (!super.setUp(service)) {
            return false;
        }
        SessionSecurityContext securityContext = SOMServerImpl.createSecurityContext(service.getConfig().getProperties(), KeyedGroups.MISSING_KEYED_GROUP, this.getThisLogger());
        if (securityContext == null) {
            return false;
        }
        return this._setUpQueues() && this._setUpTopics();
    }

    @Override
    public void tearDown() {
        for (SOMServerImpl somServer : this._somServers.values()) {
            somServer.tearDown();
        }
        this._somServers.clear();
        super.tearDown();
    }

    private boolean _setUpQueues() {
        KeyedGroups[] queues;
        Config config = this.getService().getConfig();
        for (KeyedGroups queue : queues = config.getPropertiesGroups(SOM_QUEUE_PROPERTIES)) {
            SessionSecurityContext securityContext = SOMServerImpl.createSecurityContext(config.getProperties(), queue.getGroup("security"), this.getThisLogger());
            if (securityContext == null) {
                return false;
            }
            if (this._setUpSOMServer(new QueueServerImpl(Optional.of(securityContext)), queue)) continue;
            return false;
        }
        return true;
    }

    private boolean _setUpSOMServer(SOMServerImpl somServer, KeyedGroups somProperties) {
        if (!somServer.setUp(this.getService().getConfig(), somProperties)) {
            return false;
        }
        URI serverURI = somServer.getURI();
        if (this._somServers.containsKey(serverURI)) {
            this.getThisLogger().error(ServiceMessages.DUPLICATE_BIND_NAME, serverURI);
            somServer.tearDown();
            return false;
        }
        this._somServers.put(serverURI, somServer);
        this.getThisLogger().debug(ServiceMessages.SOM_MODULE_LOADED, somServer.getName(), somServer.getClass().getName());
        return true;
    }

    private boolean _setUpTopics() {
        KeyedGroups[] topics;
        Config config = this.getService().getConfig();
        for (KeyedGroups topic : topics = config.getPropertiesGroups(SOM_TOPIC_PROPERTIES)) {
            SessionSecurityContext securityContext = SOMServerImpl.createSecurityContext(config.getProperties(), topic.getGroup("security"), this.getThisLogger());
            if (securityContext == null) {
                return false;
            }
            if (this._setUpSOMServer(new TopicServerImpl(Optional.of(securityContext)), topic)) continue;
            return false;
        }
        return true;
    }
}

