/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som;

import java.net.URI;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.rmi.RegistryEntry;
import org.rvpf.base.som.SOMServer;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.ServiceRegistry;
import org.rvpf.service.rmi.SessionFactoryImpl;
import org.rvpf.service.rmi.SessionImpl;
import org.rvpf.service.rmi.SessionSecurityContext;

public abstract class SOMServerImpl
extends SessionFactoryImpl
implements SOMServer {
    public static final ElapsedTime DEFAULT_KEEP_ALIVE = ElapsedTime.fromRaw(5L * ElapsedTime.MINUTE.toRaw());
    public static final String DEFAULT_KEEP_ALIVE_PROPERTY = "service.som.keep.alive";
    public static final String KEEP_ALIVE_PROPERTY = "keep.alive";
    public static final String READ_ROLE = "Read";
    public static final String READ_ROLE_PROPERTY = "role.read";
    public static final String WRITE_ROLE = "Write";
    public static final String WRITE_ROLE_PROPERTY = "role.write";
    private ElapsedTime _keepAlive;
    private final Object _mutex = new Object();
    private String _name;
    private String[] _readRoles;
    private RegistryEntry _registryEntry;
    private String _serverName;
    private String[] _writeRoles;

    protected SOMServerImpl(@Nonnull Optional<SessionSecurityContext> securityContext) {
        super(securityContext);
    }

    @Override
    public ElapsedTime getKeepAlive() {
        return this._keepAlive;
    }

    @Override
    public final String getName() {
        return Require.notNull(this._name);
    }

    @Nonnull
    @CheckReturnValue
    public URI getURI() {
        return Require.notNull(this._registryEntry.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSession(SessionImpl session) {
        if (!super.removeSession(session)) {
            return false;
        }
        Object object = this._mutex;
        synchronized (object) {
            this._mutex.notifyAll();
        }
        return true;
    }

    @Override
    public final boolean setUp(Config config) {
        throw new UnsupportedOperationException();
    }

    @CheckReturnValue
    public abstract boolean setUp(@Nonnull Config var1, @Nonnull KeyedGroups var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean stop(int timeout) {
        Object object = this._mutex;
        synchronized (object) {
            long startMillis;
            long l = startMillis = timeout > 0 ? System.currentTimeMillis() : 0L;
            while (this.getSessionCount() > 0) {
                try {
                    if (timeout == 0) {
                        return false;
                    }
                    if (timeout > 0) {
                        long elapsedMillis = System.currentTimeMillis() - startMillis;
                        if (elapsedMillis < 0L || elapsedMillis >= (long)timeout) {
                            return false;
                        }
                        this._mutex.wait((long)timeout - elapsedMillis);
                        continue;
                    }
                    this._mutex.wait();
                }
                catch (InterruptedException exception) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            this.close();
        }
        return true;
    }

    @Override
    public void tearDown() {
        String serverName = this._serverName;
        if (serverName != null) {
            this._serverName = null;
            ServiceRegistry.getInstance().unregister(serverName, this.getThisLogger());
        }
        super.tearDown();
    }

    public final String toString() {
        return this.getName() + " " + super.toString();
    }

    @CheckReturnValue
    protected boolean bind() {
        this._serverName = ServiceRegistry.getInstance().registerServer(this, this._registryEntry.getURI(), this.getThisLogger());
        return this._serverName != null;
    }

    @Override
    protected void fillRolesMap() {
        if (this._readRoles != null) {
            this.mapRoles(READ_ROLE, this._readRoles);
        }
        if (this._writeRoles != null) {
            this.mapRoles(WRITE_ROLE, this._writeRoles);
        }
    }

    @CheckReturnValue
    protected boolean setUp(@Nonnull Config config, @Nonnull KeyedGroups somProperties, @Nonnull String defaultBindingPrefix) {
        String name;
        if (this.hasSecurityContext() && !super.setUp(config)) {
            return false;
        }
        if (this.hasSecurityContext()) {
            this._registryEntry = RegistryEntry.newBuilder().setBinding(somProperties.getString("binding")).setName(somProperties.getString("name")).setDefaultPrefix(defaultBindingPrefix).setDefaultRegistryAddress(ServiceRegistry.getRegistryAddress()).setDefaultRegistryPort(ServiceRegistry.getRegistryPort()).build();
            if (this._registryEntry == null) {
                return false;
            }
            name = this._registryEntry.getName();
            this._readRoles = somProperties.getStrings(READ_ROLE_PROPERTY);
            this._writeRoles = somProperties.getStrings(WRITE_ROLE_PROPERTY);
            Optional<ElapsedTime> defaultKeepAlive = this.getConfig().getElapsedValue(DEFAULT_KEEP_ALIVE_PROPERTY, Optional.of(DEFAULT_KEEP_ALIVE), Optional.of(ElapsedTime.EMPTY));
            this._keepAlive = somProperties.getElapsed(KEEP_ALIVE_PROPERTY, defaultKeepAlive, Optional.of(ElapsedTime.EMPTY)).orElse(null);
            this.getThisLogger().debug(ServiceMessages.KEEP_ALIVE, name, this._keepAlive);
        } else {
            name = somProperties.getString("name").orElse(null);
        }
        if (name == null || name.isEmpty()) {
            this.getThisLogger().error(ServiceMessages.MISSING_NAME, new Object[0]);
            return false;
        }
        this._name = name;
        return true;
    }

    @Immutable
    protected static class Descriptor {
        private final String _clientName;
        private final String _modeName;

        public Descriptor(@Nonnull String modeName, @Nonnull String clientName) {
            this._modeName = modeName;
            this._clientName = clientName;
        }

        @Nonnull
        @CheckReturnValue
        public String getClientName() {
            return this._clientName;
        }

        @Nonnull
        @CheckReturnValue
        public String getModeName() {
            return this._modeName;
        }
    }
}

