/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.logger.Message;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.som.SOMSession;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.ExportedSessionImpl;
import org.rvpf.service.rmi.SessionFactory;
import org.rvpf.som.SOMServerImpl;

@ThreadSafe
public abstract class SOMSessionImpl
extends ExportedSessionImpl
implements SOMSession {
    private final long _keepAlive;

    protected SOMSessionImpl(@Nonnull SOMServerImpl sessionFactory, @Nonnull Session.ConnectionMode connectionMode, @Nonnull String clientName) {
        super(clientName, sessionFactory, connectionMode);
        this._keepAlive = sessionFactory.getKeepAlive().toMillis();
    }

    @Override
    public final String toString() {
        SessionFactory sessionFactory = this.getSessionFactory();
        String name = ((SOMServerImpl)sessionFactory).getName();
        return Message.format(ServiceMessages.SOM_SESSION, this.getType(), name, super.toString());
    }

    @CheckReturnValue
    protected long adjustTimeout(long timeout) {
        if (this._keepAlive > 0L && (timeout < 0L || timeout > this._keepAlive)) {
            timeout = this._keepAlive;
        }
        return timeout;
    }

    @Nonnull
    @CheckReturnValue
    protected abstract String getType();
}

