/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.StatsOwner;
import org.rvpf.config.Config;
import org.rvpf.jmx.Agent;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceStats;
import org.rvpf.service.StatsHolder;
import org.rvpf.som.SOMStatsHolder;

public abstract class SOMStats
extends ServiceStats {
    private static final long serialVersionUID = 1L;
    private boolean _registrationEnabled;

    protected SOMStats(@Nonnull StatsOwner statsOwner) {
        super(statsOwner);
        ((SOMStatsHolder)this.getStatsOwner()).setStats(this);
    }

    @Nonnull
    @CheckReturnValue
    public abstract String getObjectType();

    @CheckReturnValue
    public final boolean register(@Nonnull Config config) {
        if (config.hasService()) {
            Service service = config.getService();
            service.addStats(this);
            this._registrationEnabled = service.isJMXRegistrationEnabled();
            if (this._registrationEnabled) {
                return Agent.getInstance().registerStatsHolder((StatsHolder)this.getStatsOwner());
            }
        }
        return true;
    }

    public final void unregister() {
        if (this._registrationEnabled) {
            Agent.getInstance().unregisterStatsHolder((StatsHolder)this.getStatsOwner());
            this._registrationEnabled = false;
        }
    }
}

