/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Message;
import org.rvpf.base.som.QueueInfo;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.xml.streamer.Streamer;
import org.rvpf.service.ServiceMessages;
import org.rvpf.som.queue.FilesReceiver;
import org.rvpf.som.queue.FilesSender;
import org.rvpf.som.queue.Queue;
import org.rvpf.som.queue.QueueEntry;
import org.rvpf.som.queue.QueueReader;
import org.rvpf.som.queue.QueueStats;

@ThreadSafe
public final class FilesQueue
extends Queue.Abstract {
    public static final String BACKUP_PROPERTY = "backup";
    public static final String BACKUP_SUFFIX_PROPERTY = "suffix.backup";
    public static final String BAD_SUFFIX_PROPERTY = "suffix.bad";
    public static final String COMPRESSED_PROPERTY = "compressed";
    public static final String COMPRESSED_SUFFIX_PROPERTY = "compressed.suffix";
    public static final String DATA_SUFFIX_PROPERTY = "suffix.data";
    public static final String DEFAULT_BACKUP_SUFFIX = ".backup";
    public static final String DEFAULT_BAD_SUFFIX = ".bad";
    public static final String DEFAULT_COMPRESSED_SUFFIX = ".gz";
    public static final String DEFAULT_DATA_SUFFIX = ".data";
    public static final String DEFAULT_LOCK_SUFFIX = ".lock";
    public static final String DEFAULT_NEXT_SUFFIX = ".next";
    public static final String DEFAULT_QUEUE_FILE_RETRIES = "1";
    public static final String DEFAULT_QUEUE_FILE_RETRY_DELAY = "60.0";
    public static final String DEFAULT_TRANS_SUFFIX = ".trans";
    public static final String DIRECTORY_PROPERTY = "directory";
    public static final String ENTRY_PREFIX_PROPERTY = "prefix.entry";
    public static final String LOCK_DISABLED_PROPERTY = "lock.disabled";
    public static final String LOCK_SUFFIX_PROPERTY = "suffix.lock";
    public static final String MERGE_LIMIT_PROPERTY = "merge.limit";
    public static final String MERGE_SPLIT_PROPERTY = "merge.split";
    public static final String NEXT_SUFFIX_PROPERTY = "suffix.next";
    public static final String QUEUE_FILE_RETRIES = "rvpf.queue.file.retries";
    public static final String QUEUE_FILE_RETRY_DELAY = "rvpf.queue.file.retry.delay";
    public static final String ROOT_PROPERTY = "root";
    public static final String TRANS_SUFFIX_PROPERTY = "suffix.trans";
    static final String LOCK_PREFIX_PROPERTY = "prefix.lock";
    private static volatile Integer _queueFileRetries;
    private static volatile ElapsedTime _queueFileRetryDelay;
    private boolean _backup;
    private String _backupSuffix;
    private String _badSuffix;
    private boolean _compressed;
    private String _compressedSuffix;
    private String _dataSuffix;
    private File _directory;
    private final NavigableMap<String, QueueEntry> _entries = new TreeMap<String, QueueEntry>();
    private String _entryPrefix;
    private DateTime _entryStamp = DateTime.fromRaw(0L);
    private final QueueInfo _info = new QueueInfo();
    private RandomAccessFile _lockFile;
    private int _mergeLimit;
    private int _mergeSplit;
    private String _nextSuffix;
    private final Object _queueMutex = new Object();
    private final Streamer _streamer;
    private String _transSuffix;

    FilesQueue(@Nonnull String name, @Nonnull QueueStats stats, @Nonnull Streamer streamer) {
        super(name, stats);
        this._streamer = streamer;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getBackupSuffix() {
        return Optional.ofNullable(this._backupSuffix);
    }

    @Nonnull
    @CheckReturnValue
    public String getBadSuffix() {
        return this._badSuffix;
    }

    @Nonnull
    @CheckReturnValue
    public String getDataSuffix() {
        return this._dataSuffix;
    }

    @Nonnull
    @CheckReturnValue
    public File getDirectoryFile() {
        return this._directory;
    }

    @Override
    public QueueInfo getInfo() {
        return this._info;
    }

    @Nonnull
    @CheckReturnValue
    public String getNextSuffix() {
        return this._nextSuffix;
    }

    @Nonnull
    @CheckReturnValue
    public String getTransSuffix() {
        return this._transSuffix;
    }

    public File[] listEntryFiles(@Nonnull String withSuffix) {
        class QueueFileFilter
        implements FileFilter {
            private final String _suffix;

            QueueFileFilter(String suffix) {
                this._suffix = suffix;
            }

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                String name = file.getName();
                if (!name.startsWith(FilesQueue.this.getEntryPrefix()) || !name.endsWith(this._suffix)) {
                    return false;
                }
                if ((name = FilesQueue.this._entryName(name, this._suffix)).length() != 23) {
                    return false;
                }
                try {
                    DateTime.fromString(name);
                }
                catch (IllegalArgumentException exception) {
                    return false;
                }
                return true;
            }
        }
        File[] entryFiles = this._directory.listFiles(new QueueFileFilter(withSuffix));
        return Require.notNull(entryFiles);
    }

    @Override
    public Queue.Receiver newReceiver() {
        FilesReceiver receiver = new FilesReceiver(this);
        this.onNewReceiver(receiver);
        return receiver;
    }

    @Override
    public Queue.Sender newSender() {
        FilesSender sender = new FilesSender(this);
        this.onNewSender(sender);
        return sender;
    }

    @Override
    public boolean setUp(KeyedValues somProperties) {
        if (!super.setUp(somProperties)) {
            return false;
        }
        this._compressed = somProperties.getBoolean(COMPRESSED_PROPERTY);
        if (this._compressed) {
            this._compressedSuffix = somProperties.getString(COMPRESSED_SUFFIX_PROPERTY, Optional.of(DEFAULT_COMPRESSED_SUFFIX)).get();
            this.getThisLogger().debug(ServiceMessages.QUEUE_FILES_COMPRESSED, this.getName());
        }
        this._entryPrefix = somProperties.getString(ENTRY_PREFIX_PROPERTY, Optional.of("")).get();
        this._badSuffix = this._suffix(somProperties, BAD_SUFFIX_PROPERTY, DEFAULT_BAD_SUFFIX);
        this._dataSuffix = this._suffix(somProperties, DATA_SUFFIX_PROPERTY, DEFAULT_DATA_SUFFIX);
        this._transSuffix = this._suffix(somProperties, TRANS_SUFFIX_PROPERTY, DEFAULT_TRANS_SUFFIX);
        this._nextSuffix = somProperties.getString(NEXT_SUFFIX_PROPERTY, Optional.of(DEFAULT_NEXT_SUFFIX)).get();
        this._backup = somProperties.getBoolean(BACKUP_PROPERTY);
        if (this._backup) {
            this._backupSuffix = this._suffix(somProperties, BACKUP_SUFFIX_PROPERTY, DEFAULT_BACKUP_SUFFIX);
            this.getThisLogger().debug(ServiceMessages.QUEUE_BACKUP, this.getName(), this._backupSuffix);
        }
        this._mergeLimit = somProperties.getInt(MERGE_LIMIT_PROPERTY, 0);
        if (this._mergeLimit > 0) {
            this.getThisLogger().debug(ServiceMessages.QUEUE_MERGE_LIMIT, this.getName(), String.valueOf(this._mergeLimit));
            this._mergeSplit = somProperties.getInt(MERGE_SPLIT_PROPERTY, Integer.MAX_VALUE);
            if (this._mergeSplit < Integer.MAX_VALUE) {
                this.getThisLogger().debug(ServiceMessages.QUEUE_MERGE_SPLIT, this.getName(), String.valueOf(this._mergeSplit));
            }
        } else {
            this._mergeSplit = 0;
        }
        Path rootPath = Paths.get(somProperties.getString(ROOT_PROPERTY).get(), new String[0]);
        Path directoryPath = rootPath.resolve(somProperties.getString(DIRECTORY_PROPERTY, Optional.of(this.getName())).get());
        this._directory = directoryPath.toFile();
        this.getThisLogger().debug(ServiceMessages.QUEUE_DIRECTORY, this._directory.getAbsolutePath());
        if (this._directory.mkdirs()) {
            this.getThisLogger().info(ServiceMessages.QUEUE_DIRECTORY_CREATED, this._directory.getAbsolutePath());
        }
        if (!this._directory.isDirectory()) {
            this.getThisLogger().error(ServiceMessages.QUEUE_DIRECTORY_FAILED, this._directory.getAbsolutePath());
            return false;
        }
        if (somProperties.getBoolean(LOCK_DISABLED_PROPERTY)) {
            this._lockFile = null;
            this.getThisLogger().info(ServiceMessages.LOCK_FILE_DISABLED, new Object[0]);
        } else {
            String lockPrefix = somProperties.getString(LOCK_PREFIX_PROPERTY, Optional.of(this._entryPrefix)).get();
            String lockSuffix = somProperties.getString(LOCK_SUFFIX_PROPERTY, Optional.of(DEFAULT_LOCK_SUFFIX)).get();
            File lockFile = new File(this._directory, lockPrefix + this.getName() + lockSuffix);
            try {
                this._lockFile = new RandomAccessFile(lockFile, "rw");
            }
            catch (FileNotFoundException exception) {
                this.getThisLogger().error(ServiceMessages.LOCK_FILE_NOT_FOUND, lockFile);
                return false;
            }
            try {
                if (this._lockFile.getChannel().tryLock() == null) {
                    this.getThisLogger().error(ServiceMessages.LOCK_FILE_LOCK_FAILED, lockFile);
                    return false;
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        if (!this._recover()) {
            return false;
        }
        this.getThisLogger().debug(ServiceMessages.SET_UP_COMPLETED, new Object[0]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() {
        RandomAccessFile lockFile;
        int entriesSize;
        super.tearDown();
        long messageCount = this._info.getMessageCount();
        if (this.getThisLogger().isDebugEnabled()) {
            long filesSize;
            if (messageCount > 0L) {
                this.getThisLogger().debug(ServiceMessages.QUEUE_MESSAGES_LEFT, String.valueOf(messageCount), this.getName());
            }
            if ((filesSize = this._info.getFilesSize()) > 0L) {
                this.getThisLogger().debug(ServiceMessages.QUEUE_MESSAGE_FILES_SIZE, this.getName(), String.valueOf(filesSize));
            }
        }
        Object object = this._queueMutex;
        synchronized (object) {
            entriesSize = this._entries.size();
            this._entries.clear();
            lockFile = this._lockFile;
            this._lockFile = null;
        }
        if (entriesSize > 0) {
            this.getThisLogger().debug(ServiceMessages.QUEUE_MESSAGE_FILE_COUNT, this.getName(), String.valueOf(entriesSize));
        }
        if (lockFile != null) {
            try {
                lockFile.seek(0L);
                lockFile.setLength(0L);
                lockFile.writeBytes(String.valueOf(messageCount));
                lockFile.close();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        this.getThisLogger().debug(ServiceMessages.TEAR_DOWN_COMPLETED, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onReceiverClosed(Queue.Receiver receiver) {
        Object object = this._queueMutex;
        synchronized (object) {
            this._queueMutex.notifyAll();
        }
        super.onReceiverClosed(receiver);
    }

    @Nonnull
    @CheckReturnValue
    String _entryName(@Nonnull String fileName, @Nonnull String suffix) {
        return fileName.substring(this.getEntryPrefix().length(), fileName.length() - suffix.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropEntries(@Nonnull LinkedList<QueueEntry> entries, @Nonnull Optional<QueueEntry> nextEntry, int messageCount) {
        int dropped = 0;
        Object object = this._queueMutex;
        synchronized (object) {
            for (QueueEntry entry : entries) {
                Optional<File> backupFile = entry.getBackupFile();
                if (backupFile.isPresent()) {
                    this._deleteFile(backupFile.get());
                    if (!this._rename(entry.getDataFile(), backupFile.get())) {
                        throw new RuntimeException(Message.format(BaseMessages.FILE_RENAME_FAILED, entry.getDataFile(), backupFile));
                    }
                } else if (!this._deleteFile(entry.getDataFile())) {
                    throw new RuntimeException(Message.format(BaseMessages.FILE_DELETE_FAILED, entry.getDataFile()));
                }
                if (entry.getNextPosition() > 0L && !this._deleteFile(entry.getNextFile())) {
                    throw new RuntimeException(Message.format(BaseMessages.FILE_DELETE_FAILED, entry.getNextFile()));
                }
                this._entries.remove(entry.getName());
                this._info.updateFileCount(-1);
                this._info.updateFilesSize(-entry.getFileSize());
                ++dropped;
            }
            if (nextEntry.isPresent()) {
                try {
                    OutputStreamWriter nextWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(nextEntry.get().getNextFile()), StandardCharsets.UTF_8);
                    nextWriter.write(Long.toString(nextEntry.get().getNextPosition()));
                    ((Writer)nextWriter).close();
                }
                catch (IOException exception) {
                    throw new RuntimeException(Message.format(ServiceMessages.WRITE_FAILED, nextEntry.get().getNextFile(), exception.getMessage()));
                }
            }
            this._info.updateMessageCount(-messageCount);
            this._info.setLastReceiverCommit(DateTime.now());
        }
        this.getStats().transactionsSent(dropped, messageCount);
    }

    @Nonnull
    @CheckReturnValue
    String getEntryPrefix() {
        return this._entryPrefix;
    }

    @Nonnull
    @CheckReturnValue
    Streamer getStreamer() {
        return this._streamer;
    }

    @CheckReturnValue
    boolean isCompressed() {
        return this._compressed;
    }

    @Nonnull
    @CheckReturnValue
    QueueEntry newEntry() {
        return new QueueEntry(this, this._newEntryName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    Optional<QueueEntry> nextEntry(@Nonnull Optional<QueueEntry> previousEntry) {
        QueueEntry nextEntry = null;
        Object object = this._queueMutex;
        synchronized (object) {
            if (!this._entries.isEmpty()) {
                Map.Entry<String, QueueEntry> entry;
                nextEntry = previousEntry.isPresent() ? ((entry = this._entries.higherEntry(previousEntry.get().getName())) != null ? entry.getValue() : null) : (QueueEntry)this._entries.get(this._entries.firstKey());
            }
        }
        if (nextEntry != null && !nextEntry.isReady()) {
            nextEntry = null;
        }
        return Optional.ofNullable(nextEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    long purge() {
        long purged;
        this.getThisLogger().trace(ServiceMessages.QUEUE_PURGE_STARTED, this.getName());
        Object object = this._queueMutex;
        synchronized (object) {
            purged = this._info.getMessageCount();
            Iterator i = this._entries.values().iterator();
            while (i.hasNext()) {
                QueueEntry entry = (QueueEntry)i.next();
                if (!entry.isReady()) continue;
                if (!this._deleteFile(entry.getDataFile())) {
                    throw new RuntimeException(Message.format(BaseMessages.FILE_DELETE_FAILED, entry.getDataFile()));
                }
                if (entry.getNextPosition() > 0L && !this._deleteFile(entry.getNextFile())) {
                    throw new RuntimeException(Message.format(BaseMessages.FILE_DELETE_FAILED, entry.getNextFile()));
                }
                i.remove();
            }
            this._info.clearMessageCount();
            this._info.clearFilesSize();
        }
        if (purged > 0L) {
            this.getThisLogger().debug(ServiceMessages.PURGED_MESSAGES, String.valueOf(purged), this.getName());
        }
        this.getThisLogger().trace(ServiceMessages.QUEUE_PURGE_COMPLETED, this.getName());
        return purged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseEntry(@Nonnull QueueEntry entry, int messageCount) {
        Object object = this._queueMutex;
        synchronized (object) {
            QueueEntry lastEntry;
            boolean merge;
            File transFile = entry.getTransFile();
            boolean bl = merge = this._mergeLimit >= messageCount && !this._entries.isEmpty();
            if (merge) {
                lastEntry = (QueueEntry)this._entries.get(this._entries.lastKey());
                merge = !lastEntry.isBusy() && lastEntry.getMessageCount() <= (long)this._mergeSplit;
            } else {
                lastEntry = null;
            }
            if (merge) {
                File lastFile = lastEntry.getDataFile();
                try {
                    FileOutputStream outputStream = new FileOutputStream(lastFile, true);
                    Files.copy(transFile.toPath(), outputStream);
                    ((OutputStream)outputStream).close();
                    this._deleteFile(transFile);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
                lastEntry.setMesssageCount(lastEntry.getMessageCount() + (long)messageCount);
                long oldFileSize = lastEntry.getFileSize();
                long newFileSize = this._getFileSize(lastFile);
                lastEntry.setFileSize(newFileSize);
                this._info.updateFilesSize(newFileSize - oldFileSize);
            } else {
                entry.setName(this._newEntryName());
                entry.setFileSize(this._getFileSize(transFile));
                if (!this._rename(transFile, entry.getDataFile())) {
                    throw new RuntimeException(Message.format(BaseMessages.FILE_RENAME_FAILED, entry.getTransFile(), entry.getDataFile()));
                }
                entry.setMesssageCount(messageCount);
                entry.setReady(true);
                this._entries.put(entry.getName(), entry);
                this._info.updateFileCount(1);
                this._info.updateFilesSize(entry.getFileSize());
            }
            this._info.updateMessageCount(messageCount);
            this._info.setLastSenderCommit(DateTime.now());
            this.getStats().transactionReceived(messageCount);
            this._queueMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMessages(long waitMillis) throws InterruptedException {
        Object object = this._queueMutex;
        synchronized (object) {
            this._queueMutex.wait(waitMillis);
        }
    }

    private static int _getQueueFileRetries() {
        Integer queueFileRetries = _queueFileRetries;
        if (queueFileRetries == null) {
            String queueFileRetriesString = System.getProperty(QUEUE_FILE_RETRIES, DEFAULT_QUEUE_FILE_RETRIES);
            _queueFileRetries = queueFileRetries = Integer.valueOf(queueFileRetriesString);
        }
        return queueFileRetries;
    }

    @CheckReturnValue
    private static long _getQueueFileRetryDelay() {
        ElapsedTime queueFileRetryDelay = _queueFileRetryDelay;
        if (queueFileRetryDelay == null) {
            String queueFileRetryDelayString = System.getProperty(QUEUE_FILE_RETRY_DELAY, DEFAULT_QUEUE_FILE_RETRY_DELAY);
            _queueFileRetryDelay = queueFileRetryDelay = ElapsedTime.fromString(queueFileRetryDelayString);
        }
        return queueFileRetryDelay.toMillis();
    }

    private boolean _countMessages() {
        this._info.clearMessageCount();
        this._info.clearFilesSize();
        for (QueueEntry entry : new ArrayList(this._entries.values())) {
            Streamer.Input input;
            File file = entry.getDataFile();
            long messageCount = 0L;
            try {
                input = this._streamer.newInput(new QueueReader(file, entry.getNextPosition(), this._compressed));
            }
            catch (IOException exception) {
                this.getThisLogger().error(ServiceMessages.FILE_ACCESS_FAILED, file, exception.getMessage());
                return false;
            }
            try {
                while (input.skip()) {
                    ++messageCount;
                }
            }
            catch (RuntimeException exception) {
                this.getThisLogger().warn(ServiceMessages.MESSAGES_COUNT_FAILED, file, exception.getMessage());
                input.close();
                this._deleteFile(entry.getBadFile());
                if (!this._rename(file, entry.getBadFile())) {
                    this.getThisLogger().error(BaseMessages.FILE_RENAME_FAILED, file, entry.getBadFile());
                    return false;
                }
                this.getThisLogger().warn(ServiceMessages.FILE_RENAMED, file, entry.getBadFile());
                this._entries.remove(entry.getName());
                this._info.updateFileCount(-1);
                continue;
            }
            input.close();
            entry.setMesssageCount(messageCount);
            this._info.updateMessageCount(messageCount);
            entry.setFileSize(this._getFileSize(file));
            this._info.updateFilesSize(entry.getFileSize());
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean _deleteFile(@Nonnull File file) {
        retries = 0;
        while (true) lbl-1000:
        // 2 sources

        {
            try {
                if (!Files.deleteIfExists(file.toPath())) {
                    return false;
                }
                break;
            }
            catch (FileSystemException exception) {
                this.getThisLogger().warn(ServiceMessages.QUEUE_FILE_DELETE_FAILED, new Object[]{this.getDirectoryFile(), file.getName(), exception.getReason()});
                if (++retries > FilesQueue._getQueueFileRetries()) {
                    return false;
                }
                this.getThisLogger().info(ServiceMessages.QUEUE_FILE_WILL_RETRY, new Object[]{String.valueOf(FilesQueue._getQueueFileRetryDelay())});
                try {
                    Thread.sleep(FilesQueue._getQueueFileRetryDelay());
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            ** while (true)
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            break;
        }
        this.getThisLogger().trace(ServiceMessages.QUEUE_FILE_DELETED, new Object[]{this.getDirectoryFile(), file.getName()});
        return true;
    }

    private long _getFileSize(@Nonnull File file) {
        Long fileSize;
        try {
            fileSize = (Long)Files.getAttribute(file.toPath(), "size", new LinkOption[0]);
        }
        catch (IOException exception) {
            this.getThisLogger().warn(ServiceMessages.GET_FILE_SIZE_FAILED, file, exception);
            return 0L;
        }
        return fileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _newEntryName() {
        DateTime entryStamp = DateTime.now();
        Object object = this._queueMutex;
        synchronized (object) {
            if (entryStamp.isNotAfter(this._entryStamp)) {
                entryStamp = this._entryStamp.after();
            }
            this._entryStamp = entryStamp;
        }
        return entryStamp.toFileName();
    }

    private boolean _recover() {
        QueueEntry entry;
        String name;
        File[] files;
        this.getThisLogger().trace(ServiceMessages.QUEUE_RECOVERY_STARTED, this.getName());
        int kept = 0;
        int recovered = 0;
        int dropped = 0;
        for (File file : files = this.listEntryFiles(this._dataSuffix)) {
            name = this._entryName(file.getName(), this._dataSuffix);
            entry = new QueueEntry(this, name);
            entry.setReady(true);
            this._entries.put(name, entry);
            this._info.updateFileCount(1);
            ++kept;
        }
        for (File file : files = this.listEntryFiles(this._nextSuffix)) {
            name = this._entryName(file.getName(), this._nextSuffix);
            entry = (QueueEntry)this._entries.get(name);
            if (entry != null) {
                try {
                    BufferedReader nextReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                    entry.setNextPosition(Long.parseLong(nextReader.readLine()));
                    nextReader.close();
                    continue;
                }
                catch (Exception exception) {
                    this.getThisLogger().error(ServiceMessages.READ_FAILED, file, exception.getMessage());
                    return false;
                }
            }
            this.getThisLogger().warn(ServiceMessages.STALE_FILE, file);
            if (this._deleteFile(file)) continue;
            this.getThisLogger().error(BaseMessages.FILE_DELETE_FAILED, file);
            return false;
        }
        for (File file : files = this.listEntryFiles(this._transSuffix)) {
            name = this._entryName(file.getName(), this._transSuffix);
            if (this.isAutocommit()) {
                entry = new QueueEntry(this, name);
                if (!this._rename(file, entry.getDataFile())) {
                    this.getThisLogger().error(BaseMessages.FILE_RENAME_FAILED, file, entry.getDataFile());
                    return false;
                }
                entry.setReady(true);
                this._entries.put(name, entry);
                this._info.updateFileCount(1);
                ++recovered;
                continue;
            }
            if (!this._deleteFile(file)) {
                this.getThisLogger().error(BaseMessages.FILE_DELETE_FAILED, file);
                return false;
            }
            ++dropped;
        }
        if (!this._entries.isEmpty()) {
            this._entryStamp = DateTime.fromString((String)this._entries.lastKey());
        }
        if (!this._countMessages()) {
            return false;
        }
        long messageCount = this._info.getMessageCount();
        if (this._lockFile != null) {
            String lockLine;
            try {
                this._lockFile.seek(0L);
                lockLine = this._lockFile.readLine();
            }
            catch (IOException exception1) {
                throw new RuntimeException(exception1);
            }
            long savedLength = 0L;
            if (lockLine != null) {
                try {
                    savedLength = Long.parseLong(lockLine.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (messageCount != savedLength) {
                this.getThisLogger().warn(ServiceMessages.QUEUE_LENGTH_CHANGED, this.getName(), String.valueOf(savedLength), String.valueOf(messageCount));
            }
        }
        if (kept + recovered + dropped > 0 && this.getThisLogger().isDebugEnabled()) {
            long filesSize;
            this.getThisLogger().debug(ServiceMessages.QUEUE_ENTRIES, this.getName(), String.valueOf(kept), String.valueOf(recovered), String.valueOf(dropped));
            if (messageCount > 0L) {
                this.getThisLogger().debug(ServiceMessages.QUEUE_MESSAGES, this.getName(), String.valueOf(messageCount));
            }
            if ((filesSize = this._info.getFilesSize()) > 0L) {
                this.getThisLogger().debug(ServiceMessages.QUEUE_MESSAGE_FILES_SIZE, this.getName(), String.valueOf(filesSize));
            }
            if (this._entries.size() > 0) {
                this.getThisLogger().debug(ServiceMessages.QUEUE_MESSAGE_FILE_COUNT, this.getName(), String.valueOf(this._entries.size()));
            }
        }
        this.getStats().recovered(kept, recovered, dropped, recovered);
        this.getThisLogger().trace(ServiceMessages.QUEUE_RECOVERY_COMPLETED, this.getName());
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean _rename(File fromFile, File toFile) {
        retries = 0;
        while (true) lbl-1000:
        // 2 sources

        {
            try {
                Files.move(fromFile.toPath(), toFile.toPath(), new CopyOption[0]);
                break;
            }
            catch (FileSystemException exception) {
                this.getThisLogger().warn(ServiceMessages.QUEUE_FILE_RENAME_FAILED, new Object[]{this.getDirectoryFile(), fromFile.getName(), toFile.getName(), exception.getReason()});
                if (++retries > FilesQueue._getQueueFileRetries()) {
                    return false;
                }
                this.getThisLogger().info(ServiceMessages.QUEUE_FILE_WILL_RETRY, new Object[]{String.valueOf(FilesQueue._getQueueFileRetryDelay())});
                try {
                    Thread.sleep(FilesQueue._getQueueFileRetryDelay());
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            ** while (true)
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            break;
        }
        this.getThisLogger().trace(ServiceMessages.QUEUE_FILE_RENAMED, new Object[]{this.getDirectoryFile(), fromFile.getName(), toFile.getName()});
        return true;
    }

    private String _suffix(KeyedValues somProperties, String suffixProperty, String defaultSuffix) {
        String suffix = somProperties.getString(suffixProperty, Optional.of(defaultSuffix)).get();
        return this._compressedSuffix != null ? suffix + this._compressedSuffix : suffix;
    }
}

