/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.xml.streamer.Streamer;
import org.rvpf.som.queue.FilesQueue;
import org.rvpf.som.queue.Queue;
import org.rvpf.som.queue.QueueEntry;
import org.rvpf.som.queue.QueueReader;

final class FilesReceiver
implements Queue.Receiver {
    private boolean _closed;
    private final LinkedList<QueueEntry> _entries = new LinkedList();
    private QueueEntry _entry;
    private Streamer.Input _input;
    private int _length;
    private final FilesQueue _queue;
    private QueueReader _reader;
    private final Object _receiverMutex = new Object();

    FilesReceiver(@Nonnull FilesQueue queue) {
        this._queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this._receiverMutex;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            try {
                this.rollback();
            }
            catch (ServiceClosedException exception) {
                throw new InternalError(exception);
            }
            this._closed = true;
        }
        this._queue.onReceiverClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws ServiceClosedException {
        Object object = this._receiverMutex;
        synchronized (object) {
            if (this._closed) {
                throw new ServiceClosedException();
            }
            if (this._input != null) {
                long next = this._reader.getNext();
                if (this._input.hasNext()) {
                    this._entry.setNextPosition(next);
                } else if (this._entry != null) {
                    this._entries.addLast(this._entry);
                    this._entry = null;
                }
                this._input.close();
                this._input = null;
                this._reader = null;
            }
            this._queue.dropEntries(this._entries, Optional.ofNullable(this._entry), this._length);
            this._entries.clear();
            this._entry = null;
            this._length = 0;
        }
    }

    @Override
    public long purge() throws ServiceClosedException {
        this.rollback();
        long purged = this._queue.purge();
        this.commit();
        return purged;
    }

    @Override
    public Serializable[] receive(int limit, long timeout) throws ServiceClosedException {
        Serializable message;
        LinkedList<Serializable> messages = new LinkedList<Serializable>();
        boolean insist = true;
        while ((message = this._receive(timeout, insist)) != null) {
            messages.add(message);
            timeout = 0L;
            insist = false;
            if (--limit > 0) continue;
        }
        return messages.toArray(new Serializable[messages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws ServiceClosedException {
        Object object = this._receiverMutex;
        synchronized (object) {
            if (this._closed) {
                throw new ServiceClosedException();
            }
            if (this._input != null) {
                this._input.close();
                this._input = null;
                this._reader = null;
            }
            if (this._entry != null) {
                this._entry.setBusy(false);
                this._entry = null;
            }
            for (QueueEntry entry : this._entries) {
                entry.setBusy(false);
            }
            this._entries.clear();
            this._length = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable _receive(long timeout, boolean insist) throws ServiceClosedException {
        Serializable message;
        long startMillis = timeout > 0L ? System.currentTimeMillis() : 0L;
        try {
            while (true) {
                boolean wait;
                Object object = this._receiverMutex;
                synchronized (object) {
                    if (this._closed) {
                        throw new ServiceClosedException();
                    }
                    if (this._entry == null) {
                        Optional<QueueEntry> previousEntry = this._entries.isEmpty() ? Optional.empty() : Optional.of(this._entries.getLast());
                        this._entry = this._queue.nextEntry(previousEntry).orElse(null);
                        if (this._entry != null) {
                            this._entry.setBusy(true);
                            this._reader = new QueueReader(this._entry.getDataFile(), this._entry.getNextPosition(), this._queue.isCompressed());
                            this._input = this._queue.getStreamer().newInput(this._reader);
                            wait = false;
                        } else {
                            wait = true;
                        }
                    } else {
                        wait = false;
                    }
                }
                if (wait) {
                    long waitMillis;
                    if (timeout == 0L) {
                        return null;
                    }
                    if (timeout > 0L) {
                        long elapsedMillis = System.currentTimeMillis() - startMillis;
                        if (elapsedMillis < 0L || elapsedMillis >= timeout) {
                            return null;
                        }
                        waitMillis = timeout - elapsedMillis;
                    } else {
                        waitMillis = 0L;
                    }
                    this._queue.waitForMessages(waitMillis);
                    continue;
                }
                object = this._queue;
                synchronized (object) {
                    try {
                        message = this._input.next();
                        ++this._length;
                        break;
                    }
                    catch (NoSuchElementException exception) {
                        this._input.close();
                        this._input = null;
                        this._reader = null;
                        this._entries.add(this._entry);
                        this._entry = null;
                        message = null;
                    }
                }
                if (!insist) break;
            }
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (InterruptedException exception) {
            throw new ServiceClosedException(exception);
        }
        catch (ServiceClosedException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return message;
    }
}

