/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.TimeoutMonitor;
import org.rvpf.base.xml.streamer.Streamer;
import org.rvpf.service.ServiceMessages;
import org.rvpf.som.queue.FilesQueue;
import org.rvpf.som.queue.Queue;
import org.rvpf.som.queue.QueueEntry;

final class FilesSender
implements Queue.Sender,
TimeoutMonitor.Client {
    private static final Logger _LOGGER = Logger.getInstance(FilesSender.class);
    private boolean _closed;
    private QueueEntry _entry;
    private boolean _idle;
    private int _length;
    private OutputStream _outputStream;
    private final FilesQueue _queue;
    private final Object _senderMutex = new Object();
    private Streamer.Output _streamerOutput;

    FilesSender(@Nonnull FilesQueue queue) {
        this._queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this._senderMutex;
        synchronized (object) {
            if (!this._closed) {
                Optional<TimeoutMonitor> timeoutMonitor = this._queue.getTimeoutMonitor();
                if (timeoutMonitor.isPresent()) {
                    timeoutMonitor.get().removeClient(this);
                }
                try {
                    if (this._queue.isAutocommit()) {
                        this.commit();
                    } else {
                        this.rollback();
                    }
                }
                catch (ServiceClosedException exception) {
                    throw new InternalError(exception);
                }
                this._queue.onSenderClosed(this);
                this._closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws ServiceClosedException {
        Object object = this._senderMutex;
        synchronized (object) {
            if (this._closed) {
                throw new ServiceClosedException();
            }
            if (this._entry != null) {
                this._closeOutput();
                this._queue.releaseEntry(this._entry, this._length);
                this._entry = null;
                this._length = 0;
            }
            this._monitorTimeout(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimeoutMonitoring() {
        Object object = this._senderMutex;
        synchronized (object) {
            block6: {
                if (this._idle) {
                    try {
                        this.commit();
                        this._idle = true;
                    }
                    catch (ServiceClosedException exception) {
                        Optional<TimeoutMonitor> timeoutMonitor = this._queue.getTimeoutMonitor();
                        if (!timeoutMonitor.isPresent()) break block6;
                        timeoutMonitor.get().removeClient(this);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws ServiceClosedException {
        Object object = this._senderMutex;
        synchronized (object) {
            if (this._closed) {
                throw new ServiceClosedException();
            }
            if (this._entry != null) {
                this._closeOutput();
                if (!this._entry.getTransFile().delete()) {
                    throw new RuntimeException(Message.format(BaseMessages.FILE_DELETE_FAILED, this._entry.getTransFile()));
                }
                _LOGGER.trace(ServiceMessages.QUEUE_FILE_DELETED, this._queue.getDirectoryFile(), this._entry.getTransFile().getName());
                this._entry = null;
                this._length = 0;
            }
            this._monitorTimeout(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Serializable[] messages, boolean commit) throws ServiceClosedException {
        if (messages.length < 1) {
            throw new IllegalArgumentException();
        }
        Object object = this._senderMutex;
        synchronized (object) {
            if (this._closed) {
                throw new ServiceClosedException();
            }
            for (Serializable message : messages) {
                this._doSend(message);
            }
            if (commit) {
                this.commit();
            } else {
                this._flush();
            }
        }
    }

    @GuardedBy(value="_senderMutex")
    private void _closeOutput() {
        if (this._streamerOutput != null) {
            this._streamerOutput.close();
            try {
                this._outputStream.close();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            this._streamerOutput = null;
        }
    }

    @GuardedBy(value="_senderMutex")
    private void _doSend(Serializable message) throws ServiceClosedException {
        Require.notNull(message);
        if (this._entry == null) {
            this._entry = this._queue.newEntry();
            try {
                this._outputStream = new FileOutputStream(this._entry.getTransFile());
                if (this._queue.isCompressed()) {
                    this._outputStream = new GZIPOutputStream(this._outputStream);
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            this._streamerOutput = this._queue.getStreamer().newOutput(this._outputStream, Optional.of(StandardCharsets.UTF_8));
            _LOGGER.trace(ServiceMessages.QUEUE_FILE_CREATED, this._queue.getDirectoryFile(), this._entry.getTransFile().getName());
            this._monitorTimeout(true);
        }
        if (!this._streamerOutput.add(message)) {
            throw new RuntimeException(Message.format(ServiceMessages.MESSAGE_VALIDATION_FAILED, new Object[0]));
        }
        ++this._length;
        if (this._queue.isAutocommit() && this._length >= this._queue.getAutocommitThreshold()) {
            this.commit();
        }
    }

    @GuardedBy(value="_senderMutex")
    private void _flush() throws ServiceClosedException {
        if (this._closed) {
            throw new ServiceClosedException();
        }
        if (this._streamerOutput != null) {
            this._streamerOutput.flush();
        }
        this._idle = false;
    }

    @GuardedBy(value="_senderMutex")
    private void _monitorTimeout(boolean monitor) {
        Optional<TimeoutMonitor> timeoutMonitor = this._queue.getTimeoutMonitor();
        if (timeoutMonitor.isPresent()) {
            if (monitor) {
                timeoutMonitor.get().addClient(this);
            } else {
                timeoutMonitor.get().removeClient(this);
            }
            this._idle = false;
        }
    }
}

