/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.som.QueueInfo;
import org.rvpf.base.tool.TimeoutMonitor;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.service.ServiceMessages;
import org.rvpf.som.queue.Queue;
import org.rvpf.som.queue.QueueStats;

public final class MemoryQueue
extends Queue.Abstract {
    public static final String KEEP_LIMIT_PROPERTY = "keep.limit";
    public static final String RECEIVER_REQUIRED_PROPERTY = "receiver.required";
    private final QueueInfo _info = new QueueInfo();
    private int _keepLimit;
    private final LinkedList<Serializable> _queueMessages = new LinkedList();
    private final Object _queueMutex = new Object();
    private boolean _receiverRequired;
    private boolean _warnedAboutDrop;

    MemoryQueue(@Nonnull String name, @Nonnull QueueStats stats) {
        super(name, stats);
    }

    @Override
    public QueueInfo getInfo() {
        return this._info;
    }

    @Override
    public Receiver newReceiver() {
        Receiver receiver = new Receiver();
        this.onNewReceiver(receiver);
        return receiver;
    }

    @Override
    public Sender newSender() {
        Sender sender = new Sender();
        this.onNewSender(sender);
        return sender;
    }

    @Override
    public boolean setUp(KeyedValues somProperties) {
        if (!super.setUp(somProperties)) {
            return false;
        }
        this.getThisLogger().info(ServiceMessages.QUEUE_IN_MEMORY, this.getName());
        this._keepLimit = somProperties.getInt(KEEP_LIMIT_PROPERTY, 0);
        if (this._keepLimit > 0) {
            this.getThisLogger().info(ServiceMessages.QUEUE_KEEP_LIMIT, this.getName(), String.valueOf(this._keepLimit));
        }
        this._receiverRequired = somProperties.getBoolean(RECEIVER_REQUIRED_PROPERTY);
        if (this._receiverRequired) {
            this.getThisLogger().info(ServiceMessages.QUEUE_RECEIVER_REQUIRED, new Object[0]);
        }
        this.getThisLogger().debug(ServiceMessages.SET_UP_COMPLETED, new Object[0]);
        return true;
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.getThisLogger().debug(ServiceMessages.TEAR_DOWN_COMPLETED, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onReceiverClosed(Queue.Receiver receiver) {
        Object object = this._queueMutex;
        synchronized (object) {
            if (this._receiverRequired) {
                this._purge();
            }
            this._queueMutex.notifyAll();
        }
        super.onReceiverClosed(receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _addMessages(@Nonnull Collection<Serializable> messages) {
        int keepLimit = this._keepLimit > 0 && !this.hasReceiver() ? this._keepLimit : Integer.MAX_VALUE;
        Object object = this._queueMutex;
        synchronized (object) {
            if (!this._receiverRequired || this.hasReceiver()) {
                for (Serializable message : messages) {
                    while (this._queueMessages.size() >= keepLimit) {
                        this._queueMessages.removeFirst();
                        if (!this._warnedAboutDrop) {
                            this.getThisLogger().warn(ServiceMessages.QUEUE_MESSAGES_DROPPED, this.getName(), String.valueOf(keepLimit));
                            this._warnedAboutDrop = true;
                        }
                        this.getThisLogger().trace(ServiceMessages.QUEUE_MESSAGE_DROPPED, this.getName(), message);
                        this._info.updateMessagesDropped(1L);
                    }
                    this._queueMessages.add(message);
                }
                this._queueMutex.notifyAll();
            } else {
                messages = null;
            }
        }
        if (messages != null) {
            this._info.updateMessageCount(messages.size());
            this._info.setLastSenderCommit(DateTime.now());
            this.getStats().transactionReceived(messages.size());
        }
    }

    @CheckReturnValue
    int _getKeepLimit() {
        return this._keepLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    Optional<Serializable> _getMessage() {
        Object object = this._queueMutex;
        synchronized (object) {
            return Optional.ofNullable(this._queueMessages.poll());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _onReceiverCommit(int messageCount) {
        this._info.updateMessageCount(-messageCount);
        this._info.setLastReceiverCommit(DateTime.now());
        this.getStats().transactionsSent(1, messageCount);
        Object object = this._queueMutex;
        synchronized (object) {
            if (this._warnedAboutDrop && this._queueMessages.size() == 0) {
                this.getThisLogger().info(ServiceMessages.QUEUE_EMPTY, this.getName());
                this._warnedAboutDrop = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _purge() {
        int purged;
        Object object = this._queueMutex;
        synchronized (object) {
            purged = this._queueMessages.size();
            this._queueMessages.clear();
        }
        this._info.updateMessageCount(-purged);
        return purged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _putBack(@Nonnull Collection<Serializable> messages) {
        Object object = this._queueMutex;
        synchronized (object) {
            this._queueMessages.addAll(0, messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _waitForMessages(long waitMillis) throws InterruptedException {
        Object object = this._queueMutex;
        synchronized (object) {
            this._queueMutex.wait(waitMillis);
        }
    }

    private final class Sender
    implements Queue.Sender,
    TimeoutMonitor.Client {
        private boolean _closed;
        private boolean _idle;
        private final List<Serializable> _messagesToSend = new LinkedList<Serializable>();
        private final Object _senderMutex = new Object();

        Sender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this._senderMutex;
            synchronized (object) {
                if (!this._closed) {
                    Optional<TimeoutMonitor> timeoutMonitor = MemoryQueue.this.getTimeoutMonitor();
                    if (timeoutMonitor.isPresent()) {
                        timeoutMonitor.get().removeClient(this);
                    }
                    try {
                        if (MemoryQueue.this.isAutocommit()) {
                            this.commit();
                        } else {
                            this.rollback();
                        }
                    }
                    catch (ServiceClosedException exception) {
                        throw new InternalError(exception);
                    }
                    MemoryQueue.this.onSenderClosed(this);
                    this._closed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() throws ServiceClosedException {
            Object object = this._senderMutex;
            synchronized (object) {
                if (this._closed) {
                    throw new ServiceClosedException();
                }
                MemoryQueue.this._addMessages(this._messagesToSend);
                this._messagesToSend.clear();
                this._monitorTimeout(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeoutMonitoring() {
            Object object = this._senderMutex;
            synchronized (object) {
                if (!this._closed) {
                    if (this._idle) {
                        try {
                            this.commit();
                        }
                        catch (ServiceClosedException exception) {
                            throw new InternalError(exception);
                        }
                    }
                    this._idle = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() throws ServiceClosedException {
            Object object = this._senderMutex;
            synchronized (object) {
                if (this._closed) {
                    throw new ServiceClosedException();
                }
                this._messagesToSend.clear();
                this._monitorTimeout(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Serializable[] messages, boolean commit) throws ServiceClosedException {
            Object object = this._senderMutex;
            synchronized (object) {
                boolean wasEmpty = this._messagesToSend.isEmpty();
                Collections.addAll(this._messagesToSend, messages);
                if (commit) {
                    this.commit();
                } else if (MemoryQueue.this.isAutocommit() && this._messagesToSend.size() >= MemoryQueue.this.getAutocommitThreshold()) {
                    this.commit();
                } else if (wasEmpty) {
                    this._monitorTimeout(true);
                } else {
                    this._idle = false;
                }
            }
        }

        private void _monitorTimeout(boolean monitor) {
            Optional<TimeoutMonitor> timeoutMonitor = MemoryQueue.this.getTimeoutMonitor();
            if (timeoutMonitor.isPresent()) {
                if (monitor) {
                    timeoutMonitor.get().addClient(this);
                } else {
                    timeoutMonitor.get().removeClient(this);
                }
                this._idle = false;
            }
        }
    }

    private final class Receiver
    implements Queue.Receiver {
        private boolean _closed;
        private final List<Serializable> _receivedMessages = new LinkedList<Serializable>();
        private final Object _receiverMutex = new Object();

        Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this._receiverMutex;
            synchronized (object) {
                if (this._closed) {
                    return;
                }
                this._closed = true;
            }
            MemoryQueue.this.onReceiverClosed(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() throws ServiceClosedException {
            Object object = this._receiverMutex;
            synchronized (object) {
                if (this._closed) {
                    throw new ServiceClosedException();
                }
                MemoryQueue.this._onReceiverCommit(this._receivedMessages.size());
                this._receivedMessages.clear();
            }
        }

        @Override
        public long purge() throws ServiceClosedException {
            this.rollback();
            MemoryQueue.this.getThisLogger().trace(ServiceMessages.QUEUE_PURGE_STARTED, MemoryQueue.this.getName());
            int purged = MemoryQueue.this._purge();
            if (purged > 0) {
                MemoryQueue.this.getThisLogger().debug(ServiceMessages.PURGED_MESSAGES, String.valueOf(purged), MemoryQueue.this.getName());
            }
            this.commit();
            MemoryQueue.this.getThisLogger().trace(ServiceMessages.QUEUE_PURGE_COMPLETED, MemoryQueue.this.getName());
            return purged;
        }

        @Override
        public Serializable[] receive(int limit, long timeout) throws ServiceClosedException {
            Optional<Serializable> message;
            LinkedList<Serializable> messages = new LinkedList<Serializable>();
            while ((message = this._receive(timeout)).isPresent()) {
                messages.add(message.get());
                timeout = 0L;
                if (--limit > 0) continue;
            }
            return messages.toArray(new Serializable[messages.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() throws ServiceClosedException {
            Object object = this._receiverMutex;
            synchronized (object) {
                if (this._closed) {
                    throw new ServiceClosedException();
                }
                MemoryQueue.this._putBack(this._receivedMessages);
                this._receivedMessages.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Optional<Serializable> _receive(long timeout) throws ServiceClosedException {
            Optional<Serializable> message;
            long startMillis = timeout > 0L ? System.currentTimeMillis() : 0L;
            try {
                while (true) {
                    Object object = this._receiverMutex;
                    synchronized (object) {
                        if (this._closed) {
                            throw new ServiceClosedException();
                        }
                        message = MemoryQueue.this._getMessage();
                        if (message.isPresent()) {
                            this._receivedMessages.add(message.get());
                            break;
                        }
                    }
                    if (timeout != 0L) {
                        long waitMillis;
                        if (timeout > 0L) {
                            long elapsedMillis = System.currentTimeMillis() - startMillis;
                            if (elapsedMillis < 0L || elapsedMillis >= timeout) {
                                return Optional.empty();
                            }
                            waitMillis = timeout - elapsedMillis;
                        } else {
                            waitMillis = 0L;
                        }
                        MemoryQueue.this._waitForMessages(waitMillis);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException exception) {
                throw new ServiceClosedException(exception);
            }
            return message;
        }
    }
}

