/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.som.QueueInfo;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.TimeoutMonitor;
import org.rvpf.base.util.container.ConcurrentIdentityHashSet;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.service.ServiceMessages;
import org.rvpf.som.queue.QueueStats;

interface Queue {
    @Nonnull
    @CheckReturnValue
    public QueueInfo getInfo();

    @Nonnull
    @CheckReturnValue
    public Receiver newReceiver();

    @Nonnull
    @CheckReturnValue
    public Sender newSender();

    @CheckReturnValue
    public boolean setUp(@Nonnull KeyedValues var1);

    public void tearDown();

    public static abstract class Abstract
    implements Queue {
        public static final String AUTOCOMMIT_PROPERTY = "autocommit";
        public static final String AUTOCOMMIT_THRESHOLD_PROPERTY = "autocommit.threshold";
        public static final String AUTOCOMMIT_TIMEOUT_PROPERTY = "autocommit.timeout";
        private boolean _autocommit;
        private int _autocommitThreshold;
        private final Logger _logger = Logger.getInstance(this.getClass());
        private final String _name;
        private volatile Receiver _receiver;
        private final Set<Sender> _senders = new ConcurrentIdentityHashSet<Sender>();
        private final QueueStats _stats;
        private volatile TimeoutMonitor _timeoutMonitor;

        protected Abstract(@Nonnull String name, @Nonnull QueueStats stats) {
            this._name = name;
            this._stats = stats;
        }

        public final void onSenderClosed(@Nonnull Sender sender) {
            if (this._senders.remove(sender)) {
                this.getInfo().updateSenderCount(-1);
            }
        }

        @Override
        @OverridingMethodsMustInvokeSuper
        public boolean setUp(KeyedValues somProperties) {
            ElapsedTime autocommitTimeout = somProperties.getElapsed(AUTOCOMMIT_TIMEOUT_PROPERTY, Optional.empty(), Optional.empty()).orElse(null);
            this._autocommitThreshold = somProperties.getInt(AUTOCOMMIT_THRESHOLD_PROPERTY, -1);
            this._autocommit = somProperties.getBoolean(AUTOCOMMIT_PROPERTY, this._autocommitThreshold > 0 || autocommitTimeout != null);
            this.getThisLogger().debug(this._autocommit ? ServiceMessages.AUTOCOMMIT_ENABLED : ServiceMessages.AUTOCOMMIT_DISABLED, new Object[0]);
            if (this._autocommit) {
                if (this._autocommitThreshold <= 0) {
                    this._autocommitThreshold = Integer.MAX_VALUE;
                }
                if (this._autocommitThreshold < Integer.MAX_VALUE) {
                    this.getThisLogger().debug(ServiceMessages.AUTOCOMMIT_THRESHOLD, String.valueOf(this._autocommitThreshold));
                }
                if (autocommitTimeout != null) {
                    if (autocommitTimeout.toMillis() < 1L) {
                        autocommitTimeout = ElapsedTime.fromMillis(1L);
                    }
                    this.getThisLogger().debug(ServiceMessages.AUTOCOMMIT_TIMEOUT, autocommitTimeout);
                    this._timeoutMonitor = new TimeoutMonitor(autocommitTimeout);
                }
            }
            return true;
        }

        @Override
        public void tearDown() {
            if (this._timeoutMonitor != null) {
                this._timeoutMonitor = null;
                TimeoutMonitor.shutdown();
            }
            for (Sender sender : new ArrayList<Sender>(this._senders)) {
                sender.close();
            }
            Require.success(this._senders.isEmpty());
            this._closeReceiver();
        }

        @CheckReturnValue
        protected int getAutocommitThreshold() {
            return this._autocommitThreshold;
        }

        @Nonnull
        @CheckReturnValue
        protected String getName() {
            return this._name;
        }

        @Nonnull
        @CheckReturnValue
        protected QueueStats getStats() {
            return this._stats;
        }

        @Nonnull
        @CheckReturnValue
        protected final Logger getThisLogger() {
            return this._logger;
        }

        @Nonnull
        @CheckReturnValue
        protected Optional<TimeoutMonitor> getTimeoutMonitor() {
            return Optional.ofNullable(this._timeoutMonitor);
        }

        @CheckReturnValue
        protected boolean hasReceiver() {
            return this._receiver != null;
        }

        @CheckReturnValue
        protected boolean isAutocommit() {
            return this._autocommit;
        }

        protected final synchronized void onNewReceiver(@Nonnull Receiver receiver) {
            this._closeReceiver();
            this._receiver = receiver;
            this.getInfo().setReceiverConnectTime(Optional.of(DateTime.now()));
        }

        protected final void onNewSender(@Nonnull Sender sender) {
            this._senders.add(sender);
            this.getInfo().updateSenderCount(1);
        }

        protected synchronized void onReceiverClosed(@Nonnull Receiver receiver) {
            Require.equal(this._receiver, receiver);
            this._receiver = null;
            this.getInfo().setReceiverConnectTime(Optional.empty());
        }

        private synchronized void _closeReceiver() {
            Receiver receiver = this._receiver;
            if (receiver != null) {
                receiver.close();
                Require.equal(null, this._receiver);
            }
        }
    }

    public static interface Sender {
        public void close();

        public void commit() throws ServiceClosedException;

        public void rollback() throws ServiceClosedException;

        public void send(@Nonnull Serializable[] var1, boolean var2) throws ServiceClosedException;
    }

    public static interface Receiver {
        public void close();

        public void commit() throws ServiceClosedException;

        @CheckReturnValue
        public long purge() throws ServiceClosedException;

        @Nonnull
        @CheckReturnValue
        public Serializable[] receive(int var1, long var2) throws ServiceClosedException;

        public void rollback() throws ServiceClosedException;
    }
}

