/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.io.File;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.rvpf.som.queue.FilesQueue;

final class QueueEntry {
    private boolean _busy;
    private long _fileSize;
    private long _messageCount;
    private String _name;
    private long _nextPosition;
    private final FilesQueue _queue;
    private boolean _ready;

    QueueEntry(@Nonnull FilesQueue queue, @Nonnull String name) {
        this._queue = queue;
        this.setName(name);
    }

    @Nonnull
    @CheckReturnValue
    @GuardedBy(value="_queue")
    Optional<File> getBackupFile() {
        Optional<String> backupType = this._queue.getBackupSuffix();
        return backupType.isPresent() ? Optional.of(this._getFile(backupType.get())) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    @GuardedBy(value="_queue")
    File getBadFile() {
        return this._getFile(this._queue.getBadSuffix());
    }

    @Nonnull
    @CheckReturnValue
    @GuardedBy(value="_queue")
    File getDataFile() {
        return this._getFile(this._queue.getDataSuffix());
    }

    @CheckReturnValue
    @GuardedBy(value="_queue")
    long getFileSize() {
        return this._fileSize;
    }

    @CheckReturnValue
    @GuardedBy(value="_queue")
    long getMessageCount() {
        return this._messageCount;
    }

    @Nonnull
    @CheckReturnValue
    @GuardedBy(value="_queue")
    String getName() {
        return this._name;
    }

    @Nonnull
    @CheckReturnValue
    @GuardedBy(value="_queue")
    File getNextFile() {
        return this._getFile(this._queue.getNextSuffix());
    }

    @CheckReturnValue
    @GuardedBy(value="_queue")
    long getNextPosition() {
        return this._nextPosition;
    }

    @Nonnull
    @CheckReturnValue
    @GuardedBy(value="_queue")
    File getTransFile() {
        return this._getFile(this._queue.getTransSuffix());
    }

    @CheckReturnValue
    @GuardedBy(value="_queue")
    boolean isBusy() {
        return this._busy;
    }

    @CheckReturnValue
    @GuardedBy(value="_queue")
    boolean isReady() {
        return this._ready;
    }

    @GuardedBy(value="_queue")
    void setBusy(boolean busy) {
        this._busy = busy;
    }

    @GuardedBy(value="_queue")
    void setFileSize(long fileSize) {
        this._fileSize = fileSize;
    }

    @GuardedBy(value="_queue")
    void setMesssageCount(long messageCount) {
        this._messageCount = messageCount;
    }

    @GuardedBy(value="_queue")
    void setName(@Nonnull String name) {
        this._name = name;
    }

    @GuardedBy(value="_queue")
    void setNextPosition(long nextPosition) {
        this._nextPosition = nextPosition;
    }

    @GuardedBy(value="_queue")
    void setReady(boolean ready) {
        this._ready = ready;
    }

    @Nonnull
    @CheckReturnValue
    @GuardedBy(value="_queue")
    private File _getFile(@Nonnull String type) {
        return new File(this._queue.getDirectoryFile(), this._queue.getEntryPrefix() + this.getName() + type);
    }
}

