/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Coder;
import org.rvpf.base.tool.Require;

class QueueReader
extends Reader {
    private final Coder _coder = new Coder();
    private final _QueueInputStream _inputStream;

    QueueReader(@Nonnull File inputFile, long next, boolean compressed) throws IOException {
        InputStream inputStream = new FileInputStream(inputFile);
        if (compressed) {
            inputStream = new GZIPInputStream(inputStream);
        }
        if (next > 0L) {
            long skipped = inputStream.skip(next);
            Require.equal(next, skipped);
        }
        this._inputStream = new _QueueInputStream(inputStream, next);
    }

    @Override
    public void close() throws IOException {
        this._inputStream.close();
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        byte[] bytes;
        int read;
        if (length > 1) {
            length /= 2;
        }
        if ((read = this._inputStream.read(bytes = new byte[length], 0, length)) < 1) {
            return read;
        }
        String string = Require.notNull(this._coder.decode(bytes, 0, read));
        string.getChars(0, string.length(), buffer, offset);
        return string.length();
    }

    @CheckReturnValue
    long getNext() {
        return this._inputStream.getNext();
    }

    private static final class _QueueInputStream
    extends BufferedInputStream {
        private long _next;

        _QueueInputStream(@Nonnull InputStream inputStream, long next) {
            super(inputStream);
            this._next = next;
        }

        @Override
        public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
            int byteCount = 0;
            while (byteCount < length) {
                int read = super.read();
                if (read < 0) {
                    if (byteCount != 0) break;
                    return read;
                }
                buffer[offset + byteCount++] = (byte)read;
                if (read != 10 && read != 13 || byteCount <= 1) continue;
                break;
            }
            this._next += (long)byteCount;
            return byteCount;
        }

        @CheckReturnValue
        long getNext() {
            return this._next;
        }
    }
}

