/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.io.File;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.rvpf.base.UUID;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.som.QueueInfo;
import org.rvpf.base.som.QueueServer;
import org.rvpf.base.som.ReceiverActiveException;
import org.rvpf.base.som.ReceiverSession;
import org.rvpf.base.som.SenderSession;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.xml.streamer.Streamer;
import org.rvpf.config.Config;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.SessionImpl;
import org.rvpf.service.rmi.SessionSecurityContext;
import org.rvpf.som.SOMServerImpl;
import org.rvpf.som.SOMSessionImpl;
import org.rvpf.som.SOMStatsHolder;
import org.rvpf.som.queue.FilesQueue;
import org.rvpf.som.queue.MemoryQueue;
import org.rvpf.som.queue.Queue;
import org.rvpf.som.queue.QueueStats;
import org.rvpf.som.queue.ReceiverSessionImpl;
import org.rvpf.som.queue.ReceiverWrapper;
import org.rvpf.som.queue.SenderSessionImpl;
import org.rvpf.som.queue.SenderWrapper;

public final class QueueServerImpl
extends SOMServerImpl
implements QueueServer {
    public static final String BACKUP_ALL_PROPERTY = "service.som.queue.backup";
    public static final String DEFAULT_ROOT = "queue";
    public static final String LOCK_DISABLED_PROPERTY = "service.som.queue.lock.disabled";
    public static final String MEMORY_PROPERTY = "memory";
    public static final String MERGE_LIMIT_ALL_PROPERTY = "service.som.queue.merge.limit";
    public static final String MERGE_SPLIT_ALL_PROPERTY = "service.som.queue.merge.split";
    public static final String ROOT_ALL_PROPERTY = "service.som.queue.root";
    private static final String _RECEIVER = "receiver";
    private static final String _SENDER = "sender";
    private final AtomicReference<Queue> _queue = new AtomicReference();
    private final Object _receiverMutex = new Object();
    private ReceiverSessionImpl _receiverSession;
    private ReceiverWrapper _receiverWrapper;
    private final AtomicReference<QueueStats> _stats = new AtomicReference();

    public QueueServerImpl(@Nonnull Optional<SessionSecurityContext> securityContext) {
        super(securityContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Object object = this._receiverMutex;
        synchronized (object) {
            if (this._receiverWrapper != null) {
                this._receiverWrapper.close();
                this._receiverWrapper = null;
            } else if (this._receiverSession != null) {
                this._receiverSession.close();
                this._receiverSession = null;
            }
        }
    }

    @Override
    public ReceiverSession createReceiverSession(UUID uuid, String clientName) throws SessionException {
        return (ReceiverSession)this.createSession(uuid, new SOMServerImpl.Descriptor(_RECEIVER, clientName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    public ReceiverWrapper createReceiverWrapper() throws ReceiverActiveException {
        Object object = this._receiverMutex;
        synchronized (object) {
            this._dropReceiver();
            this._receiverWrapper = new ReceiverWrapper(this.getQueue().newReceiver(), this);
            return this._receiverWrapper;
        }
    }

    @Override
    public SenderSession createSenderSession(UUID uuid, String clientName) throws SessionException {
        return (SenderSession)this.createSession(uuid, new SOMServerImpl.Descriptor(_SENDER, clientName));
    }

    @Nonnull
    @CheckReturnValue
    public SenderWrapper createSenderWrapper() {
        return new SenderWrapper(this.getQueue().newSender(), this);
    }

    @Override
    public QueueInfo getInfo() {
        return this.getQueue().getInfo();
    }

    @Nonnull
    @CheckReturnValue
    public Queue getQueue() {
        return Require.notNull(this._queue.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSession(SessionImpl session) {
        boolean removed = super.removeSession(session);
        QueueStats stats = this._stats.get();
        if (session instanceof ReceiverSessionImpl) {
            Object object = this._receiverMutex;
            synchronized (object) {
                if (session == this._receiverSession) {
                    this._receiverSession = null;
                }
            }
            if (stats != null) {
                stats.receiverSessionClosed();
            }
        } else if (session instanceof SenderSessionImpl && stats != null) {
            stats.senderSessionClosed();
        }
        return removed;
    }

    @Override
    public boolean setUp(Config config, KeyedGroups queueProperties) {
        Queue.Abstract queue;
        if (!super.setUp(config, queueProperties, "queue/")) {
            return false;
        }
        if (!this.hasSecurityContext()) {
            this.getThisLogger().debug(ServiceMessages.QUEUE_IS_PRIVATE, this.getName());
        }
        SOMStatsHolder statsOwner = new SOMStatsHolder(this.getName());
        QueueStats stats = new QueueStats(statsOwner);
        statsOwner.setStats(stats);
        if (this.hasSecurityContext() && !stats.register(config)) {
            return false;
        }
        this._stats.set(stats);
        if (queueProperties.getBoolean(MEMORY_PROPERTY)) {
            queue = new MemoryQueue(this.getName(), stats);
        } else {
            Streamer streamer = Streamer.newInstance();
            if (streamer == null || !streamer.setUp(Optional.of(config.getProperties()), Optional.of(queueProperties))) {
                return false;
            }
            queue = new FilesQueue(this.getName(), stats, streamer);
            File rootDirectory = Config.dataDir(Optional.of(config.getDataDir()), queueProperties, "root", config.getStringValue(ROOT_ALL_PROPERTY, Optional.of(DEFAULT_ROOT)).orElse(null));
            queueProperties = queueProperties.copy();
            queueProperties.setValue("root", rootDirectory.getAbsolutePath());
            if (!queueProperties.containsValueKey("backup")) {
                QueueServerImpl._setPropertiesValue(queueProperties, "backup", config.getStringValue(BACKUP_ALL_PROPERTY));
            }
            if (!queueProperties.containsValueKey("merge.limit")) {
                QueueServerImpl._setPropertiesValue(queueProperties, "merge.limit", config.getStringValue(MERGE_LIMIT_ALL_PROPERTY));
            }
            if (!queueProperties.containsValueKey("merge.split")) {
                QueueServerImpl._setPropertiesValue(queueProperties, "merge.split", config.getStringValue(MERGE_SPLIT_ALL_PROPERTY));
            }
            QueueServerImpl._setPropertiesValue(queueProperties, "lock.disabled", config.getStringValue(LOCK_DISABLED_PROPERTY));
            queueProperties.freeze();
        }
        if (!queue.setUp(queueProperties)) {
            return false;
        }
        this._queue.set(queue);
        return this.hasSecurityContext() ? this.bind() : true;
    }

    @Override
    public void tearDown() {
        QueueStats stats;
        Queue queue = this._queue.getAndSet(null);
        if (queue != null) {
            if (this.hasSecurityContext()) {
                super.tearDown();
            }
            queue.tearDown();
        }
        if ((stats = (QueueStats)this._stats.getAndSet(null)) != null && this.hasSecurityContext()) {
            stats.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="this")
    protected Session newSession(Session.ConnectionMode connectionMode, Optional<RMIClientSocketFactory> clientSocketFactory, Optional<RMIServerSocketFactory> serverSocketFactory, Object reference) throws ReceiverActiveException {
        SOMSessionImpl session;
        SOMServerImpl.Descriptor descriptor = (SOMServerImpl.Descriptor)reference;
        String modeName = descriptor.getModeName();
        String clientName = descriptor.getClientName();
        if (modeName == _SENDER) {
            session = new SenderSessionImpl(this, connectionMode, clientName);
            this._stats.get().senderSessionOpened();
        } else if (modeName == _RECEIVER) {
            Object object = this._receiverMutex;
            synchronized (object) {
                this._dropReceiver();
                this._receiverSession = new ReceiverSessionImpl(this, connectionMode, clientName);
                session = this._receiverSession;
            }
            this._stats.get().receiverSessionOpened();
        } else {
            throw new AssertionError();
        }
        session.open(clientSocketFactory.orElse(null), serverSocketFactory.orElse(null));
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closed(@Nonnull ReceiverWrapper receiverWrapper) {
        Object object = this._receiverMutex;
        synchronized (object) {
            if (receiverWrapper == this._receiverWrapper) {
                this._receiverWrapper = null;
            }
        }
    }

    private static void _setPropertiesValue(KeyedGroups properties, String propertyName, Optional<String> value) {
        if (value.isPresent()) {
            properties.setValue(propertyName, value.get());
        } else {
            properties.removeValue(propertyName);
        }
    }

    private void _dropReceiver() throws ReceiverActiveException {
        if (this._receiverWrapper != null) {
            throw new ReceiverActiveException();
        }
        if (this._receiverSession != null) {
            this.getThisLogger().warn(ServiceMessages.DROPPING_RECEIVER, this.getName());
            this._receiverSession.close();
            this._receiverSession = null;
            this.getThisLogger().debug(ServiceMessages.DROPPED_RECEIVER, this.getName());
        }
    }
}

