/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.som.QueueInfo;
import org.rvpf.base.tool.Require;
import org.rvpf.som.SOMServerImpl;
import org.rvpf.som.SOMServerWrapper;
import org.rvpf.som.queue.QueueServerImpl;

public abstract class QueueServerWrapper
extends SOMServerWrapper {
    private final AtomicBoolean _dirty = new AtomicBoolean();
    private final QueueServerImpl _queueServer;

    protected QueueServerWrapper(@Nonnull QueueServerImpl queueServer) {
        this._queueServer = Require.notNull(queueServer);
    }

    @Nonnull
    @CheckReturnValue
    public final QueueInfo getInfo() {
        return this._queueServer.getInfo();
    }

    @Nonnull
    @CheckReturnValue
    public final QueueServerImpl getQueueServer() {
        return this._queueServer;
    }

    @CheckReturnValue
    public final boolean isDirty() {
        return this._dirty.get();
    }

    @Override
    protected final SOMServerImpl getServer() {
        return this.getQueueServer();
    }

    final boolean setDirty(boolean dirty) {
        return this._dirty.compareAndSet(!dirty, dirty);
    }
}

