/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.Stats;
import org.rvpf.base.StatsOwner;
import org.rvpf.service.ServiceMessages;
import org.rvpf.som.SOMStats;

@ThreadSafe
public final class QueueStats
extends SOMStats {
    public static final String OBJECT_TYPE = "SOMQueue";
    private static final long serialVersionUID = 1L;
    private AtomicInteger _messagesActive = new AtomicInteger();
    private AtomicInteger _messagesReceived = new AtomicInteger();
    private AtomicInteger _messagesRecovered = new AtomicInteger();
    private AtomicInteger _receiverSessionsClosed = new AtomicInteger();
    private AtomicInteger _receiverSessionsOpened = new AtomicInteger();
    private AtomicInteger _senderSessionsClosed = new AtomicInteger();
    private AtomicInteger _senderSessionsOpened = new AtomicInteger();
    private AtomicInteger _transactionsActive = new AtomicInteger();
    private AtomicInteger _transactionsDropped = new AtomicInteger();
    private AtomicInteger _transactionsKept = new AtomicInteger();
    private AtomicInteger _transactionsReceived = new AtomicInteger();
    private AtomicInteger _transactionsRecovered = new AtomicInteger();

    QueueStats(@Nonnull StatsOwner statsOwner) {
        super(statsOwner);
    }

    @Override
    public void buildText() {
        if (this.getTransactionsKept() + this.getTransactionsRecovered() + this.getTransactionsDropped() > 0) {
            this.addLine(ServiceMessages.QUEUE_TRANSACTIONS_KEPT, String.valueOf(this.getTransactionsKept()), String.valueOf(this.getTransactionsRecovered()), String.valueOf(this.getTransactionsDropped()));
            this.addLine(ServiceMessages.QUEUE_MESSAGES_KEPT, String.valueOf(this.getMessagesRecovered()));
        }
        this.addLine(ServiceMessages.QUEUE_RECEIVER_SESSIONS, String.valueOf(this.getReceiverSessionsOpened()), String.valueOf(this.getReceiverSessionsClosed()));
        this.addLine(ServiceMessages.QUEUE_SENDER_SESSIONS, String.valueOf(this.getSenderSessionsOpened()), String.valueOf(this.getSenderSessionsClosed()));
        this.addLine(ServiceMessages.QUEUE_RECEIVED_STATS, String.valueOf(this.getTransactionsReceived()), String.valueOf(this.getMessagesReceived()));
        this.addLine(ServiceMessages.QUEUE_SENT_STATS, String.valueOf(this.getTransactionsActive()), String.valueOf(this.getMessagesActive()));
        super.buildText();
    }

    @Override
    public Stats clone() {
        QueueStats clone = (QueueStats)super.clone();
        clone._messagesActive = new AtomicInteger(this.getMessagesActive());
        clone._messagesReceived = new AtomicInteger(this.getMessagesReceived());
        clone._messagesRecovered = new AtomicInteger(this.getMessagesRecovered());
        clone._receiverSessionsClosed = new AtomicInteger(this.getReceiverSessionsClosed());
        clone._receiverSessionsOpened = new AtomicInteger(this.getReceiverSessionsOpened());
        clone._senderSessionsClosed = new AtomicInteger(this.getSenderSessionsClosed());
        clone._senderSessionsOpened = new AtomicInteger(this.getSenderSessionsOpened());
        clone._transactionsActive = new AtomicInteger(this.getTransactionsActive());
        clone._transactionsDropped = new AtomicInteger(this.getTransactionsDropped());
        clone._transactionsKept = new AtomicInteger(this.getTransactionsKept());
        clone._transactionsReceived = new AtomicInteger(this.getTransactionsReceived());
        clone._transactionsRecovered = new AtomicInteger(this.getTransactionsRecovered());
        return clone;
    }

    @CheckReturnValue
    public int getMessagesActive() {
        return this._messagesActive.get();
    }

    @CheckReturnValue
    public int getMessagesReceived() {
        return this._messagesReceived.get();
    }

    @CheckReturnValue
    public int getMessagesRecovered() {
        return this._messagesRecovered.get();
    }

    @Override
    public String getObjectType() {
        return OBJECT_TYPE;
    }

    @CheckReturnValue
    public int getReceiverSessionsClosed() {
        return this._receiverSessionsClosed.get();
    }

    @CheckReturnValue
    public int getReceiverSessionsOpened() {
        return this._receiverSessionsOpened.get();
    }

    @CheckReturnValue
    public int getSenderSessionsClosed() {
        return this._senderSessionsClosed.get();
    }

    @CheckReturnValue
    public int getSenderSessionsOpened() {
        return this._senderSessionsOpened.get();
    }

    @CheckReturnValue
    public int getTransactionsActive() {
        return this._transactionsActive.get();
    }

    @CheckReturnValue
    public int getTransactionsDropped() {
        return this._transactionsDropped.get();
    }

    @CheckReturnValue
    public int getTransactionsKept() {
        return this._transactionsKept.get();
    }

    @CheckReturnValue
    public int getTransactionsReceived() {
        return this._transactionsReceived.get();
    }

    @CheckReturnValue
    public int getTransactionsRecovered() {
        return this._transactionsRecovered.get();
    }

    @Override
    protected void substract(Stats snapshot) {
        QueueStats stats = (QueueStats)snapshot;
        this._messagesRecovered.addAndGet(-stats.getMessagesRecovered());
        this._receiverSessionsClosed.addAndGet(-stats.getReceiverSessionsClosed());
        this._receiverSessionsOpened.addAndGet(-stats.getReceiverSessionsOpened());
        this._senderSessionsClosed.addAndGet(-stats.getSenderSessionsClosed());
        this._senderSessionsOpened.addAndGet(-stats.getSenderSessionsOpened());
        this._transactionsDropped.addAndGet(-stats.getTransactionsDropped());
        this._transactionsKept.addAndGet(-stats.getTransactionsKept());
        this._transactionsReceived.addAndGet(-stats.getTransactionsReceived());
        this._transactionsRecovered.addAndGet(-stats.getTransactionsRecovered());
        super.substract(snapshot);
    }

    void receiverSessionClosed() {
        this._receiverSessionsClosed.incrementAndGet();
        this.updated();
    }

    void receiverSessionOpened() {
        this._receiverSessionsOpened.incrementAndGet();
        this.updated();
    }

    void recovered(int transactionsKept, int transactionsRecovered, int transactionsDropped, int messagesRecovered) {
        this._transactionsKept.addAndGet(transactionsKept);
        this._transactionsRecovered.addAndGet(transactionsRecovered);
        this._transactionsDropped.addAndGet(transactionsDropped);
        this._messagesRecovered.addAndGet(messagesRecovered);
        this._transactionsActive.set(transactionsKept + transactionsRecovered);
        this._messagesActive.set(messagesRecovered);
    }

    void senderSessionClosed() {
        this._senderSessionsClosed.incrementAndGet();
        this.updated();
    }

    void senderSessionOpened() {
        this._senderSessionsOpened.incrementAndGet();
        this.updated();
    }

    void transactionReceived(int messages) {
        this._transactionsReceived.incrementAndGet();
        this._messagesReceived.addAndGet(messages);
        this._transactionsActive.incrementAndGet();
        this._messagesActive.addAndGet(messages);
        this.updated();
    }

    void transactionsSent(int transactions, int messages) {
        this._transactionsActive.addAndGet(-transactions);
        this._messagesActive.addAndGet(-messages);
        this.updated();
    }
}

