/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.som.ReceiverSession;
import org.rvpf.service.ServiceMessages;
import org.rvpf.som.SOMSessionImpl;
import org.rvpf.som.queue.Queue;
import org.rvpf.som.queue.QueueServerImpl;

public class ReceiverSessionImpl
extends SOMSessionImpl
implements ReceiverSession {
    private final Queue.Receiver _receiver;

    ReceiverSessionImpl(@Nonnull QueueServerImpl queueServer, @Nonnull Session.ConnectionMode connectionMode, @Nonnull String clientName) {
        super(queueServer, connectionMode, clientName);
        this._receiver = queueServer.getQueue().newReceiver();
    }

    @Override
    public synchronized void close() {
        this._receiver.close();
        super.close();
    }

    @Override
    public void commit() throws SessionException {
        try {
            this.securityCheck("Read");
            this._receiver.commit();
        }
        catch (Error | RuntimeException throwable) {
            this.getThisLogger().warn(throwable, ServiceMessages.UNEXPECTED_SESSION_EXCEPTION, throwable);
            throw throwable;
        }
    }

    @Override
    public long purge() throws SessionException {
        try {
            this.securityCheck("Read");
            return this._receiver.purge();
        }
        catch (Error | RuntimeException throwable) {
            this.getThisLogger().warn(throwable, ServiceMessages.UNEXPECTED_SESSION_EXCEPTION, throwable);
            throw throwable;
        }
    }

    @Override
    public Serializable[] receive(int limit, long timeout) throws SessionException {
        try {
            this.securityCheck("Read");
            return this._receiver.receive(limit, this.adjustTimeout(timeout));
        }
        catch (Error | RuntimeException throwable) {
            this.getThisLogger().warn(throwable, ServiceMessages.UNEXPECTED_SESSION_EXCEPTION, throwable);
            throw throwable;
        }
    }

    @Override
    public void rollback() throws SessionException {
        try {
            this.securityCheck("Read");
            this._receiver.rollback();
        }
        catch (Error | RuntimeException throwable) {
            this.getThisLogger().warn(throwable, ServiceMessages.UNEXPECTED_SESSION_EXCEPTION, throwable);
            throw throwable;
        }
    }

    @Override
    protected String getType() {
        return ServiceMessages.QUEUE_RECEIVER.toString();
    }
}

