/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.som.queue.Queue;
import org.rvpf.som.queue.QueueServerImpl;
import org.rvpf.som.queue.QueueServerWrapper;

public class ReceiverWrapper
extends QueueServerWrapper {
    private final Queue.Receiver _receiver;

    ReceiverWrapper(@Nonnull Queue.Receiver receiver, @Nonnull QueueServerImpl queueServer) {
        super(queueServer);
        this._receiver = receiver;
    }

    public void close() {
        this._receiver.close();
        this.getQueueServer().closed(this);
    }

    public void commit() throws ServiceClosedException {
        if (this.setDirty(false)) {
            this._receiver.commit();
        }
    }

    public long purge() throws ServiceClosedException {
        long purged = this._receiver.purge();
        this.setDirty(false);
        return purged;
    }

    @Nonnull
    @CheckReturnValue
    public Serializable[] receive(int limit, long timeout) throws ServiceClosedException {
        this.setDirty(true);
        return this._receiver.receive(limit, timeout);
    }

    public void rollback() throws ServiceClosedException {
        if (this.setDirty(false)) {
            this._receiver.rollback();
        }
    }
}

