/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.queue;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.som.SenderSession;
import org.rvpf.service.ServiceMessages;
import org.rvpf.som.SOMSessionImpl;
import org.rvpf.som.queue.Queue;
import org.rvpf.som.queue.QueueServerImpl;

public class SenderSessionImpl
extends SOMSessionImpl
implements SenderSession {
    private final Queue.Sender _sender;

    SenderSessionImpl(@Nonnull QueueServerImpl queueServer, @Nonnull Session.ConnectionMode connectionMode, @Nonnull String clientName) {
        super(queueServer, connectionMode, clientName);
        this._sender = queueServer.getQueue().newSender();
    }

    @Override
    public void close() {
        try {
            this.securityCheck("Write");
            this._sender.close();
        }
        catch (SessionException sessionException) {
            // empty catch block
        }
        super.close();
    }

    @Override
    public void commit() throws SessionException {
        try {
            this.securityCheck("Write");
            this._sender.commit();
        }
        catch (Error | RuntimeException throwable) {
            this.getThisLogger().warn(throwable, ServiceMessages.UNEXPECTED_SESSION_EXCEPTION, throwable);
            throw throwable;
        }
    }

    @Override
    public void rollback() throws SessionException {
        try {
            this.securityCheck("Write");
            this._sender.rollback();
        }
        catch (Error | RuntimeException throwable) {
            this.getThisLogger().warn(throwable, ServiceMessages.UNEXPECTED_SESSION_EXCEPTION, throwable);
            throw throwable;
        }
    }

    @Override
    public void send(Serializable[] messages, boolean commit) throws SessionException {
        try {
            this.securityCheck("Write");
            this._sender.send(messages, commit);
        }
        catch (Error | RuntimeException throwable) {
            this.getThisLogger().warn(throwable, ServiceMessages.UNEXPECTED_SESSION_EXCEPTION, throwable);
            throw throwable;
        }
    }

    @Override
    protected String getType() {
        return ServiceMessages.QUEUE_SENDER.toString();
    }
}

