/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.topic;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.tool.Require;
import org.rvpf.som.topic.Topic;
import org.rvpf.som.topic.TopicImpl;

@ThreadSafe
final class PublisherImpl
implements Topic.Publisher {
    private final AtomicBoolean _closed = new AtomicBoolean();
    private final TopicImpl _topic;

    PublisherImpl(@Nonnull TopicImpl topic) {
        this._topic = topic;
    }

    @Override
    public void close() {
        if (this._closed.compareAndSet(false, true)) {
            this._topic.onPublisherClosed(this);
        }
    }

    @Override
    public void send(Serializable[] messages) throws ServiceClosedException {
        if (this._closed.get()) {
            throw new ServiceClosedException();
        }
        for (Serializable message : messages) {
            this._topic.publish(Require.notNull(message));
        }
    }
}

