/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.topic;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.som.PublisherSession;
import org.rvpf.service.ServiceMessages;
import org.rvpf.som.SOMSessionImpl;
import org.rvpf.som.topic.Topic;
import org.rvpf.som.topic.TopicServerImpl;

public class PublisherSessionImpl
extends SOMSessionImpl
implements PublisherSession {
    private final Topic.Publisher _publisher;
    private final TopicServerImpl _topicServer;

    PublisherSessionImpl(@Nonnull TopicServerImpl topicServer, @Nonnull Session.ConnectionMode connectionMode, @Nonnull String clientName) {
        super(topicServer, connectionMode, clientName);
        this._topicServer = topicServer;
        this._publisher = this._topicServer.getTopic().newPublisher();
    }

    @Override
    public void close() {
        super.close();
        this._publisher.close();
    }

    @Override
    public void send(Serializable[] messages) throws SessionException {
        try {
            this.securityCheck("Write");
            this._publisher.send(messages);
        }
        catch (Error | RuntimeException throwable) {
            this.getThisLogger().warn(throwable, ServiceMessages.UNEXPECTED_SESSION_EXCEPTION, throwable);
            throw throwable;
        }
    }

    @Override
    protected String getType() {
        return ServiceMessages.TOPIC_PUBLISHER.toString();
    }
}

