/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.topic;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.som.topic.Topic;
import org.rvpf.som.topic.TopicImpl;

@ThreadSafe
final class SubscriberImpl
implements Topic.Subscriber {
    private final AtomicBoolean _closed = new AtomicBoolean();
    private final Object _closeMutex = new Object();
    private final ConcurrentLinkedDeque<Serializable> _messages = new ConcurrentLinkedDeque();
    private final TopicImpl _topic;

    SubscriberImpl(@Nonnull TopicImpl topic) {
        this._topic = topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this._closeMutex;
        synchronized (object) {
            if (this._closed.compareAndSet(false, true)) {
                this._messages.clear();
                this._topic.onSubscriberClosed(this);
            }
        }
    }

    @Override
    public Serializable[] receive(int limit, long timeout) throws ServiceClosedException {
        LinkedList<Serializable> messages = new LinkedList<Serializable>();
        long startMillis = timeout > 0L ? System.currentTimeMillis() : 0L;
        try {
            do {
                if (this._messages.isEmpty() && !this._closed.get()) {
                    long waitMillis;
                    if (timeout == 0L) break;
                    if (timeout > 0L) {
                        long elapsedMillis = System.currentTimeMillis() - startMillis;
                        waitMillis = timeout - elapsedMillis;
                        if (waitMillis <= 0L) {
                            break;
                        }
                    } else {
                        waitMillis = 0L;
                    }
                    this._topic.waitOnReceive(waitMillis);
                }
                if (this._closed.get()) {
                    throw new ServiceClosedException();
                }
                Serializable message = this._messages.pollFirst();
                if (message == null) continue;
                messages.add(message);
                timeout = 0L;
                --limit;
            } while (limit > 0);
        }
        catch (InterruptedException exception) {
            throw new ServiceClosedException();
        }
        return messages.toArray(new Serializable[messages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean accept(@Nonnull Serializable message) {
        Object object = this._closeMutex;
        synchronized (object) {
            if (this._closed.get()) {
                return false;
            }
            boolean wasEmpty = this._messages.isEmpty();
            this._messages.addLast(message);
            return wasEmpty;
        }
    }
}

